/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.common.CostModel;
import com.mrcrayfish.backpacked.common.PaymentItem;
import com.mrcrayfish.backpacked.common.PaymentType;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public abstract class UnlockableController {
    protected UnlockableSlots cachedSlots;

    public UnlockableController(UnlockableSlots slots) {
        this.cachedSlots = slots;
    }

    public abstract Optional<UnlockableSlots> getSlots(class_1657 var1);

    public abstract void setSlots(class_1657 var1, UnlockableSlots var2);

    public abstract CostModel getCostModel();

    public abstract PaymentItem getPaymentItem();

    public abstract List<class_1263> getPaymentContainers();

    public abstract boolean allowsUnlockToken();

    public int getMaxSlots() {
        return this.cachedSlots.getMaxSlots();
    }

    public final boolean unlockSlot(int slot) {
        UnlockableSlots before = this.cachedSlots;
        this.cachedSlots = this.cachedSlots.unlockSlot(slot);
        return !Objects.equals(this.cachedSlots, before);
    }

    public final boolean isSlotUnlocked(int slot) {
        return this.cachedSlots.isUnlocked(slot);
    }

    public final int getNextUnlockCost(int numberOfSlots) {
        return this.cachedSlots.nextUnlockCost(this.getCostModel(), numberOfSlots);
    }

    public final boolean canAffordNextSlot(class_1657 player, int numberOfSlots) {
        class_1799 carried;
        if (player.method_68878()) {
            return true;
        }
        if (this.allowsUnlockToken() && player.method_45015() && (carried = player.field_7512.method_34255()).method_31574((class_1792)ModItems.UNLOCK_TOKEN.get())) {
            return carried.method_7947() >= numberOfSlots;
        }
        CostModel model = this.getCostModel();
        if (model.getPaymentType() == PaymentType.EXPERIENCE) {
            return player.field_7520 >= this.getNextUnlockCost(numberOfSlots);
        }
        if (model.getPaymentType() == PaymentType.ITEM) {
            PaymentItem payment = this.getPaymentItem();
            int nextCost = this.getNextUnlockCost(numberOfSlots);
            List<class_1263> containers = this.getPaymentContainers();
            return InventoryHelper.hasRemovableItemAndCount(payment.getItem(), nextCost, containers);
        }
        return false;
    }

    private Optional<Runnable> getPaymentJob(class_3222 player, int numberOfSlots) {
        class_1799 carried;
        if (player.method_68878()) {
            return Optional.of(() -> {});
        }
        if (this.allowsUnlockToken() && player.method_45015() && (carried = player.field_7512.method_34255()).method_31574((class_1792)ModItems.UNLOCK_TOKEN.get()) && carried.method_7947() >= numberOfSlots) {
            return Optional.of(() -> {
                carried.method_7934(numberOfSlots);
                player.field_7512.method_34254(carried);
            });
        }
        CostModel model = this.getCostModel();
        if (model.getPaymentType() == PaymentType.EXPERIENCE) {
            int cost = this.getNextUnlockCost(numberOfSlots);
            if (player.field_7520 >= cost) {
                return Optional.of(() -> player.method_7316(-cost));
            }
        } else if (model.getPaymentType() == PaymentType.ITEM) {
            PaymentItem payment = this.getPaymentItem();
            int nextCost = this.getNextUnlockCost(numberOfSlots);
            List<class_1263> containers = this.getPaymentContainers();
            return InventoryHelper.createRemoveItemJob(payment.getItem(), nextCost, containers);
        }
        return Optional.empty();
    }

    public boolean handleUnlockSlot(class_3222 player, int containerIndex) {
        Optional<UnlockableSlots> slotsOptional = this.getSlots((class_1657)player);
        if (slotsOptional.isEmpty()) {
            return false;
        }
        UnlockableSlots slots = slotsOptional.get();
        if (!slots.isUnlockable(containerIndex)) {
            return false;
        }
        Optional<Runnable> paymentJob = this.getPaymentJob(player, 1);
        if (paymentJob.isEmpty()) {
            return false;
        }
        paymentJob.get().run();
        slots = slots.unlockSlot(containerIndex);
        this.setSlots((class_1657)player, slots);
        this.cachedSlots = slots;
        return true;
    }
}

