/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9288;

public abstract class UnlockableContainer
implements class_1263 {
    protected final int size;
    protected final class_2371<class_1799> items;

    public UnlockableContainer(int size) {
        this.size = size;
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    protected abstract UnlockableSlots getUnlockableSlots();

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        UnlockableSlots slots = this.getUnlockableSlots();
        for (int slot = 0; slot < this.size; ++slot) {
            if (!slots.isUnlocked(slot) || ((class_1799)this.items.get(slot)).method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        UnlockableSlots slots = this.getUnlockableSlots();
        return slot >= 0 && slot < this.size && slots.isUnlocked(slot) ? (class_1799)this.items.get(slot) : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int count) {
        UnlockableSlots slots = this.getUnlockableSlots();
        if (slots.isUnlocked(slot)) {
            class_1799 stack = class_1262.method_5430(this.items, (int)slot, (int)count);
            if (!stack.method_7960()) {
                this.method_5431();
            }
            return stack;
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack;
        UnlockableSlots slots = this.getUnlockableSlots();
        if (slots.isUnlocked(slot) && !(stack = (class_1799)this.items.get(slot)).method_7960()) {
            this.items.set(slot, (Object)class_1799.field_8037);
            return stack;
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
        UnlockableSlots slots = this.getUnlockableSlots();
        if (slots.isUnlocked(slot)) {
            this.items.set(slot, (Object)stack);
            stack.method_58408(this.method_58350(stack));
            this.method_5431();
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.getUnlockableSlots().isUnlocked(slot);
    }

    public boolean method_49104(class_1263 container, int slot, class_1799 stack) {
        return this.getUnlockableSlots().isUnlocked(slot);
    }

    public int method_18861(class_1792 item) {
        int count = 0;
        UnlockableSlots slots = this.getUnlockableSlots();
        for (int slot = 0; slot < this.method_5439(); ++slot) {
            class_1799 stack;
            if (!slots.isUnlocked(slot) || !(stack = (class_1799)this.items.get(slot)).method_31574(item)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public boolean method_43256(Predicate<class_1799> predicate) {
        UnlockableSlots slots = this.getUnlockableSlots();
        for (int slot = 0; slot < this.method_5439(); ++slot) {
            class_1799 stack;
            if (!slots.isUnlocked(slot) || !predicate.test(stack = (class_1799)this.items.get(slot))) continue;
            return true;
        }
        return false;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    public void copyFrom(class_9288 contents) {
        contents.method_57492(this.items);
    }

    public class_9288 createContents() {
        return class_9288.method_57493(this.items);
    }

    public void load(class_11368 input) {
        class_1262.method_5429((class_11368)input, this.items);
    }

    public void save(class_11372 output) {
        class_1262.method_5427((class_11372)output, this.items, (boolean)false);
    }

    public class_1799 addItem(class_1799 stack) {
        if (!stack.method_7960()) {
            class_1799 copy = stack.method_7972();
            this.mergeIntoExistingStacks(copy);
            if (!copy.method_7960()) {
                this.moveStackIntoFirstEmptyUnlockedSlot(copy);
            }
            return copy.method_7960() ? class_1799.field_8037 : copy;
        }
        return class_1799.field_8037;
    }

    protected void mergeIntoExistingStacks(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 slotStack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)stack)) continue;
            int maxStackSize = this.method_58350(slotStack);
            int growSize = Math.min(stack.method_7947(), maxStackSize - slotStack.method_7947());
            if (growSize <= 0) continue;
            slotStack.method_7933(growSize);
            stack.method_7934(growSize);
            this.method_5431();
        }
    }

    protected void moveStackIntoFirstEmptyUnlockedSlot(class_1799 stack) {
        UnlockableSlots slots = this.getUnlockableSlots();
        for (int i = 0; i < this.size; ++i) {
            class_1799 slotStack = this.method_5438(i);
            if (!slots.isUnlocked(i) || !slotStack.method_7960() || !this.method_5437(i, stack)) continue;
            this.method_5447(i, stack.method_51164());
            break;
        }
    }
}

