/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.CostModel;
import com.mrcrayfish.backpacked.common.PaymentItem;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.inventory.container.CustomContainerMenu;
import com.mrcrayfish.backpacked.inventory.container.UnlockableController;
import com.mrcrayfish.backpacked.inventory.container.data.ManagementContainerData;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;

public class BackpackManagementMenu
extends CustomContainerMenu {
    private static final class_2960 EMPTY_SLOT = Utils.id("item/empty_backpack_slot");
    private final class_1661 inventory;
    private final class_1263 container;
    private final class_3913 data;
    private final boolean showInventoryButton;

    public BackpackManagementMenu(int windowId, class_1661 inventory, ManagementContainerData customData) {
        this(windowId, inventory, (class_1263)new class_1277(ManagementInventory.getMaxEquipable()), (class_3913)new class_3919(1), customData.slots(), customData.showInventoryButton());
    }

    public BackpackManagementMenu(int windowId, class_1661 inventory, class_1263 container, class_3913 data, UnlockableSlots slots, boolean showInventoryButton) {
        super((class_3917)ModContainers.MANAGEMENT.get(), windowId);
        this.inventory = inventory;
        this.container = container;
        this.data = data;
        this.showInventoryButton = showInventoryButton;
        BackpackManagementMenu.method_17361((class_3913)data, (int)1);
        ManagementUnlockableController controller = new ManagementUnlockableController(slots, List.of(inventory));
        for (int i = 0; i < container.method_5439(); ++i) {
            this.method_7621(new UnlockableSlot(controller, container, i, i * 18 + (176 - container.method_5439() * 18) / 2 + 1, 27).setIcon(EMPTY_SLOT).setPredicate(stack -> stack.method_7909() instanceof BackpackItem));
        }
        this.addPlayerInventorySlots(inventory, 8, 79);
        this.method_17360(data);
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public boolean hadNoBackpacksEquippedOnInitialOpen() {
        return this.data.method_17390(0) == 0;
    }

    public boolean showInventoryButton() {
        return this.showInventoryButton;
    }

    public class_1799 method_7601(class_1657 player, int clickedSlotIndex) {
        class_1799 copy = class_1799.field_8037;
        class_1735 clickedSlot = (class_1735)this.field_7761.get(clickedSlotIndex);
        if (clickedSlot.method_7681()) {
            class_1799 stack = clickedSlot.method_7677();
            copy = stack.method_7972();
            if (clickedSlotIndex < this.container.method_5439() ? !this.method_7616(stack, this.container.method_5439(), this.field_7761.size(), false) : !this.method_7616(stack, 0, this.container.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (stack.method_7960()) {
                clickedSlot.method_53512(class_1799.field_8037);
            } else {
                clickedSlot.method_7668();
            }
        }
        return copy;
    }

    public boolean method_7597(class_1657 player) {
        return this.container.method_5443(player);
    }

    public class_1657 getPlayer() {
        return this.inventory.field_7546;
    }

    public static class ManagementUnlockableController
    extends UnlockableController {
        private final List<class_1263> paymentContainers;

        public ManagementUnlockableController(UnlockableSlots slots, List<class_1263> paymentContainers) {
            super(slots);
            this.paymentContainers = paymentContainers;
        }

        @Override
        public Optional<UnlockableSlots> getSlots(class_1657 player) {
            return Optional.of(BackpackHelper.getBackpackUnlockableSlots(player));
        }

        @Override
        public void setSlots(class_1657 player, UnlockableSlots slots) {
            BackpackHelper.setBackpackUnlockableSlots(player, slots);
        }

        @Override
        public CostModel getCostModel() {
            return Config.BACKPACK.equipable.unlockCost;
        }

        @Override
        public PaymentItem getPaymentItem() {
            return Config.getBackpackPaymentItem();
        }

        @Override
        public List<class_1263> getPaymentContainers() {
            return this.paymentContainers;
        }

        @Override
        public boolean allowsUnlockToken() {
            return (Boolean)Config.BACKPACK.equipable.allowUnlockingUsingUnlockToken.get();
        }
    }
}

