/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.blockentity.BackpackDockBlockEntity;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.common.CostModel;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.PaymentItem;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.container.CustomContainerMenu;
import com.mrcrayfish.backpacked.inventory.container.SyncUnlockableSlots;
import com.mrcrayfish.backpacked.inventory.container.UnlockableController;
import com.mrcrayfish.backpacked.inventory.container.data.BackpackContainerData;
import com.mrcrayfish.backpacked.inventory.container.slot.BackpackSlot;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockSlot;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_9331;

public class BackpackContainerMenu
extends CustomContainerMenu
implements SyncUnlockableSlots {
    public static final int MAX_COLUMNS = 23;
    public static final int MAX_ROWS = 11;
    private final class_1263 backpackInventory;
    private final int ownerId;
    private final int backpackIndex;
    private final int cols;
    private final int rows;
    private final boolean owner;
    private final UnlockableController slotController;
    private final UnlockableController augmentBayController;
    private final Pagination pagination;
    private Augments augments;

    public BackpackContainerMenu(int id, class_1661 playerInventory, BackpackContainerData data) {
        this(id, playerInventory, (class_1263)new class_1277(class_3532.method_15340((int)data.columns(), (int)1, (int)23) * class_3532.method_15340((int)data.rows(), (int)1, (int)11)), -1, data.backpackIndex(), data.columns(), data.rows(), data.owner(), data.slots(), data.pagination(), data.augments(), data.bays());
    }

    public BackpackContainerMenu(int id, class_1661 playerInventory, class_1263 backpackContainer, int ownerId, int backpackIndex, int cols, int rows, boolean owner, UnlockableSlots slots, Pagination pagination, Augments augments, UnlockableSlots bays) {
        super((class_3917)ModContainers.BACKPACK.get(), id);
        this.backpackInventory = backpackContainer;
        this.ownerId = ownerId;
        this.backpackIndex = backpackIndex;
        this.cols = class_3532.method_15340((int)cols, (int)1, (int)23);
        this.rows = class_3532.method_15340((int)rows, (int)1, (int)11);
        this.owner = owner;
        this.pagination = pagination;
        this.slotController = new BackpackUnlockableController(this, slots, List.of(playerInventory, backpackContainer));
        this.augmentBayController = new AugmentUnlockableController(this, bays, List.of(playerInventory, backpackContainer));
        this.augments = augments;
        BackpackContainerMenu.method_17359((class_1263)backpackContainer, (int)(this.cols * this.rows));
        backpackContainer.method_5435((class_11565)playerInventory.field_7546);
        int backpackWidth = 11 + Math.max(162, this.cols * 18) + 11;
        int backpackSlotsWidth = this.cols * 18;
        int backpackSlotsX = Math.max((backpackWidth - backpackSlotsWidth) / 2, 0) + 1;
        int backpackSlotsY = 28;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.method_7621(new BackpackSlot(this.slotController, backpackContainer, x + y * cols, backpackSlotsX + x * 18, backpackSlotsY + y * 18));
            }
        }
        int inventorySlotsWidth = 162;
        int inventorySlotsX = Math.max((backpackWidth - inventorySlotsWidth) / 2, 0) + 1;
        int inventorySlotsY = 26 + this.rows * 18 + 15 + 3 + 19;
        this.addPlayerInventorySlots(playerInventory, inventorySlotsX, inventorySlotsY);
    }

    public class_1263 getBackpackInventory() {
        return this.backpackInventory;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public int getBackpackIndex() {
        return this.backpackIndex;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public UnlockableController getSlotController() {
        return this.slotController;
    }

    public Augments getAugments() {
        return this.augments;
    }

    public void setAugments(Augments augments) {
        this.augments = augments;
    }

    public UnlockableController getAugmentBayController() {
        return this.augmentBayController;
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.backpackInventory.method_5443(playerIn);
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1799 copy = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            copy = slotStack.method_7972();
            if (index < this.rows * this.cols ? !this.method_7616(slotStack, this.rows * this.cols, this.field_7761.size(), true) : !this.method_7616(slotStack, 0, this.rows * this.cols, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return copy;
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        this.backpackInventory.method_5432((class_11565)playerIn);
    }

    private class_1799 getBackpackStack() {
        class_1263 class_12632 = this.backpackInventory;
        if (class_12632 instanceof BackpackDockBlockEntity.ItemStackContainer) {
            BackpackDockBlockEntity.ItemStackContainer container = (BackpackDockBlockEntity.ItemStackContainer)class_12632;
            return container.getBackpackStack();
        }
        class_12632 = this.backpackInventory;
        if (class_12632 instanceof BackpackInventory) {
            BackpackInventory inventory = (BackpackInventory)class_12632;
            return inventory.getBackpackStack();
        }
        return class_1799.field_8037;
    }

    private void sendChanged() {
        class_1263 class_12632 = this.backpackInventory;
        if (class_12632 instanceof BackpackDockBlockEntity.ItemStackContainer) {
            BackpackDockBlockEntity.ItemStackContainer container = (BackpackDockBlockEntity.ItemStackContainer)class_12632;
            container.method_5431();
        } else {
            class_12632 = this.backpackInventory;
            if (class_12632 instanceof BackpackInventory) {
                BackpackInventory inventory = (BackpackInventory)class_12632;
                inventory.method_5431();
            }
        }
    }

    public void openManagement(class_3222 player) {
        class_1263 class_12632 = this.backpackInventory;
        if (class_12632 instanceof ShelfBlockEntity.BackpackShelfContainer) {
            ShelfBlockEntity.BackpackShelfContainer container = (ShelfBlockEntity.BackpackShelfContainer)class_12632;
            container.getBlockEntity().openShelfManagement(player);
        } else if (this.backpackInventory instanceof BackpackInventory) {
            BackpackItem.openBackpackManagement(player, true);
        }
    }

    @Override
    public void handleSyncSlots(class_3222 unlockingPlayer, List<UnlockableSlot> unlockedSlots) {
        List<Integer> slotIndexes = unlockedSlots.stream().map(slot -> slot.field_7874).toList();
        List players = unlockingPlayer.method_51469().method_8503().method_3760().method_14571();
        players.forEach(otherPlayer -> {
            class_1703 patt0$temp = otherPlayer.field_7512;
            if (patt0$temp instanceof BackpackContainerMenu) {
                BackpackContainerMenu otherMenu = (BackpackContainerMenu)patt0$temp;
                if (this.backpackInventory == otherMenu.backpackInventory) {
                    if (otherPlayer != unlockingPlayer) {
                        otherMenu.slotController.cachedSlots = this.slotController.cachedSlots;
                    }
                    Network.PLAY.sendToPlayer(() -> otherPlayer, (Object)new MessageSyncUnlockSlot(slotIndexes));
                }
            }
        });
    }

    private static class BackpackUnlockableController
    extends UnlockableController {
        private final BackpackContainerMenu menu;
        private final List<class_1263> paymentContainers;

        private BackpackUnlockableController(BackpackContainerMenu menu, UnlockableSlots slots, List<class_1263> paymentContainers) {
            super(slots);
            this.menu = menu;
            this.paymentContainers = paymentContainers;
        }

        @Override
        public Optional<UnlockableSlots> getSlots(class_1657 player) {
            class_1799 backpack = this.menu.getBackpackStack();
            if (!backpack.method_7960()) {
                return Optional.ofNullable((UnlockableSlots)backpack.method_58694((class_9331)ModDataComponents.UNLOCKABLE_SLOTS.get()));
            }
            return Optional.empty();
        }

        @Override
        public void setSlots(class_1657 player, UnlockableSlots slots) {
            class_1799 backpack = this.menu.getBackpackStack();
            if (!backpack.method_7960()) {
                backpack.method_57379((class_9331)ModDataComponents.UNLOCKABLE_SLOTS.get(), (Object)slots);
                this.menu.sendChanged();
            }
        }

        @Override
        public CostModel getCostModel() {
            return Config.BACKPACK.inventory.slots.unlockCost;
        }

        @Override
        public PaymentItem getPaymentItem() {
            return Config.getInventoryPaymentItem();
        }

        @Override
        public List<class_1263> getPaymentContainers() {
            return this.paymentContainers;
        }

        @Override
        public boolean allowsUnlockToken() {
            return (Boolean)Config.BACKPACK.inventory.slots.allowUnlockingUsingUnlockToken.get();
        }
    }

    private static class AugmentUnlockableController
    extends UnlockableController {
        private final BackpackContainerMenu menu;
        private final List<class_1263> paymentContainers;

        private AugmentUnlockableController(BackpackContainerMenu menu, UnlockableSlots bays, List<class_1263> paymentContainers) {
            super(bays);
            this.menu = menu;
            this.paymentContainers = paymentContainers;
        }

        @Override
        public Optional<UnlockableSlots> getSlots(class_1657 player) {
            class_1799 backpack = this.menu.getBackpackStack();
            if (!backpack.method_7960()) {
                return Optional.ofNullable(BackpackHelper.getUnlockableAugmentBays(backpack));
            }
            return Optional.empty();
        }

        @Override
        public void setSlots(class_1657 player, UnlockableSlots slots) {
            class_1799 backpack = this.menu.getBackpackStack();
            if (!backpack.method_7960()) {
                backpack.method_57379((class_9331)ModDataComponents.UNLOCKABLE_AUGMENT_BAYS.get(), (Object)slots);
                this.menu.sendChanged();
            }
        }

        @Override
        public CostModel getCostModel() {
            return Config.BACKPACK.augmentBays.unlockCost;
        }

        @Override
        public PaymentItem getPaymentItem() {
            return Config.getAugmentBayPaymentItem();
        }

        @Override
        public List<class_1263> getPaymentContainers() {
            return this.paymentContainers;
        }

        @Override
        public boolean allowsUnlockToken() {
            return (Boolean)Config.BACKPACK.augmentBays.allowUnlockingUsingUnlockToken.get();
        }
    }
}

