/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.impl.HopperBridgeAugment;
import com.mrcrayfish.backpacked.common.backpack.BackpackState;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.inventory.container.UnlockableContainer;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2615;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class BackpackInventory
extends UnlockableContainer {
    private final int index;
    private final class_1657 player;
    private final class_1799 stack;
    private final BackpackState state;
    private boolean save;

    public BackpackInventory(int index, int columns, int rows, class_1657 player, class_1799 stack) {
        super(rows * columns);
        this.index = index;
        this.player = player;
        this.stack = stack;
        this.state = BackpackState.create(stack);
        this.loadBackpackContents();
    }

    private void loadBackpackContents() {
        class_9288 contents = (class_9288)this.stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        contents.method_57492(this.items);
        this.spawnItemsFromLockedSlots();
        class_2371 allItems = class_2371.method_10213((int)256, (Object)class_1799.field_8037);
        contents.method_57492(allItems);
        this.spawnTrailingItems((List<class_1799>)allItems);
    }

    private void spawnTrailingItems(List<class_1799> allItems) {
        for (int i = this.items.size(); i < allItems.size(); ++i) {
            class_1799 stack = allItems.get(i);
            if (stack.method_7960()) continue;
            InventoryHelper.spawnStack(stack, this.player.method_73183(), this.player.method_73189());
        }
    }

    private void spawnItemsFromLockedSlots() {
        class_1792 class_17922 = this.stack.method_7909();
        if (!(class_17922 instanceof BackpackItem)) {
            return;
        }
        BackpackItem item = (BackpackItem)class_17922;
        UnlockableSlots slots = item.getUnlockableSlots(this.stack);
        if (slots == null) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            if (stack.method_7960() || slots.isUnlocked(i)) continue;
            InventoryHelper.spawnStack(stack, this.player.method_73183(), this.player.method_73189());
            this.method_5431();
        }
    }

    public class_1799 getBackpackStack() {
        return this.stack;
    }

    public BackpackState getState() {
        return this.state;
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        return super.method_5437(slot, stack) && BackpackInventory.isAllowedItem(stack);
    }

    @Override
    public boolean method_49104(class_1263 container, int slot, class_1799 stack) {
        HopperBridgeAugment augment;
        if (container instanceof class_2615 && (augment = (HopperBridgeAugment)BackpackHelper.findAugment(this.stack, (AugmentType)ModAugmentTypes.HOPPER_BRIDGE.get())) != null) {
            if (!augment.extract()) {
                return false;
            }
            if (augment.filterMode().checkExtract() && !augment.isFilteringItem(stack.method_7909())) {
                return false;
            }
        }
        return super.method_49104(container, slot, stack);
    }

    @Override
    protected UnlockableSlots getUnlockableSlots() {
        class_1792 class_17922 = this.stack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem item = (BackpackItem)class_17922;
            return item.getUnlockableSlots(this.stack);
        }
        return UnlockableSlots.ALL;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        if (this.stack.method_7960()) {
            return false;
        }
        if (!this.player.method_5805()) {
            return false;
        }
        if (this.getState().isInvalid()) {
            return false;
        }
        if (!BackpackHelper.getBackpackStack(this.player, this.index).equals(this.stack)) {
            return false;
        }
        return this.player.equals((Object)player) || PickpocketUtil.canPickpocketEntity((class_1309)this.player, player, (Double)Config.PICKPOCKETING.maxReachDistance.get() + 0.5);
    }

    public void method_5431() {
        this.save = true;
    }

    public void tick() {
        if (this.save) {
            this.saveItemsToStack();
            this.save = false;
        }
    }

    public void saveItemsToStack() {
        if (!this.stack.method_7960()) {
            this.stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)this.items));
        }
    }

    public static boolean isAllowedItem(class_1799 stack) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (Config.getBannedItemsList().contains(id)) {
            return false;
        }
        if (stack.method_31574(class_1802.field_27023)) {
            return false;
        }
        return stack.method_7909().method_31568();
    }

    public class_1799 findFirst(Predicate<class_1799> predicate) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960() || !predicate.test(stack)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }
}

