/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.unlock;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.framework.api.sync.DataSerializer;
import com.mrcrayfish.framework.api.sync.SyncedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class UnlockTracker
extends SyncedObject {
    public static final class_9139<class_9129, UnlockTracker> STREAM_CODEC = class_9139.method_56437(UnlockTracker::encode, UnlockTracker::decode);
    public static final DataSerializer<UnlockTracker> SERIALIZER = new DataSerializer(STREAM_CODEC, (output, unlockTracker) -> {
        class_11372.class_11373 ids = output.method_71467("UnlockedBackpacks", class_2960.field_25139);
        unlockTracker.unlockedBackpacks.forEach(arg_0 -> ((class_11372.class_11373)ids).method_71484(arg_0));
        class_11372.class_11374 trackers = output.method_71476("ProgressTrackers");
        unlockTracker.backpackToProgressTracker.forEach((id, progressTracker) -> {
            class_11372 subOutput = trackers.method_71480();
            subOutput.method_71468("Id", class_2960.field_25139, id);
            progressTracker.write(subOutput.method_71461("Data"));
        });
    }, input -> {
        UnlockTracker unlockTracker = new UnlockTracker();
        input.method_71435("UnlockedBackpacks", class_2960.field_25139).ifPresent(ids -> ids.forEach(unlockTracker.unlockedBackpacks::add));
        input.method_71436("ProgressTrackers").ifPresent(trackers -> trackers.forEach(subInput -> subInput.method_71426("Id", class_2960.field_25139).ifPresent(id -> {
            IProgressTracker progressTracker = unlockTracker.backpackToProgressTracker.get(id);
            if (progressTracker != null) {
                progressTracker.read(subInput.method_71434("Data"));
            }
        })));
        unlockTracker.removeCompletedProgressTrackers();
        return unlockTracker;
    });
    private final HashSet<class_2960> unlockedBackpacks = new HashSet();
    private final Map<class_2960, IProgressTracker> backpackToProgressTracker;
    private final Map<Class<?>, List<IProgressTracker>> classToIncompleteProgressTrackers;

    public UnlockTracker() {
        HashMap backpackMap = new HashMap();
        HashMap classMap = new HashMap();
        BackpackManager.instance().getBackpacks().forEach(backpack -> {
            IProgressTracker tracker = backpack.createProgressTracker(backpack.getId());
            if (tracker != null) {
                classMap.computeIfAbsent(tracker.getClass(), c -> new ArrayList()).add(tracker);
                backpackMap.put(backpack.getId(), tracker);
            }
        });
        this.backpackToProgressTracker = ImmutableMap.copyOf(backpackMap);
        this.classToIncompleteProgressTrackers = ImmutableMap.copyOf(classMap);
    }

    public Set<class_2960> getUnlockedBackpacks() {
        return Collections.unmodifiableSet(this.unlockedBackpacks);
    }

    public Map<class_2960, IProgressTracker> getProgressTrackerMap() {
        return this.backpackToProgressTracker;
    }

    public boolean isUnlocked(class_2960 id) {
        return this.unlockedBackpacks.contains(id);
    }

    public Optional<IProgressTracker> getProgressTracker(class_2960 backpackId) {
        if (!((Boolean)Config.BACKPACK.cosmetics.unlockAllCosmetics.get()).booleanValue() && !this.unlockedBackpacks.contains(backpackId)) {
            return Optional.ofNullable(this.backpackToProgressTracker.get(backpackId));
        }
        return Optional.empty();
    }

    public <T> List<T> getIncompleteProgressTrackers(Class<T> trackerClass) {
        if (this.classToIncompleteProgressTrackers.containsKey(trackerClass)) {
            return Collections.unmodifiableList(this.classToIncompleteProgressTrackers.get(trackerClass));
        }
        return Collections.emptyList();
    }

    private void removeCompletedProgressTracker(class_2960 id) {
        IProgressTracker tracker = this.backpackToProgressTracker.get(id);
        if (tracker != null && tracker.isComplete()) {
            this.classToIncompleteProgressTrackers.get(tracker.getClass()).remove(tracker);
        }
    }

    private void removeCompletedProgressTrackers() {
        for (class_2960 id : this.unlockedBackpacks) {
            this.removeCompletedProgressTracker(id);
        }
    }

    public boolean unlockBackpack(class_2960 id) {
        if (BackpackManager.instance().getBackpack(id) != null) {
            this.markDirty();
            this.removeCompletedProgressTracker(id);
            return this.unlockedBackpacks.add(id);
        }
        return false;
    }

    private static void encode(class_9129 buf, UnlockTracker tracker) {
        buf.method_34062(tracker.unlockedBackpacks, class_2540::method_10812);
        buf.method_10804(tracker.backpackToProgressTracker.size());
        tracker.backpackToProgressTracker.forEach((id, progressTracker) -> {
            buf.method_10812(id);
            class_8942.class_8943 collector = new class_8942.class_8943();
            class_11362 output = class_11362.method_71459((class_8942)collector, (class_7225.class_7874)buf.method_56349());
            progressTracker.write((class_11372)output);
            buf.method_10794((class_2520)output.method_71475());
        });
    }

    private static UnlockTracker decode(class_9129 buf) {
        UnlockTracker unlockTracker = new UnlockTracker();
        unlockTracker.unlockedBackpacks.addAll(buf.method_34068(HashSet::new, class_2540::method_10810));
        IntStream.range(0, buf.method_10816()).forEach(value -> {
            class_2960 id = buf.method_10810();
            class_2487 tag = buf.method_10798();
            IProgressTracker progressTracker = unlockTracker.backpackToProgressTracker.get(id);
            if (progressTracker != null && tag != null) {
                class_8942.class_8943 collector = new class_8942.class_8943();
                class_11368 input = class_11352.method_71417((class_8942)collector, (class_7225.class_7874)buf.method_56349(), (class_2487)tag);
                progressTracker.read(input);
            }
        });
        unlockTracker.removeCompletedProgressTrackers();
        return unlockTracker;
    }
}

