/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.pickpocket;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.framework.api.sync.DataSerializer;
import com.mrcrayfish.framework.api.sync.SyncedObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3989;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class TraderPickpocketing
extends SyncedObject {
    public static final Codec<TraderPickpocketing> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("Initialized").forGetter(o -> o.initialized), (App)Codec.BOOL.fieldOf("EquippedBackpack").forGetter(o -> o.backpack), (App)Codec.BOOL.fieldOf("SpawnedLoot").forGetter(o -> o.spawnedLoot)).apply((Applicative)instance, TraderPickpocketing::new));
    public static final class_9139<class_9129, TraderPickpocketing> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48547, TraderPickpocketing::isInitialized, (class_9139)class_9135.field_48547, TraderPickpocketing::isBackpackEquipped, (class_9139)class_9135.field_48547, TraderPickpocketing::isLootSpawned, TraderPickpocketing::new);
    public static final DataSerializer<TraderPickpocketing> SERIALIZER = new DataSerializer(STREAM_CODEC, CODEC);
    private boolean initialized = false;
    private boolean backpack = false;
    private boolean spawnedLoot = false;
    private final Map<class_1657, Long> detectedPlayers = new HashMap<class_1657, Long>();
    private final Map<UUID, Long> dislikedPlayers = new HashMap<UUID, Long>();

    public TraderPickpocketing() {
    }

    public TraderPickpocketing(boolean initialized, boolean backpack, boolean spawnedLoot) {
        this.initialized = initialized;
        this.backpack = backpack;
        this.spawnedLoot = spawnedLoot;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
        this.markDirty();
    }

    public void setBackpackEquipped(boolean equipped) {
        this.backpack = equipped;
        this.markDirty();
    }

    public boolean isBackpackEquipped() {
        return this.backpack;
    }

    public boolean isLootSpawned() {
        return this.spawnedLoot;
    }

    public void setLootSpawned() {
        this.spawnedLoot = true;
        this.markDirty();
    }

    public Map<class_1657, Long> getDetectedPlayers() {
        return this.detectedPlayers;
    }

    public boolean isDislikedPlayer(class_1657 player) {
        return this.dislikedPlayers.containsKey(player.method_5667());
    }

    public void addDislikedPlayer(class_1657 player, long time) {
        this.dislikedPlayers.put(player.method_5667(), time);
    }

    public Map<UUID, Long> getDislikedPlayers() {
        return this.dislikedPlayers;
    }

    public static Optional<TraderPickpocketing> get(class_1297 entity) {
        if (entity instanceof class_3989) {
            class_3989 trader = (class_3989)entity;
            return Optional.ofNullable((TraderPickpocketing)((Object)ModSyncedDataKeys.TRADER_PICKPOCKETING.getValue((class_1297)trader)));
        }
        return Optional.empty();
    }
}

