/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker.impl;

import com.mojang.serialization.Codec;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CraftingProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.FrameworkPlayerEvents;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class UniqueCraftingProgressTracker
extends CraftingProgressTracker {
    protected Set<class_2960> craftedItems = new HashSet<class_2960>();

    public UniqueCraftingProgressTracker(int totalCount, ProgressFormatter formatter, Predicate<class_1799> predicate) {
        super(totalCount, formatter, predicate);
    }

    @Override
    protected void processCrafted(class_1799 stack, class_3222 player) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (!this.craftedItems.contains(id) && this.predicate.test(stack)) {
            ++this.count;
            this.craftedItems.add(id);
            this.markForCompletionTest(player);
        }
    }

    @Override
    public void read(class_11368 input) {
        super.read(input);
        this.craftedItems.clear();
        input.method_71435("CraftedItems", (Codec)Codec.STRING).ifPresent(list -> list.forEach(string -> {
            class_2960 id = class_2960.method_12829((String)string);
            if (id != null) {
                this.craftedItems.add(id);
            }
        }));
    }

    @Override
    public void write(class_11372 output) {
        super.write(output);
        class_11372.class_11373 list = output.method_71467("CraftedItems", (Codec)Codec.STRING);
        this.craftedItems.forEach(location -> list.method_71484((Object)location.toString()));
    }

    public static void registerEvent() {
        FrameworkPlayerEvents.CRAFTED_ITEM.register((player, stack, inventory) -> {
            if (player.method_73183().method_8608()) {
                return;
            }
            UnlockManager.getIncompleteTrackers(player, UniqueCraftingProgressTracker.class).forEach(tracker -> tracker.processCrafted(stack, (class_3222)player));
        });
    }
}

