/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker.impl;

import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.framework.api.event.FrameworkPlayerEvents;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class CraftingProgressTracker
implements IProgressTracker {
    protected int count;
    protected final int totalCount;
    private final ProgressFormatter formatter;
    protected final Predicate<class_1799> predicate;

    public CraftingProgressTracker(int totalCount, ProgressFormatter formatter, Predicate<class_1799> predicate) {
        this.totalCount = totalCount;
        this.formatter = formatter;
        this.predicate = predicate;
    }

    protected void processCrafted(class_1799 stack, class_3222 player) {
        if (this.predicate.test(stack)) {
            this.count += stack.method_7947();
            this.markForCompletionTest(player);
        }
    }

    @Override
    public boolean isComplete() {
        return this.count >= this.totalCount;
    }

    @Override
    public void read(class_11368 input) {
        this.count = input.method_71424("Count", 0);
    }

    @Override
    public void write(class_11372 output) {
        output.method_71465("Count", this.count);
    }

    @Override
    public class_2561 getDisplayComponent() {
        return this.formatter.formatter().apply(this.count, this.totalCount);
    }

    @Override
    public double getCompletionProgress() {
        return class_3532.method_15350((double)((double)this.count / (double)Math.max(1, this.totalCount)), (double)0.0, (double)1.0);
    }

    public static void registerEvent() {
        FrameworkPlayerEvents.CRAFTED_ITEM.register((player, stack, inventory) -> {
            if (player.method_73183().method_8608()) {
                return;
            }
            UnlockManager.getIncompleteTrackers(player, CraftingProgressTracker.class).forEach(tracker -> tracker.processCrafted(stack, (class_3222)player));
        });
    }
}

