/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker.impl;

import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class CountProgressTracker
implements IProgressTracker {
    private final ProgressFormatter formatter;
    private final int maxCount;
    private int count;

    public CountProgressTracker(int maxCount, ProgressFormatter formatter) {
        this.maxCount = maxCount;
        this.formatter = formatter;
    }

    public void increment(class_3222 player) {
        ++this.count;
        this.markForCompletionTest(player);
    }

    public void increment(int amount, class_3222 player) {
        this.count += amount;
        this.markForCompletionTest(player);
    }

    @Override
    public boolean isComplete() {
        return this.count >= this.maxCount;
    }

    @Override
    public void read(class_11368 input) {
        this.count = input.method_71424("Count", 0);
    }

    @Override
    public void write(class_11372 output) {
        output.method_71465("Count", this.count);
    }

    @Override
    public class_2561 getDisplayComponent() {
        return this.formatter.formatter().apply(this.count, this.maxCount);
    }

    @Override
    public double getCompletionProgress() {
        return class_3532.method_15350((double)((double)this.count / (double)Math.max(1, this.maxCount)), (double)0.0, (double)1.0);
    }
}

