/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.BlockSnapshot;
import com.mrcrayfish.backpacked.common.challenge.PredicateUtils;
import com.mrcrayfish.backpacked.common.predicates.BlockPositionPredicate;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_3195;
import net.minecraft.class_4550;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

public record BlockSnapshotPredicate(Optional<class_4550> block, Optional<BlockPositionPredicate> position, Optional<class_6885<class_1959>> biomes, Optional<class_6885<class_3195>> structures, Optional<class_5321<class_1937>> dimension) {
    public static final Codec<BlockSnapshotPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_4550.field_45723.optionalFieldOf("block").forGetter(BlockSnapshotPredicate::block), (App)BlockPositionPredicate.CODEC.optionalFieldOf("position").forGetter(BlockSnapshotPredicate::position), (App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("biomes").forGetter(BlockSnapshotPredicate::biomes), (App)class_6895.method_40340((class_5321)class_7924.field_41246).optionalFieldOf("structures").forGetter(BlockSnapshotPredicate::structures), (App)class_5321.method_39154((class_5321)class_7924.field_41223).optionalFieldOf("dimension").forGetter(BlockSnapshotPredicate::dimension)).apply((Applicative)builder, BlockSnapshotPredicate::new));

    public boolean test(BlockSnapshot snapshot) {
        if (!PredicateUtils.match(this.block, snapshot.state(), snapshot.tag())) {
            return false;
        }
        if (!this.position.map(predicate -> predicate.test(snapshot.pos())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.biomes.map(set -> set.method_40241(snapshot.biome())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.structures.map(holders -> snapshot.level().method_27056().method_41034(snapshot.pos(), holders).method_16657()).orElse(true).booleanValue()) {
            return false;
        }
        return this.dimension.map(key -> key == snapshot.level().method_27983()).orElse(true);
    }
}

