/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.MovementType;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.PredicateUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public class TravelDistanceChallenge
extends Challenge {
    public static final ChallengeSerializer<TravelDistanceChallenge> SERIALIZER = new ChallengeSerializer(Utils.id("travel_distance"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)MovementType.LIST_CODEC.xmap(EnumSet::copyOf, List::copyOf).optionalFieldOf("movement").forGetter(challenge -> challenge.movementTypes), (App)class_5699.field_33442.fieldOf("total_distance").forGetter(challenge -> challenge.totalDistanceInCm), (App)class_2048.field_45746.optionalFieldOf("player").forGetter(challenge -> challenge.player)).apply((Applicative)builder, TravelDistanceChallenge::new)));
    private final Optional<EnumSet<MovementType>> movementTypes;
    private final int totalDistanceInCm;
    private final Optional<class_2048> player;

    protected TravelDistanceChallenge(Optional<EnumSet<MovementType>> movementTypes, int totalDistanceInCm, Optional<class_2048> player) {
        this.movementTypes = movementTypes;
        this.totalDistanceInCm = totalDistanceInCm;
        this.player = player;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ProgressFormatter formatter, class_2960 backpackId) {
        return new Tracker(formatter, this.movementTypes, this.totalDistanceInCm, this.player);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<EnumSet<MovementType>> movementTypes;
        private final Optional<class_2048> player;

        public Tracker(ProgressFormatter formatter, Optional<EnumSet<MovementType>> movementTypes, int maxCount, Optional<class_2048> player) {
            super(maxCount, formatter);
            this.movementTypes = movementTypes;
            this.player = player;
        }

        public static void registerEvent() {
            BackpackedEvents.PLAYER_TRAVEL.register((player, distance, type) -> {
                int distanceInCm = Math.round((float)Math.sqrt(distance) * 100.0f);
                UnlockManager.getIncompleteTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                    if (tracker.movementTypes.map(types -> types.contains((Object)type)).orElse(true).booleanValue() && PredicateUtils.match(tracker.player, player)) {
                        tracker.increment(distanceInCm, player);
                    }
                });
            });
        }
    }
}

