/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5699;

public class MerchantTradeChallenge
extends Challenge {
    public static final ChallengeSerializer<MerchantTradeChallenge> SERIALIZER = new ChallengeSerializer(Utils.id("merchant_trade"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2048.field_45746.optionalFieldOf("merchant").forGetter(o -> o.entity), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(o -> o.item), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(o -> o.count)).apply((Applicative)builder, MerchantTradeChallenge::new)));
    private final Optional<class_2048> entity;
    private final Optional<class_2073> item;
    private final int count;

    protected MerchantTradeChallenge(Optional<class_2048> entity, Optional<class_2073> item, int count) {
        this.entity = entity;
        this.item = item;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ProgressFormatter formatter, class_2960 backpackId) {
        return new Tracker(this.count, formatter, this.entity, this.item);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_2048> entity;
        private final Optional<class_2073> item;

        public Tracker(int maxCount, ProgressFormatter formatter, Optional<class_2048> entity, Optional<class_2073> item) {
            super(maxCount, formatter);
            this.entity = entity;
            this.item = item;
        }

        private boolean test(class_3222 player, class_1297 merchant, class_1799 stack) {
            return this.entity.map(p -> p.method_8914(player, merchant)).orElse(true) != false && this.item.map(p -> p.method_8970(stack)).orElse(true) != false;
        }

        public static void registerEvent() {
            BackpackedEvents.MERCHANT_TRADE.register((merchant, player, stack) -> {
                if (player.method_73183().method_8608() || !(merchant instanceof class_1297)) {
                    return;
                }
                class_1297 entity = (class_1297)merchant;
                UnlockManager.getIncompleteTrackers(player, Tracker.class).forEach(tracker -> {
                    class_3222 serverPlayer = (class_3222)player;
                    if (tracker.test(serverPlayer, entity, stack)) {
                        tracker.increment(serverPlayer);
                    }
                });
            });
        }
    }
}

