/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.PredicateUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4550;
import net.minecraft.class_5699;

public class InteractWithBlockChallenge
extends Challenge {
    public static final ChallengeSerializer<InteractWithBlockChallenge> SERIALIZER = new ChallengeSerializer(Utils.id("interact_with_block"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_4550.field_45723.optionalFieldOf("block").forGetter(challenge -> challenge.block), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(challenge -> challenge.item), (App)class_2048.field_45746.optionalFieldOf("player").forGetter(challenge -> challenge.entity), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, InteractWithBlockChallenge::new)));
    private final Optional<class_4550> block;
    private final Optional<class_2073> item;
    private final Optional<class_2048> entity;
    private final int count;

    public InteractWithBlockChallenge(Optional<class_4550> block, Optional<class_2073> item, Optional<class_2048> entity, int count) {
        this.block = block;
        this.item = item;
        this.entity = entity;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ProgressFormatter formatter, class_2960 backpackId) {
        return new Tracker(this.count, formatter, this.block, this.item, this.entity);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_4550> block;
        private final Optional<class_2073> item;
        private final Optional<class_2048> entity;

        private Tracker(int maxCount, ProgressFormatter formatter, Optional<class_4550> block, Optional<class_2073> item, Optional<class_2048> entity) {
            super(maxCount, formatter);
            this.block = block;
            this.item = item;
            this.entity = entity;
        }

        private boolean test(class_2680 state, class_1799 stack, class_3222 player) {
            return PredicateUtils.match(this.block, state, null) && PredicateUtils.match(this.item, stack) && PredicateUtils.match(this.entity, player);
        }

        public static void registerEvent() {
            BackpackedEvents.INTERACTED_WITH_BLOCK_CAPTURE_TAG.register((state, stack, player) -> UnlockManager.getIncompleteTrackers((class_1657)player, Tracker.class).stream().anyMatch(tracker -> tracker.test(state, stack, player)));
            BackpackedEvents.INTERACTED_WITH_BLOCK.register((state, stack, tag, player) -> UnlockManager.getIncompleteTrackers((class_1657)player, Tracker.class).forEach(tracker -> {
                if (tracker.test(state, stack, player)) {
                    tracker.increment(player);
                }
            }));
        }
    }
}

