/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5699;

public class FeedAnimalChallenge
extends Challenge {
    public static final ChallengeSerializer<FeedAnimalChallenge> SERIALIZER = new ChallengeSerializer(Utils.id("feed_animal"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2048.field_45746.optionalFieldOf("animal").forGetter(challenge -> challenge.entity), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, FeedAnimalChallenge::new)));
    private final Optional<class_2048> entity;
    private final int count;

    public FeedAnimalChallenge(Optional<class_2048> entity, int count) {
        this.entity = entity;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ProgressFormatter formatter, class_2960 backpackId) {
        return new Tracker(this.count, formatter, this.entity);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<class_2048> entityPredicate;

        private Tracker(int maxCount, ProgressFormatter formatter, Optional<class_2048> entityPredicate) {
            super(maxCount, formatter);
            this.entityPredicate = entityPredicate;
        }

        private boolean test(class_3222 player, class_1429 animal) {
            return this.entityPredicate.map(p -> p.method_8914(player, (class_1297)animal)).orElse(true);
        }

        public static void registerEvent() {
            BackpackedEvents.FEED_ANIMAL.register((animal, player) -> {
                if (player.method_73183().method_8608()) {
                    return;
                }
                UnlockManager.getIncompleteTrackers(player, Tracker.class).forEach(tracker -> {
                    class_3222 serverPlayer = (class_3222)player;
                    if (tracker.test(serverPlayer, animal)) {
                        tracker.increment(serverPlayer);
                    }
                });
            });
        }
    }
}

