/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ExploreBiomeChallenge
extends Challenge {
    public static final Codec<List<class_5321<class_1959>>> BIOME_LIST_CODEC = Codec.either((Codec)class_5321.method_39154((class_5321)class_7924.field_41236), (Codec)class_5321.method_39154((class_5321)class_7924.field_41236).listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), keys -> keys.size() == 1 ? Either.left((Object)((class_5321)keys.getFirst())) : Either.right((Object)keys)).validate(keys -> keys.isEmpty() ? DataResult.error(() -> "Must specify at least one biome") : DataResult.success((Object)keys));
    public static final ChallengeSerializer<ExploreBiomeChallenge> SERIALIZER = new ChallengeSerializer(Utils.id("explore_biome"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)BIOME_LIST_CODEC.fieldOf("biome").forGetter(challenge -> challenge.biomes)).apply((Applicative)builder, ExploreBiomeChallenge::new)));
    private final List<class_5321<class_1959>> biomes;

    public ExploreBiomeChallenge(List<class_5321<class_1959>> biomes) {
        this.biomes = biomes;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ProgressFormatter formatter, class_2960 backpackId) {
        return new Tracker(formatter, this.biomes);
    }

    public static class Tracker
    implements IProgressTracker {
        private final ProgressFormatter formatter;
        private final ImmutableSet<class_5321<class_1959>> biomes;
        private final Set<class_2960> exploredBiomes = new HashSet<class_2960>();

        private Tracker(ProgressFormatter formatter, List<class_5321<class_1959>> biomes) {
            this.formatter = formatter;
            this.biomes = ImmutableSet.copyOf(biomes);
        }

        private void explore(class_5321<class_1959> biome, class_3222 player) {
            if (this.biomes.contains(biome)) {
                this.exploredBiomes.add(biome.method_29177());
                this.markForCompletionTest(player);
            }
        }

        @Override
        public boolean isComplete() {
            return this.exploredBiomes.size() >= this.biomes.size();
        }

        @Override
        public void read(class_11368 input) {
            this.exploredBiomes.clear();
            class_11368.class_11369 list = input.method_71437("ExploredBiomes", (Codec)Codec.STRING);
            list.forEach(biome -> {
                class_2960 id = class_2960.method_12829((String)biome);
                if (id != null && this.biomes.stream().anyMatch(key -> key.method_29177().equals((Object)id))) {
                    this.exploredBiomes.add(id);
                }
            });
        }

        @Override
        public void write(class_11372 output) {
            class_11372.class_11373 list = output.method_71467("ExploredBiomes", (Codec)Codec.STRING);
            this.exploredBiomes.forEach(location -> list.method_71484((Object)location.toString()));
        }

        @Override
        public class_2561 getDisplayComponent() {
            return this.formatter.formatter().apply(this.exploredBiomes.size(), this.biomes.size());
        }

        @Override
        public double getCompletionProgress() {
            return class_3532.method_15350((double)((double)this.exploredBiomes.size() / (double)Math.max(1, this.biomes.size())), (double)0.0, (double)1.0);
        }

        public static void registerEvent() {
            BackpackedEvents.EXPLORE_UPDATE.register((key, player) -> {
                if (player.method_73183().method_8608()) {
                    return;
                }
                UnlockManager.getIncompleteTrackers(player, Tracker.class).forEach(tracker -> tracker.explore((class_5321<class_1959>)key, (class_3222)player));
            });
        }
    }
}

