/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.predicates.CraftedItemPredicate;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.util.Utils;
import com.mrcrayfish.framework.api.event.FrameworkPlayerEvents;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5699;

public class CraftItemChallenge
extends Challenge {
    public static final ChallengeSerializer<CraftItemChallenge> SERIALIZER = new ChallengeSerializer(Utils.id("craft_item"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)CraftedItemPredicate.CODEC.optionalFieldOf("crafted_item").forGetter(challenge -> challenge.predicate), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, CraftItemChallenge::new)));
    private final Optional<CraftedItemPredicate> predicate;
    private final int count;

    public CraftItemChallenge(Optional<CraftedItemPredicate> predicate, int count) {
        this.predicate = predicate;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ProgressFormatter formatter, class_2960 backpackId) {
        return new Tracker(formatter, this.predicate, this.count);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<CraftedItemPredicate> predicate;

        public Tracker(ProgressFormatter formatter, Optional<CraftedItemPredicate> predicate, int maxCount) {
            super(maxCount, formatter);
            this.predicate = predicate;
        }

        public static void registerEvent() {
            FrameworkPlayerEvents.CRAFTED_ITEM.register((player, stack, inventory) -> {
                if (player.method_73183().method_8608()) {
                    return;
                }
                UnlockManager.getIncompleteTrackers(player, Tracker.class).forEach(tracker -> {
                    if (tracker.predicate.map(p -> p.test(stack)).orElse(true).booleanValue()) {
                        tracker.increment(stack.method_7947(), (class_3222)player);
                    }
                });
            });
        }
    }
}

