/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11341;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;

public class BackpackLoader
extends class_4080<Map<class_2960, Backpack>> {
    public static final class_2960 ID = Utils.id("backpack_loader");
    private static final class_7654 DIRECTORY = class_7654.method_45114((String)"backpacked");
    private final class_7225.class_7874 provider;

    public BackpackLoader(class_7225.class_7874 provider) {
        this.provider = provider;
    }

    protected class_7225.class_7874 getProvider() {
        return this.provider;
    }

    protected Map<class_2960, Backpack> prepare(class_3300 manager, class_3695 filler) {
        HashMap<class_2960, Backpack> backpacks = new HashMap<class_2960, Backpack>();
        for (Map.Entry entry : DIRECTORY.method_45113(manager).entrySet()) {
            class_2960 fileId = (class_2960)entry.getKey();
            class_2960 backpackId = DIRECTORY.method_45115(fileId);
            if (backpackId.method_12832().contains("/")) {
                Constants.LOG.warn("Ignoring backpack '{}' as it was in a sub-directory", (Object)backpackId);
                continue;
            }
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    String modId;
                    JsonElement element = class_11341.method_71359((Reader)reader);
                    JsonObject object = element.getAsJsonObject();
                    if (object.has("mod_loaded") && object.get("mod_loaded").isJsonPrimitive() && !Services.PLATFORM.isModLoaded(modId = object.get("mod_loaded").getAsString())) continue;
                    class_6903 ops = this.getProvider().method_57093((DynamicOps)JsonOps.INSTANCE);
                    DataResult result = Backpack.CODEC.parse((DynamicOps)ops, (Object)object);
                    result.promotePartial(s -> {
                        Backpack backpack = (Backpack)result.getPartialOrThrow(msg -> new JsonParseException("Failed to load backpack the backpack '" + String.valueOf(backpackId) + "': " + msg));
                        Constants.LOG.error("An error occurred when loading the backpack '{}': {}. It will still be registered, it just may not work correctly.", (Object)backpackId, s);
                        backpack.markErrored();
                    });
                    result.resultOrPartial().ifPresent(backpack -> {
                        backpack.setup(backpackId);
                        backpacks.put(backpackId, (Backpack)backpack);
                        Constants.LOG.info("Adding backpack '{}'", (Object)backpackId);
                    });
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                Constants.LOG.error("Unable to parse backpack file '{}' from '{}'", new Object[]{backpackId, fileId, exception});
            }
        }
        return backpacks;
    }

    protected void apply(Map<class_2960, Backpack> backpacks, class_3300 manager, class_3695 filler) {
        BackpackManager.instance().updateBackpacks(backpacks);
    }
}

