/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncBackpacks;
import com.mrcrayfish.backpacked.network.message.MessageUnlockBackpack;
import com.mrcrayfish.backpacked.util.Utils;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class BackpackManager {
    private static final class_2960 FALLBACK_MODEL = Utils.id("vintage");
    private static class_2960 defaultCosmetic;
    private static BackpackManager instance;
    private Map<class_2960, Backpack> loadedBackpacks = new HashMap<class_2960, Backpack>();

    public static BackpackManager instance() {
        if (instance == null) {
            instance = new BackpackManager();
        }
        return instance;
    }

    private BackpackManager() {
        FrameworkConfigEvents.LOAD.register(object -> {
            if (object == Config.BACKPACK) {
                BackpackManager.updateDefaultCosmetic();
            }
        });
        FrameworkConfigEvents.RELOAD.register(object -> {
            if (object == Config.BACKPACK) {
                BackpackManager.updateDefaultCosmetic();
            }
        });
    }

    public void updateBackpacks(Map<class_2960, Backpack> map) {
        this.loadedBackpacks = map;
    }

    @Nullable
    public Backpack getBackpack(class_2960 id) {
        return this.loadedBackpacks.get(id);
    }

    public List<Backpack> getBackpacks() {
        return ImmutableList.copyOf(this.loadedBackpacks.values());
    }

    public void unlockBackpack(class_3222 player, class_2960 id) {
        if (((Boolean)Config.BACKPACK.cosmetics.unlockAllCosmetics.get()).booleanValue()) {
            return;
        }
        if (!this.loadedBackpacks.containsKey(id)) {
            return;
        }
        UnlockManager.getTracker((class_1657)player).ifPresent(impl -> {
            if (impl.unlockBackpack(id)) {
                Network.getPlay().sendToPlayer(() -> player, (Object)new MessageUnlockBackpack(id));
            }
        });
    }

    public MessageSyncBackpacks getSyncMessage() {
        return new MessageSyncBackpacks(this.getBackpacks());
    }

    private static void updateDefaultCosmetic() {
        defaultCosmetic = class_2960.method_12829((String)((String)Config.BACKPACK.cosmetics.defaultCosmetic.get()));
    }

    @Nullable
    public static class_2960 getDefaultCosmetic() {
        return defaultCosmetic;
    }

    public static class_2960 getDefaultOrFallbackCosmetic() {
        return defaultCosmetic != null ? defaultCosmetic : FALLBACK_MODEL;
    }
}

