/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.challenge.UnlockChallenge;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class Backpack {
    public static final class_9139<class_2540, Backpack> STREAM_CODEC = class_9139.method_56437((buf, backpack) -> {
        backpack.checkSetup();
        buf.method_10812(backpack.id);
        buf.method_52964(backpack.unlockChallenge.isPresent());
        buf.method_52964(backpack.error);
    }, Backpack::new);
    public static final class_9139<class_2540, List<Backpack>> LIST_STREAM_CODEC = STREAM_CODEC.method_56433(class_9135.method_56374(class_2371::method_37434));
    public static final Codec<Backpack> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)UnlockChallenge.CODEC.optionalFieldOf("unlock_challenge").forGetter(backpack -> backpack.unlockChallenge)).apply((Applicative)builder, Backpack::new));
    private final Optional<UnlockChallenge> unlockChallenge;
    private class_2960 id;
    private String translationKey;
    private boolean setup = false;
    private boolean error = false;

    public Backpack(Optional<UnlockChallenge> unlockChallenge) {
        this.unlockChallenge = unlockChallenge;
    }

    public Backpack(class_2540 buf) {
        class_2960 id = buf.method_10810();
        this.setup(id);
        this.unlockChallenge = buf.readBoolean() ? Optional.of(UnlockChallenge.DUMMY) : Optional.empty();
        this.error = buf.readBoolean();
    }

    public Optional<UnlockChallenge> getUnlockChallenge() {
        return this.unlockChallenge;
    }

    public class_2960 getId() {
        this.checkSetup();
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isUnlocked(class_1657 player) {
        return UnlockManager.getTracker(player).map(tracker -> tracker.isUnlocked(this.id)).orElse(false) != false || this.unlockChallenge.isEmpty() || (Boolean)Config.BACKPACK.cosmetics.unlockAllCosmetics.get() != false;
    }

    @Nullable
    public IProgressTracker createProgressTracker(class_2960 backpackId) {
        return this.unlockChallenge.map(c -> c.challenge().createProgressTracker(c.formatter(), backpackId)).orElse(null);
    }

    public void setup(class_2960 id) {
        if (!this.setup) {
            this.id = id;
            this.translationKey = "backpack.%s.%s".formatted(id.method_12836(), id.method_12832());
            this.setup = true;
        }
    }

    protected void checkSetup() {
        if (!this.setup) {
            throw new RuntimeException("Backpack is not setup");
        }
    }

    public void markErrored() {
        this.error = true;
    }

    public boolean isErrored() {
        return this.error;
    }
}

