/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.data.Recall;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2591;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public record RecallAugment(Optional<ShelfKey> shelfKey) implements Augment<RecallAugment>
{
    public static final RecallAugment EMPTY = new RecallAugment(Optional.empty());
    public static final AugmentType<RecallAugment> TYPE = new AugmentType<RecallAugment>(Utils.id("recall"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShelfKey.CODEC.optionalFieldOf("shelf_key").forGetter(RecallAugment::shelfKey)).apply((Applicative)instance, RecallAugment::new)), class_9139.method_56434((class_9139)class_9135.method_56382(ShelfKey.STREAM_CODEC), RecallAugment::shelfKey, RecallAugment::new), () -> new RecallAugment(Optional.empty()));
    public static final int UPDATE_SHELF_RANGE_SQR = 256;

    @Override
    public AugmentType<RecallAugment> type() {
        return TYPE;
    }

    @Override
    public RecallAugment onUpdate(class_3222 player, Augment<?> current) {
        RecallAugment a;
        RecallAugment other;
        RecallAugment updated = this;
        RecallAugment recallAugment = other = current instanceof RecallAugment ? (a = (RecallAugment)current) : EMPTY;
        if (this.shelfKey.isPresent() && !Objects.equals(this.shelfKey, other.shelfKey)) {
            ShelfKey shelfKey = this.shelfKey.get();
            MinecraftServer server = player.method_51469().method_8503();
            class_3218 level = server.method_3847(shelfKey.level());
            if (level != null) {
                Recall recall;
                class_2338 pos = class_2338.method_10092((long)shelfKey.position());
                if (!level.method_8477(pos)) {
                    updated = updated.setShelfKey(null);
                } else if (level.method_35230(pos, (class_2591)ModBlockEntities.BACKPACK_SHELF.get()).isEmpty()) {
                    updated = updated.setShelfKey(null);
                } else if (pos.method_19770((class_2374)player.method_33571()) > 256.0) {
                    updated = updated.setShelfKey(null);
                }
                if (updated.shelfKey().isPresent() && !(recall = ((Recall.Access)level).backpacked$getRecall()).isShelfAtBlockPos(level, pos)) {
                    updated = updated.setShelfKey(null);
                }
            } else {
                updated = updated.setShelfKey(null);
            }
        }
        return updated;
    }

    public RecallAugment setShelfKey(@Nullable ShelfKey shelfKey) {
        return new RecallAugment(Optional.ofNullable(shelfKey));
    }
}

