/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.LabelAndDescription;
import com.mrcrayfish.backpacked.common.FilterableItems;
import com.mrcrayfish.backpacked.common.ItemCollection;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Locale;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_9139;

public record FunnellingAugment(ItemCollection filters, Mode mode) implements Augment<FunnellingAugment>,
FilterableItems<FunnellingAugment>
{
    public static final AugmentType<FunnellingAugment> TYPE = new AugmentType<FunnellingAugment>(Utils.id("funnelling"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemCollection.CODEC.fieldOf("filters").orElse((Object)ItemCollection.EMPTY).forGetter(FunnellingAugment::filters), (App)Mode.CODEC.fieldOf("mode").orElse((Object)Mode.ALLOW).forGetter(FunnellingAugment::mode)).apply((Applicative)instance, FunnellingAugment::new)), class_9139.method_56435(ItemCollection.STREAM_CODEC, FunnellingAugment::filters, Mode.STREAM_CODEC, FunnellingAugment::mode, FunnellingAugment::new), () -> new FunnellingAugment(ItemCollection.EMPTY, Mode.ALLOW));

    public FunnellingAugment(ItemCollection filters, Mode mode) {
        this.filters = filters = filters.limit((Integer)Config.AUGMENTS.funnelling.maxFilters.get());
        this.mode = mode;
    }

    @Override
    public AugmentType<FunnellingAugment> type() {
        return TYPE;
    }

    @Override
    public FunnellingAugment addItemFilter(class_1792 item) {
        return new FunnellingAugment(this.filters.add(item), this.mode);
    }

    @Override
    public FunnellingAugment removeItemFilter(class_1792 item) {
        return new FunnellingAugment(this.filters.remove(item), this.mode);
    }

    @Override
    public boolean isFilteringItem(class_1792 item) {
        return this.filters.has(item);
    }

    @Override
    public boolean isFilterFull() {
        return this.filters.ids().size() >= (Integer)Config.AUGMENTS.funnelling.maxFilters.get();
    }

    public FunnellingAugment setMode(Mode mode) {
        return new FunnellingAugment(this.filters, mode);
    }

    public boolean test(class_1799 stack) {
        boolean matched = this.filters.has(stack.method_7909());
        if (matched && this.mode == Mode.ALLOW) {
            return true;
        }
        if (matched && this.mode == Mode.DISALLOW) {
            return false;
        }
        return this.mode == Mode.DISALLOW;
    }

    public static enum Mode implements class_3542,
    LabelAndDescription
    {
        ALLOW,
        DISALLOW;

        public static final Codec<Mode> CODEC;
        public static final class_9139<class_2540, Mode> STREAM_CODEC;
        private static final String LANGUAGE_KEY = "augment.backpacked.funnelling.mode";
        private final class_2561 name = class_2561.method_43469((String)"augment.backpacked.funnelling.mode", (Object[])new Object[]{class_2561.method_43471((String)"%s.%s".formatted("augment.backpacked.funnelling.mode", this.method_15434()))});
        private final class_2561 tooltip = class_2561.method_43471((String)"%s.%s.tooltip".formatted("augment.backpacked.funnelling.mode", this.method_15434()));

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public class_2561 label() {
            return this.name;
        }

        @Override
        public class_2561 description() {
            return this.tooltip;
        }

        public Mode other() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> DISALLOW;
                case 1 -> ALLOW;
            };
        }

        static {
            CODEC = class_3542.method_28140(Mode::values);
            STREAM_CODEC = class_9139.method_56437(class_2540::method_10817, buf -> (Mode)buf.method_10818(Mode.class));
        }
    }
}

