/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.block.ShelfBlock;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.common.BackpackedCodecs;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModPointOfInterests;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_10741;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_4844;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class Recall
extends class_18 {
    public static final String ID = "backpacked_recall";
    public static final int MAX_QUEUE_SIZE = 18;
    public static final Codec<Recall> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(BackpackedCodecs.SECTION_POS, (Codec)Codec.unboundedMap((Codec)Codec.SHORT, ShelfQueue.CODEC).xmap(Short2ObjectOpenHashMap::new, Short2ObjectOpenHashMap::new)).xmap(Object2ObjectOpenHashMap::new, Object2ObjectOpenHashMap::new).fieldOf("Tasks").forGetter(f -> f.queues), (App)Codec.INT.optionalFieldOf("Timer", (Object)0).forGetter(f -> f.timer)).apply((Applicative)instance, Recall::new));
    public static final class_10741<Recall> TYPE = new class_10741("backpacked_recall", () -> new Recall((Object2ObjectOpenHashMap<class_4076, Short2ObjectOpenHashMap<ShelfQueue>>)new Object2ObjectOpenHashMap(), 0), CODEC, null);
    private final Object2ObjectOpenHashMap<class_4076, Short2ObjectOpenHashMap<ShelfQueue>> queues;
    private int timer;
    private boolean runNow;
    private boolean force;

    private Recall(Object2ObjectOpenHashMap<class_4076, Short2ObjectOpenHashMap<ShelfQueue>> queues, int timer) {
        this.queues = queues;
        this.timer = timer;
    }

    public void onShelfBroken(class_3218 level, ShelfBlockEntity shelf) {
        this.removeAndFlushQueueToBlockPos(level, shelf.key());
    }

    public boolean recallToShelf(class_3218 level, class_3222 player, ShelfKey key, int originalIndex, class_1799 backpack) {
        class_2338 pos = class_2338.method_10092((long)key.position());
        if (!level.method_24794(pos)) {
            return false;
        }
        if (!this.isShelfAtBlockPos(level, pos)) {
            return false;
        }
        ShelfQueue queue = this.getOrCreateShelfQueue(pos);
        if (!queue.add(player, originalIndex, backpack, this.timer)) {
            return false;
        }
        this.runNow = true;
        this.method_80();
        return true;
    }

    private ShelfQueue getOrCreateShelfQueue(class_2338 pos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        short relativePos = class_4076.method_19454((class_2338)pos);
        Short2ObjectOpenHashMap sectionMap = (Short2ObjectOpenHashMap)this.queues.computeIfAbsent((Object)sectionPos, k -> new Short2ObjectOpenHashMap());
        return (ShelfQueue)sectionMap.computeIfAbsent(relativePos, k -> new ShelfQueue());
    }

    public boolean isShelfAtBlockPos(class_3218 level, class_2338 pos) {
        if (!level.method_24794(pos)) {
            return false;
        }
        if (level.method_19494().method_26339(ModPointOfInterests.BACKPACK_SHELF.key(), pos)) {
            return true;
        }
        if (!level.method_8477(pos)) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        if (!(state.method_26204() instanceof ShelfBlock)) {
            return false;
        }
        Optional optional = class_7477.method_43989((class_2680)state);
        if (optional.isEmpty()) {
            return false;
        }
        level.method_19494().method_19115(pos, (class_6880)optional.get());
        return true;
    }

    public void forceNextRun() {
        this.force = true;
        this.runNow = true;
    }

    public int flushAllQueues(MinecraftServer server) {
        int[] count = new int[]{0};
        ObjectIterator it = this.queues.entrySet().iterator();
        while (it.hasNext()) {
            ((Short2ObjectOpenHashMap)((Map.Entry)it.next()).getValue()).forEach((relativePos, shelfQueue) -> shelfQueue.forEach((owner, items) -> {
                count[0] = count[0] + this.flushQueue(server, (UUID)owner, (List<QueuedItem>)items);
            }));
            it.remove();
            this.method_80();
        }
        return count[0];
    }

    private int flushQueue(MinecraftServer server, UUID owner, List<QueuedItem> items) {
        class_3222 player = server.method_3760().method_14602(owner);
        if (player == null) {
            return 0;
        }
        int[] count = new int[]{0};
        for (QueuedItem item : items) {
            class_243 pos = player.method_73189();
            class_1542 entity = new class_1542((class_1937)player.method_51469(), pos.field_1352, pos.field_1351, pos.field_1350, item.stack.method_51164());
            entity.method_6988();
            entity.method_6976();
            player.method_51469().method_8649((class_1297)entity);
            count[0] = count[0] + 1;
        }
        return count[0];
    }

    private void flushItem(class_3218 level, class_243 position, class_1799 stack) {
        if (!stack.method_7960()) {
            class_1542 entity = new class_1542((class_1937)level, position.field_1352, position.field_1351, position.field_1350, stack.method_51164());
            entity.method_6988();
            entity.method_6976();
            level.method_8649((class_1297)entity);
        }
    }

    private void removeAndFlushQueueToBlockPos(class_3218 level, ShelfKey key) {
        short relativePos;
        ShelfQueue queue;
        class_2338 pos = class_2338.method_10092((long)key.position());
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        Short2ObjectOpenHashMap sectionMap = (Short2ObjectOpenHashMap)this.queues.get((Object)sectionPos);
        if (sectionMap != null && (queue = (ShelfQueue)sectionMap.remove(relativePos = class_4076.method_19454((class_2338)pos))) != null) {
            queue.forEach((owner, items) -> items.forEach(item -> {
                this.removeInvalidShelfFromItemStack(item.stack);
                this.flushItem(level, pos.method_46558(), item.stack);
            }));
            if (sectionMap.isEmpty()) {
                this.queues.remove((Object)sectionPos);
            }
            this.method_80();
        }
    }

    private void removeInvalidShelfFromItemStack(class_1799 stack) {
        RecallAugment augment = (RecallAugment)BackpackHelper.findAugment(stack, (AugmentType)ModAugmentTypes.RECALL.get());
        if (augment != null) {
            augment = augment.setShelfKey(null);
            Augments augments = Augments.get(stack);
            for (Augments.Position position : Augments.Position.values()) {
                if (augments.getAugment(position).type() != ModAugmentTypes.RECALL.get()) continue;
                augments.setAugment(position, augment);
                break;
            }
            Augments.set(stack, augments);
        }
    }

    public void tick(class_3218 level) {
        ++this.timer;
        if (!this.runNow && this.timer % 5 != 0) {
            return;
        }
        if (level.method_18456().isEmpty()) {
            return;
        }
        ObjectIterator sectionIterator = this.queues.entrySet().iterator();
        while (sectionIterator.hasNext()) {
            Map.Entry sectionEntry = (Map.Entry)sectionIterator.next();
            ObjectIterator relativeIterator = ((Short2ObjectOpenHashMap)sectionEntry.getValue()).short2ObjectEntrySet().iterator();
            while (relativeIterator.hasNext()) {
                Pair<UUID, List<QueuedItem>> playerQueue;
                ShelfQueue queue;
                Short2ObjectMap.Entry relativeEntry = (Short2ObjectMap.Entry)relativeIterator.next();
                class_2338 pos = ((class_4076)sectionEntry.getKey()).method_30557(relativeEntry.getShortKey());
                if (!this.force && !level.method_8477(pos)) continue;
                Optional shelfOptional = level.method_35230(pos, (class_2591)ModBlockEntities.BACKPACK_SHELF.get());
                if (shelfOptional.isEmpty() || !this.isShelfAtBlockPos(level, pos)) {
                    queue = (ShelfQueue)relativeEntry.getValue();
                    queue.forEach((owner, items) -> items.forEach(item -> {
                        this.removeInvalidShelfFromItemStack(item.stack);
                        this.flushItem(level, pos.method_46558(), item.stack);
                    }));
                    sectionIterator.remove();
                    this.method_80();
                    continue;
                }
                queue = (ShelfQueue)relativeEntry.getValue();
                ShelfBlockEntity shelf = (ShelfBlockEntity)((Object)shelfOptional.get());
                Map<UUID, List<QueuedItem>> playerToQueue = queue.queues();
                if (playerToQueue != null && shelf.getBackpack().method_7960() && (playerQueue = Recall.getMinimumQueue(playerToQueue)) != null) {
                    QueuedItem item = (QueuedItem)((List)playerQueue.getSecond()).removeFirst();
                    shelf.recall(item.stack, (UUID)playerQueue.getFirst(), item.originalIndex);
                    queue.decrementCount();
                    queue.cleanQueues();
                    this.method_80();
                }
                shelf.setRecallQueueCount(queue.count);
                if (!queue.isEmpty()) continue;
                relativeIterator.remove();
                this.method_80();
            }
            if (!((Short2ObjectOpenHashMap)sectionEntry.getValue()).isEmpty()) continue;
            sectionIterator.remove();
            this.method_80();
        }
        this.runNow = false;
        this.force = false;
    }

    @Nullable
    private static Pair<UUID, List<QueuedItem>> getMinimumQueue(Map<UUID, List<QueuedItem>> playerToQueue) {
        UUID owner = null;
        List<QueuedItem> minItems = null;
        for (Map.Entry<UUID, List<QueuedItem>> entry : playerToQueue.entrySet()) {
            List<QueuedItem> items = entry.getValue();
            if (items.isEmpty() || minItems != null && items.getFirst().time >= ((QueuedItem)minItems.getFirst()).time) continue;
            owner = entry.getKey();
            minItems = items;
        }
        return minItems != null ? Pair.of(owner, minItems) : null;
    }

    private static final class ShelfQueue {
        private static final Codec<ShelfQueue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_25122, (Codec)QueuedItem.CODEC.listOf()).optionalFieldOf("Queues", new HashMap()).forGetter(s -> s.queues)).apply((Applicative)instance, ShelfQueue::new));
        private Map<UUID, List<QueuedItem>> queues;
        private int count;

        private ShelfQueue() {
            this(new HashMap<UUID, List<QueuedItem>>());
        }

        private ShelfQueue(Map<UUID, List<QueuedItem>> queues) {
            this.queues = queues;
            this.cleanQueues();
            this.updateCount();
        }

        @Nullable
        public Map<UUID, List<QueuedItem>> queues() {
            return this.queues;
        }

        public void forEach(BiConsumer<UUID, List<QueuedItem>> consumer) {
            if (this.queues != null) {
                this.queues.forEach(consumer);
            }
        }

        public boolean add(class_3222 player, int originalIndex, class_1799 backpack, int time) {
            List items;
            if (this.queues == null) {
                this.count = 0;
                this.queues = new HashMap<UUID, List<QueuedItem>>();
            }
            if ((items = this.queues.computeIfAbsent(player.method_5667(), k -> new LinkedList())).size() >= 18) {
                return false;
            }
            items.add(new QueuedItem(originalIndex, backpack.method_51164(), time));
            ++this.count;
            return true;
        }

        private void decrementCount() {
            if (this.count > 0) {
                --this.count;
            }
        }

        private void updateCount() {
            if (this.queues != null) {
                this.count = 0;
                for (List<QueuedItem> items : this.queues.values()) {
                    this.count += items.size();
                }
            }
        }

        private void cleanQueues() {
            if (this.queues != null) {
                this.queues.entrySet().removeIf(e -> ((List)e.getValue()).isEmpty());
                if (this.queues.isEmpty()) {
                    this.count = 0;
                }
            }
        }

        private boolean isEmpty() {
            return this.queues == null || this.queues.isEmpty();
        }
    }

    private record QueuedItem(int originalIndex, class_1799 stack, int time) {
        private static final Codec<QueuedItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("original_index").orElse((Object)-1).forGetter(QueuedItem::originalIndex), (App)class_1799.field_49266.fieldOf("item").orElse((Object)class_1799.field_8037).forGetter(QueuedItem::stack), (App)Codec.INT.fieldOf("queued_at").orElse((Object)0).forGetter(QueuedItem::time)).apply((Applicative)instance, QueuedItem::new));
    }

    public static interface Access {
        public Recall backpacked$getRecall();
    }
}

