/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.data;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.PlaceSoundControls;
import com.mrcrayfish.backpacked.common.UseItemOnBlockFaceContext;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_10741;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_4844;

public final class Farmhand
extends class_18 {
    public static final String ID = "backpacked_farmhand";
    public static final int PLANT_TIME = 14;
    public static final int MAX_DISTANCE_SQR = 256;
    public static final Codec<Farmhand> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_2338.field_25064, DelayedPlantTask.CODEC).xmap(HashMap::new, Function.identity()).fieldOf("Tasks").forGetter(f -> f.tasks)).apply((Applicative)instance, Farmhand::new));
    public static final class_10741<Farmhand> TYPE = new class_10741("backpacked_farmhand", Farmhand::new, CODEC, class_4284.field_45081);
    private final HashMap<class_2338, DelayedPlantTask> tasks;

    private Farmhand(HashMap<class_2338, DelayedPlantTask> tasks) {
        this.tasks = tasks;
    }

    private Farmhand() {
        this.tasks = new HashMap();
    }

    public boolean plant(class_1799 stack, class_2338 pos, class_3222 player) {
        Preconditions.checkArgument((boolean)(stack.method_7909() instanceof class_1747));
        if (!player.method_5805() || pos.method_19770((class_2374)player.method_73189()) > 256.0) {
            return false;
        }
        if (!this.tasks.containsKey(pos)) {
            this.tasks.put(pos, new DelayedPlantTask(stack, pos, player.method_5667()));
            this.method_80();
            return true;
        }
        return false;
    }

    public boolean isPlanting(class_2338 pos) {
        return this.tasks.containsKey(pos);
    }

    public void tick(class_3218 level) {
        this.tasks.entrySet().removeIf(entry -> {
            DelayedPlantTask task = (DelayedPlantTask)entry.getValue();
            --task.delay;
            if (task.delay <= 0) {
                task.run(level);
                this.method_80();
                return true;
            }
            return false;
        });
    }

    private static final class DelayedPlantTask {
        private static final Codec<DelayedPlantTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_49266.fieldOf("stack").forGetter(task -> task.stack), (App)class_2338.field_25064.fieldOf("pos").forGetter(task -> task.pos), (App)class_4844.field_25122.fieldOf("submitter").forGetter(task -> task.submitter)).apply((Applicative)instance, DelayedPlantTask::new));
        private final class_1799 stack;
        private final class_2338 pos;
        private final UUID submitter;
        private int delay = 14;

        private DelayedPlantTask(class_1799 stack, class_2338 pos, UUID submitter) {
            this.stack = stack;
            this.pos = pos;
            this.submitter = submitter;
        }

        public void run(class_3218 level) {
            class_1792 class_17922 = this.stack.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1269 result;
                class_1747 item = (class_1747)class_17922;
                class_3222 player = level.method_8503().method_3760().method_14602(this.submitter);
                if (player != null && player.method_51469() == level && player.method_5805() && this.pos.method_19770((class_2374)player.method_73189()) <= 256.0 && (result = PlaceSoundControls.runWithOptions(false, true, () -> item.method_7884((class_1838)UseItemOnBlockFaceContext.create(level, player, this.stack, this.pos.method_10074(), class_2350.field_11036)))).method_23665()) {
                    class_2680 state = level.method_8320(this.pos.method_10074());
                    class_243 particle = this.pos.method_61082();
                    level.method_65096((class_2394)new class_2388(class_2398.field_11217, state), particle.field_1352, particle.field_1351, particle.field_1350, 10, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
                    return;
                }
            }
            class_243 spawn = this.pos.method_61082().method_1031(0.0, 1.0, 0.0);
            level.method_8649((class_1297)new class_1542((class_1937)level, spawn.field_1352, spawn.field_1351, spawn.field_1350, this.stack.method_7972()));
        }
    }

    public static interface Access {
        public Farmhand backpacked$getFarmhand();
    }
}

