/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.impl.EmptyAugment;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public record Augments(Augment<?> firstAugment, boolean firstState, Augment<?> secondAugment, boolean secondState, Augment<?> thirdAugment, boolean thirdState, Augment<?> fourthAugment, boolean fourthState) {
    public static final Augments EMPTY = new Augments(EmptyAugment.INSTANCE, true, EmptyAugment.INSTANCE, true, EmptyAugment.INSTANCE, true, EmptyAugment.INSTANCE, true);
    public static final Codec<Augments> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Augment.CODEC.optionalFieldOf("first", (Object)EmptyAugment.INSTANCE).forGetter(Augments::firstAugment), (App)Codec.BOOL.optionalFieldOf("firstState", (Object)true).forGetter(Augments::firstState), (App)Augment.CODEC.optionalFieldOf("second", (Object)EmptyAugment.INSTANCE).forGetter(Augments::secondAugment), (App)Codec.BOOL.optionalFieldOf("secondState", (Object)true).forGetter(Augments::secondState), (App)Augment.CODEC.optionalFieldOf("third", (Object)EmptyAugment.INSTANCE).forGetter(Augments::thirdAugment), (App)Codec.BOOL.optionalFieldOf("thirdState", (Object)true).forGetter(Augments::thirdState), (App)Augment.CODEC.optionalFieldOf("fourth", (Object)EmptyAugment.INSTANCE).forGetter(Augments::fourthAugment), (App)Codec.BOOL.optionalFieldOf("fourthState", (Object)true).forGetter(Augments::fourthState)).apply((Applicative)builder, Augments::new));
    public static final class_9139<class_9129, Augments> STREAM_CODEC = class_9139.method_56437((buf, augments) -> {
        Augment.STREAM_CODEC.encode(buf, augments.firstAugment);
        buf.method_52964(augments.firstState);
        Augment.STREAM_CODEC.encode(buf, augments.secondAugment);
        buf.method_52964(augments.secondState);
        Augment.STREAM_CODEC.encode(buf, augments.thirdAugment);
        buf.method_52964(augments.thirdState);
        Augment.STREAM_CODEC.encode(buf, augments.fourthAugment);
        buf.method_52964(augments.fourthState);
    }, buf -> {
        Augment firstAugment = (Augment)Augment.STREAM_CODEC.decode(buf);
        boolean firstState = buf.readBoolean();
        Augment secondAugment = (Augment)Augment.STREAM_CODEC.decode(buf);
        boolean secondState = buf.readBoolean();
        Augment thirdAugment = (Augment)Augment.STREAM_CODEC.decode(buf);
        boolean thirdState = buf.readBoolean();
        Augment fourthAugment = (Augment)Augment.STREAM_CODEC.decode(buf);
        boolean fourthState = buf.readBoolean();
        return new Augments(firstAugment, firstState, secondAugment, secondState, thirdAugment, thirdState, fourthAugment, fourthState);
    });

    public Augment<?> getAugment(Position position) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Augments.restrict(this.firstAugment);
            case 1 -> Augments.restrict(this.secondAugment);
            case 2 -> Augments.restrict(this.thirdAugment);
            case 3 -> Augments.restrict(this.fourthAugment);
        };
    }

    public Augments setAugment(Position position, Augment<?> augment) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Augments(augment, this.firstState, this.secondAugment, this.secondState, this.thirdAugment, this.thirdState, this.fourthAugment, this.fourthState);
            case 1 -> new Augments(this.firstAugment, this.firstState, augment, this.secondState, this.thirdAugment, this.thirdState, this.fourthAugment, this.fourthState);
            case 2 -> new Augments(this.firstAugment, this.firstState, this.secondAugment, this.secondState, augment, this.thirdState, this.fourthAugment, this.fourthState);
            case 3 -> new Augments(this.firstAugment, this.firstState, this.secondAugment, this.secondState, this.thirdAugment, this.thirdState, augment, this.fourthState);
        };
    }

    public boolean getState(Position position) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.firstState;
            case 1 -> this.secondState;
            case 2 -> this.thirdState;
            case 3 -> this.fourthState;
        };
    }

    public Augments setState(Position position, boolean state) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Augments(this.firstAugment, state, this.secondAugment, this.secondState, this.thirdAugment, this.thirdState, this.fourthAugment, this.fourthState);
            case 1 -> new Augments(this.firstAugment, this.firstState, this.secondAugment, state, this.thirdAugment, this.thirdState, this.fourthAugment, this.fourthState);
            case 2 -> new Augments(this.firstAugment, this.firstState, this.secondAugment, this.secondState, this.thirdAugment, state, this.fourthAugment, this.fourthState);
            case 3 -> new Augments(this.firstAugment, this.firstState, this.secondAugment, this.secondState, this.thirdAugment, this.thirdState, this.fourthAugment, state);
        };
    }

    public <T extends Augment<T>> boolean has(AugmentType<T> type) {
        if (Config.getDisabledAugments().contains(type.id())) {
            return false;
        }
        return this.firstAugment.type() == type || this.secondAugment.type() == type || this.thirdAugment.type() == type;
    }

    public static Augments get(class_1799 stack) {
        return (Augments)stack.method_58695((class_9331)ModDataComponents.AUGMENTS.get(), (Object)EMPTY);
    }

    public static void set(class_1799 stack, Augments augments) {
        stack.method_57379((class_9331)ModDataComponents.AUGMENTS.get(), (Object)augments);
    }

    public static Augment<?> restrict(Augment<?> augment) {
        if (Config.getDisabledAugments().contains(augment.type().id())) {
            return EmptyAugment.INSTANCE;
        }
        return augment;
    }

    public static enum Position {
        FIRST,
        SECOND,
        THIRD,
        FOURTH;

        public static final class_9139<class_2540, Position> STREAM_CODEC;

        static {
            STREAM_CODEC = class_9139.method_56437(class_2540::method_10817, buf -> (Position)buf.method_10818(Position.class));
        }
    }
}

