/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.core.ModRegistries;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record AugmentType<T extends Augment<T>>(class_2960 id, MapCodec<T> codec, class_9139<class_9129, T> streamCodec, Supplier<T> defaultSupplier, class_2960 sprite, class_2561 name, class_2561 description, Supplier<AugmentType<?>> requires) implements Comparable<AugmentType<?>>
{
    public static final Comparator<AugmentType<?>> BY_NAME = Comparator.comparing(type -> type.name().getString());
    static final Codec<AugmentType<?>> CODEC = class_2960.field_25139.flatXmap(id -> {
        AugmentType type = (AugmentType)ModRegistries.AUGMENT_TYPES.getValue(id);
        if (type != null) {
            return DataResult.success((Object)type);
        }
        return DataResult.error(() -> "Unknown augment type: " + String.valueOf(id));
    }, type -> {
        if (ModRegistries.AUGMENT_TYPES.containsKey(type.id)) {
            return DataResult.success((Object)type.id);
        }
        return DataResult.error(() -> "Unregistered augment type: " + String.valueOf(type.id));
    });

    public AugmentType(class_2960 id, MapCodec<T> codec, class_9139<class_9129, T> streamCodec, Supplier<T> defaultSupplier) {
        this(id, codec, streamCodec, defaultSupplier, () -> null);
    }

    public AugmentType(class_2960 id, MapCodec<T> codec, class_9139<class_9129, T> streamCodec, Supplier<T> defaultSupplier, Supplier<AugmentType<?>> requires) {
        this(id, codec, streamCodec, defaultSupplier, class_2960.method_60655((String)id.method_12836(), (String)"augment/%s".formatted(id.method_12832())), (class_2561)class_2561.method_43471((String)"augment.%s.%s".formatted(id.method_12836(), id.method_12832().replace("/", "."))), (class_2561)class_2561.method_43471((String)"augment.%s.%s.desc".formatted(id.method_12836(), id.method_12832().replace("/", "."))), requires);
    }

    public static Stream<AugmentType<? extends Augment<?>>> stream() {
        return StreamSupport.stream(ModRegistries.AUGMENT_TYPES.spliterator(), false);
    }

    @Override
    public int compareTo(@NotNull AugmentType<?> other) {
        if (this.isEmpty()) {
            return -1;
        }
        return BY_NAME.compare(this, other);
    }

    public boolean isEmpty() {
        return this == ModAugmentTypes.EMPTY.get();
    }
}

