/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment;

import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.common.InventoryAugmentSnapshot;
import com.mrcrayfish.backpacked.common.PlaceSoundControls;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.UseItemOnBlockFaceContext;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.data.Farmhand;
import com.mrcrayfish.backpacked.common.augment.data.Recall;
import com.mrcrayfish.backpacked.common.augment.impl.FunnellingAugment;
import com.mrcrayfish.backpacked.common.augment.impl.LightweaverAugment;
import com.mrcrayfish.backpacked.common.augment.impl.LootboundAugment;
import com.mrcrayfish.backpacked.common.augment.impl.QuiverlinkAugment;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.common.augment.impl.SeedflowAugment;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.mixin.common.BlockItemInvoker;
import com.mrcrayfish.backpacked.mixin.common.CropBlockMixin;
import com.mrcrayfish.backpacked.mixin.common.IntegerPropertyMixin;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageFarmhandPlant;
import com.mrcrayfish.backpacked.network.message.MessageLootboundTakeItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import com.mrcrayfish.framework.api.event.FrameworkPlayerEvents;
import com.mrcrayfish.framework.api.network.LevelLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1838;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_4538;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AugmentHandler {
    public static void init() {
        FrameworkPlayerEvents.PICKUP_EXPERIENCE.register((player, orb) -> {
            AugmentHandler.onPlayerPickupExperienceOrb(player, orb);
            return false;
        });
        BackpackedEvents.MINED_BLOCK.register((snapshot, stack, player) -> AugmentHandler.replantCrop(snapshot.state(), player, snapshot.pos()));
    }

    public static boolean beforeItemPickup(class_1657 player, class_1542 entity, @Nullable UUID target) {
        class_1799 stack = entity.method_6983();
        if (stack.method_7960()) {
            return false;
        }
        if (entity.method_6977()) {
            return false;
        }
        if (target != null && !target.equals(player.method_5667())) {
            return false;
        }
        class_1792 originalItem = stack.method_7909();
        FunnelResult result = AugmentHandler.funnelItemStackIntoBackpack(player, stack);
        int funnelCount = result.funnelCount();
        if (funnelCount > 0) {
            player.method_6103((class_1297)entity, funnelCount);
            player.method_7342(class_3468.field_15392.method_14956((Object)originalItem), funnelCount);
            player.method_29499(entity);
        }
        if (!result.hasRemaining() && result.funnelCount() > 0) {
            entity.method_31472();
            return true;
        }
        return false;
    }

    public static boolean beforeArrowPickup(class_1657 player, class_1665 arrow) {
        class_1799 stack = arrow.method_54759().method_7972();
        FunnelResult result = AugmentHandler.funnelItemStackIntoBackpack(player, stack);
        if (result == FunnelResult.IGNORE) {
            return false;
        }
        if (!result.hasRemaining() && result.funnelCount() > 0) {
            return true;
        }
        if (result.funnelCount() > 0) {
            player.method_31548().method_7394(stack);
            return true;
        }
        return false;
    }

    private static FunnelResult funnelItemStackIntoBackpack(class_1657 player, class_1799 stack) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.FUNNELLING.get());
        if (snapshots.isEmpty()) {
            return FunnelResult.IGNORE;
        }
        int funnelCount = 0;
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            if (!((FunnellingAugment)snapshot.augment()).test(stack)) continue;
            int beforeCount = stack.method_7947();
            class_1799 remaining = snapshot.inventory().addItem(stack);
            stack.method_7939(remaining.method_7947());
            funnelCount += beforeCount - remaining.method_7947();
            if (!stack.method_7960()) continue;
            break;
        }
        return new FunnelResult(!stack.method_7960(), funnelCount);
    }

    public static class_1799 locateAmmunition(class_1657 player, class_1799 weapon, class_1799 ammo) {
        if (!weapon.method_7960() && weapon.method_7909() instanceof class_1811) {
            List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.QUIVERLINK.get());
            for (InventoryAugmentSnapshot.One snapshot : snapshots) {
                if (!ammo.method_7960() && ((QuiverlinkAugment)snapshot.augment()).priority() != QuiverlinkAugment.Priority.BACKPACK) continue;
                BackpackInventory inventory = snapshot.inventory();
                Predicate<class_1799> predicate = Services.PLATFORM.getValidProjectiles(weapon);
                class_1799 projectile = InventoryHelper.streamFor(inventory).filter(predicate).findFirst().orElse(class_1799.field_8037);
                if (projectile.method_7960()) continue;
                return projectile;
            }
        }
        return class_1799.field_8037;
    }

    public static void onLootDroppedByEntity(Collection<class_1542> drops, class_1657 player) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.FUNNELLING.get(), (AugmentType)ModAugmentTypes.LOOTBOUND.get());
        for (InventoryAugmentSnapshot.Two snapshot : snapshots) {
            LootboundAugment augment = (LootboundAugment)snapshot.secondAugment();
            if (!augment.mobs()) continue;
            AugmentHandler.funnelDropsIntoBackpack(drops, player);
        }
    }

    public static void onLootDroppedByBlock(Collection<class_1542> drops, class_1657 player) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.FUNNELLING.get(), (AugmentType)ModAugmentTypes.LOOTBOUND.get());
        for (InventoryAugmentSnapshot.Two snapshot : snapshots) {
            LootboundAugment augment = (LootboundAugment)snapshot.secondAugment();
            if (!augment.blocks()) continue;
            AugmentHandler.funnelDropsIntoBackpack(drops, player);
        }
    }

    private static void funnelDropsIntoBackpack(Collection<class_1542> drops, class_1657 player) {
        ArrayList consumed = new ArrayList();
        drops.removeIf(drop -> {
            class_1799 copy = drop.method_6983().method_7972();
            FunnelResult result = AugmentHandler.funnelItemStackIntoBackpack(player, copy);
            if (result.funnelCount() > 0) {
                class_1799 stack = drop.method_6983().method_46651(result.funnelCount());
                consumed.add(Pair.of((Object)stack, (Object)drop.method_73189()));
            }
            drop.method_6979(copy);
            return copy.method_7960();
        });
        class_1937 class_19372 = player.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            consumed.forEach(pair -> {
                LevelLocation location = LevelLocation.create((class_3218)level, (class_243)((class_243)pair.getSecond()), (double)32.0);
                Network.getPlay().sendToNearbyPlayers(() -> location, (Object)new MessageLootboundTakeItem(player.method_5628(), (class_1799)pair.getFirst(), (class_243)pair.getSecond(), true));
            });
        }
    }

    public static void onPlayerPickupExperienceOrb(class_1657 player, class_1303 orb) {
        if (orb.method_31481()) {
            return;
        }
        class_6880.class_6883 mending = player.method_73183().method_45448(class_7924.field_41265).method_46747(class_1893.field_9101);
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.REFORGE.get());
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            InventoryHelper.streamFor(snapshot.inventory()).filter(arg_0 -> AugmentHandler.lambda$onPlayerPickupExperienceOrb$5((class_6880)mending, arg_0)).forEach(stack -> {
                int repairableAmount = class_1890.method_60168((class_3218)((class_3218)player.method_73183()), (class_1799)stack, (int)orb.method_5919());
                int maxRepairableDamage = Math.min(repairableAmount, stack.method_7919());
                stack.method_7974(stack.method_7919() - maxRepairableDamage);
            });
        }
    }

    public static class_1799 locateTotemOfUndying(class_1657 player) {
        int cooldown = (Integer)ModSyncedDataKeys.IMMORTAL_COOLDOWN.getValue((class_1297)player);
        if (cooldown > 0) {
            return class_1799.field_8037;
        }
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.IMMORTAL.get());
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            BackpackInventory inventory = snapshot.inventory();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (!stack.method_31574(class_1802.field_8288)) continue;
                return stack;
            }
        }
        return class_1799.field_8037;
    }

    public static void onPlayerChangedBlockPos(class_3222 player, class_3218 level, class_2338 pos, int brightness) {
        AugmentHandler.onPlayerWalkOnCrops(player);
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment((class_1657)player, (AugmentType)ModAugmentTypes.LIGHTWEAVER.get());
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            class_1269 result;
            LightweaverAugment augment = (LightweaverAugment)snapshot.augment();
            if (brightness > augment.minimumLight()) {
                return;
            }
            class_1799 torch = snapshot.inventory().findFirst(stack -> stack.method_31574(class_1802.field_8810));
            if (torch.method_7960() || !(result = PlaceSoundControls.runWithOptions(!augment.sound(), true, () -> torch.method_7981((class_1838)UseItemOnBlockFaceContext.create(level, player, torch, pos.method_10074(), class_2350.field_11036)))).method_23665()) continue;
            snapshot.inventory().method_5431();
            return;
        }
    }

    private static void replantCrop(class_2680 state, class_3222 player, class_2338 pos) {
        if (!AugmentHandler.isFullyGrownCrop(state)) {
            return;
        }
        class_1792 seedItem = AugmentHandler.getCropSeed((class_4538)player.method_51469(), pos, state);
        if (seedItem == null) {
            return;
        }
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment((class_1657)player, (AugmentType)ModAugmentTypes.FARMHAND.get());
        if (snapshots.isEmpty()) {
            return;
        }
        class_3218 level = player.method_51469();
        if (!level.method_8320(pos).method_45474()) {
            return;
        }
        Farmhand farmhand = ((Farmhand.Access)level).backpacked$getFarmhand();
        if (farmhand.isPlanting(pos)) {
            return;
        }
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            class_1799 copy;
            BackpackInventory inventory = snapshot.inventory();
            class_1799 seed = inventory.findFirst(stack -> stack.method_31574(seedItem));
            if (seed.method_7960() || !farmhand.plant(copy = seed.method_46651(1), pos, player)) continue;
            MessageFarmhandPlant message = new MessageFarmhandPlant(copy, player.method_5628(), pos);
            Network.getPlay().sendToTrackingEntity(() -> player, (Object)message);
            Network.getPlay().sendToPlayer(() -> player, (Object)message);
            seed.method_7934(1);
            inventory.method_5431();
            break;
        }
    }

    private static void onPlayerWalkOnCrops(class_3222 player) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment((class_1657)player, (AugmentType)ModAugmentTypes.SEEDFLOW.get());
        if (snapshots.isEmpty()) {
            return;
        }
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_243 position = player.method_73189().method_1019(player.method_5663().method_18805(1.0, 0.0, 1.0).method_1029());
        positions.add(class_2338.method_49637((double)(position.field_1352 - 0.5), (double)(position.field_1351 + 0.5), (double)(position.field_1350 - 0.5)));
        positions.add(class_2338.method_49637((double)(position.field_1352 + 0.5), (double)(position.field_1351 + 0.5), (double)(position.field_1350 - 0.5)));
        positions.add(class_2338.method_49637((double)(position.field_1352 + 0.5), (double)(position.field_1351 + 0.5), (double)(position.field_1350 + 0.5)));
        positions.add(class_2338.method_49637((double)(position.field_1352 - 0.5), (double)(position.field_1351 + 0.5), (double)(position.field_1350 + 0.5)));
        class_3218 level = player.method_51469();
        Farmhand farmhand = ((Farmhand.Access)level).backpacked$getFarmhand();
        positions.removeIf(pos -> !level.method_8320(pos).method_45474() || farmhand.isPlanting((class_2338)pos));
        if (positions.isEmpty()) {
            return;
        }
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            SeedflowAugment augment = (SeedflowAugment)snapshot.augment();
            BackpackInventory inventory = snapshot.inventory();
            boolean random = augment.randomizeSeeds();
            Function<class_2338, class_1799> seedSupplier = random ? AugmentHandler.nextRandomizedPlantableSeed(level, augment, inventory) : AugmentHandler.nextPlantableSeed(level, augment, inventory);
            boolean changed = false;
            class_1799 stack = class_1799.field_8037;
            Iterator it = positions.iterator();
            while (it.hasNext()) {
                class_2338 pos2 = (class_2338)it.next();
                if (stack.method_7960() || random) {
                    stack = seedSupplier.apply(pos2);
                }
                if (stack.method_7960()) break;
                class_1799 copy = stack.method_46651(1);
                if (!farmhand.plant(copy, pos2, player)) continue;
                MessageFarmhandPlant message = new MessageFarmhandPlant(copy, player.method_5628(), pos2);
                Network.getPlay().sendToTrackingEntity(() -> player, (Object)message);
                Network.getPlay().sendToPlayer(() -> player, (Object)message);
                stack.method_7934(1);
                it.remove();
                changed = true;
            }
            if (changed) {
                inventory.method_5431();
            }
            if (!positions.isEmpty()) continue;
            return;
        }
    }

    private static boolean canUseBlockItemOnBlockPos(class_3218 level, class_1799 stack, class_2338 pos, class_2350 face) {
        class_1747 item = (class_1747)stack.method_7909();
        class_2248 block = item.method_7711();
        if (!block.method_45382(level.method_45162())) {
            return false;
        }
        class_1750 context = new class_1750((class_1838)UseItemOnBlockFaceContext.create(level, stack, pos, face));
        if (!context.method_7716()) {
            return false;
        }
        if ((context = item.method_16356(context)) == null) {
            return false;
        }
        class_2680 state = ((BlockItemInvoker)item).backpacked$getPlacementState(context);
        return state != null;
    }

    private static boolean isFullyGrownCrop(class_2680 state) {
        if (state.method_26204() instanceof class_2261) {
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2302) {
                class_2302 crop = (class_2302)class_22482;
                return crop.method_9825(state);
            }
            for (class_2758 property : SeedflowAugment.AGE_PROPERTIES) {
                if (!state.method_28498((class_2769)property)) continue;
                return ((Integer)state.method_11654((class_2769)property)).intValue() == ((IntegerPropertyMixin)property).backpacked$getMax();
            }
            for (class_2769 property : state.method_28501()) {
                if (!(property instanceof class_2758)) continue;
                class_2758 integerProperty = (class_2758)property;
                if (!property.method_11899().equals("age")) continue;
                return ((Integer)state.method_11654((class_2769)integerProperty)).intValue() == ((IntegerPropertyMixin)property).backpacked$getMax();
            }
        }
        return false;
    }

    @Nullable
    private static class_1792 getCropSeed(class_4538 reader, class_2338 pos, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2261) {
            class_2261 vegetation = (class_2261)class_22482;
            if (vegetation instanceof class_2302) {
                class_2302 crop = (class_2302)vegetation;
                return ((CropBlockMixin)crop).backpacked$getBaseSeedId().method_8389();
            }
            return vegetation.method_9564().method_65171(reader, pos, false).method_7909();
        }
        return null;
    }

    private static Function<class_2338, class_1799> nextPlantableSeed(class_3218 level, SeedflowAugment augment, BackpackInventory inventory) {
        int[] currentIndex = new int[]{0};
        return pos -> {
            if (currentIndex[0] >= inventory.method_5439()) {
                return class_1799.field_8037;
            }
            while (currentIndex[0] < inventory.method_5439()) {
                int n = currentIndex[0];
                currentIndex[0] = n + 1;
                class_1799 stack = inventory.method_5438(n);
                if (stack.method_7960() || !SeedflowAugment.ITEM_PLACES_AGEABLE_CROP.test(stack.method_7909()) || augment.useFilters() && !augment.isFilteringItem(stack.method_7909()) || !AugmentHandler.canUseBlockItemOnBlockPos(level, stack, pos, class_2350.field_11036)) continue;
                return stack;
            }
            return class_1799.field_8037;
        };
    }

    private static Function<class_2338, class_1799> nextRandomizedPlantableSeed(class_3218 level, SeedflowAugment augment, BackpackInventory inventory) {
        return pos -> {
            int count = 0;
            class_1799 result = class_1799.field_8037;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960() || !SeedflowAugment.ITEM_PLACES_AGEABLE_CROP.test(stack.method_7909()) || augment.useFilters() && !augment.isFilteringItem(stack.method_7909()) || !AugmentHandler.canUseBlockItemOnBlockPos(level, stack, pos, class_2350.field_11036) || level.field_9229.method_43048(++count) != 0) continue;
                result = stack;
            }
            return result;
        };
    }

    public static boolean recallBackpack(class_3222 player, int index, class_1799 stack, RecallAugment augment) {
        Optional<ShelfKey> optional = augment.shelfKey();
        if (optional.isEmpty()) {
            return false;
        }
        ShelfKey shelfKey = optional.get();
        MinecraftServer server = player.method_51469().method_8503();
        class_3218 level = server.method_3847(shelfKey.level());
        if (level == null) {
            return false;
        }
        Recall recall = ((Recall.Access)level).backpacked$getRecall();
        return recall.recallToShelf(level, player, shelfKey, index, stack);
    }

    private static /* synthetic */ boolean lambda$onPlayerPickupExperienceOrb$5(class_6880 mending, class_1799 stack) {
        return stack.method_58657().method_57536(mending) > 0 && stack.method_7963() && stack.method_7986() && stack.method_7947() == 1 && stack.method_7914() == 1 && Services.PLATFORM.isRepairable(stack);
    }

    private record FunnelResult(boolean hasRemaining, int funnelCount) {
        private static final FunnelResult IGNORE = new FunnelResult(false, 0);
    }
}

