/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ItemCollection(HashSet<class_2960> ids) {
    public static final ItemCollection EMPTY = new ItemCollection(new HashSet<class_2960>());
    public static final int MAX_ENTRIES = 256;
    public static final Codec<ItemCollection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.sizeLimitedListOf(256).xmap(HashSet::new, ArrayList::new).fieldOf("ids").orElse(new HashSet()).forGetter(f -> f.ids)).apply((Applicative)instance, ItemCollection::new));
    public static final class_9139<class_9129, ItemCollection> STREAM_CODEC = class_9139.method_56434((class_9139)class_2960.field_48267.method_56433(class_9135.method_56374(HashSet::new)), ItemCollection::ids, ItemCollection::new);
    private static final class_2960 AIR = class_2960.method_60656((String)"air");

    public ItemCollection {
        ids.removeIf(id -> !class_7923.field_41178.method_10250(id) || id.equals((Object)AIR));
        if (ids.size() > 256) {
            Iterator<class_2960> it = ids.iterator();
            while (ids.size() > 256 && it.hasNext()) {
                it.remove();
            }
        }
    }

    public boolean has(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return this.ids.contains(id);
    }

    public ItemCollection add(class_1792 item) {
        if (this.ids.size() >= 256) {
            return this;
        }
        HashSet<class_2960> filters = new HashSet<class_2960>(this.ids);
        filters.add(class_7923.field_41178.method_10221((Object)item));
        return new ItemCollection(filters);
    }

    public ItemCollection remove(class_1792 item) {
        HashSet<class_2960> filters = new HashSet<class_2960>(this.ids);
        filters.remove(class_7923.field_41178.method_10221((Object)item));
        return new ItemCollection(filters);
    }

    public ItemCollection filter(Predicate<class_1792> predicate) {
        HashSet<class_2960> filters = new HashSet<class_2960>(this.ids);
        filters.removeIf(id -> !predicate.test((class_1792)class_7923.field_41178.method_63535(id)));
        return new ItemCollection(filters);
    }

    public ItemCollection limit(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"size must be greater than zero");
        if (this.ids.size() <= size) {
            return this;
        }
        HashSet<class_2960> set = new HashSet<class_2960>(this.ids);
        Iterator<class_2960> it = set.iterator();
        while (set.size() > size && it.hasNext()) {
            it.remove();
        }
        return new ItemCollection(set);
    }
}

