/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.framework.api.event.FrameworkTickEvents;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public class BackpackEvents {
    public static void init() {
        FrameworkTickEvents.START_PLAYER.register(player -> {
            BackpackEvents.updateBackpackProperties(player);
            BackpackEvents.applyImmortalCooldown(player);
            BackpackEvents.updateBackpackScale(player);
        });
    }

    private static void updateBackpackProperties(class_1657 player) {
        if (player.method_73183().method_8608()) {
            return;
        }
        Optional cosmeticProperties = (Optional)ModSyncedDataKeys.COSMETIC_PROPERTIES.getValue((class_1297)player);
        class_1799 realStack = BackpackHelper.getFirstBackpackStack(player);
        if (realStack.method_31574((class_1792)ModItems.BACKPACK.get())) {
            CosmeticProperties realProperties = (CosmeticProperties)realStack.method_58694((class_9331)ModDataComponents.COSMETIC_PROPERTIES.get());
            if (realProperties == null) {
                throw new RuntimeException("BackpackProperties is null. This should not happen!");
            }
            if (cosmeticProperties.isEmpty() || !realProperties.equals(cosmeticProperties.get())) {
                ModSyncedDataKeys.COSMETIC_PROPERTIES.setValue((class_1297)player, Optional.of(realProperties));
            }
        } else if (cosmeticProperties.isPresent()) {
            ModSyncedDataKeys.COSMETIC_PROPERTIES.setValue((class_1297)player, Optional.empty());
        }
    }

    private static void applyImmortalCooldown(class_1657 player) {
        if (player.method_73183().method_8608()) {
            return;
        }
        int cooldown = (Integer)ModSyncedDataKeys.IMMORTAL_COOLDOWN.getValue((class_1297)player);
        if (cooldown > 0) {
            ModSyncedDataKeys.IMMORTAL_COOLDOWN.setValue((class_1297)player, (Object)(cooldown - 1));
        }
    }

    private static void updateBackpackScale(class_1657 player) {
        if (player.method_73183().method_8608()) {
            return;
        }
        int scale = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.GIANT.get()).size();
        ModSyncedDataKeys.BACKPACK_SCALE.setValue((class_1297)player, (Object)scale);
    }
}

