/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.blockentity;

import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.Icons;
import com.mrcrayfish.backpacked.client.StandaloneModels;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.backpack.ModelMeta;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderer;
import com.mrcrayfish.backpacked.client.renderer.backpack.RenderMode;
import com.mrcrayfish.backpacked.client.renderer.backpack.Scene;
import com.mrcrayfish.backpacked.client.renderer.blockentity.state.ShelfRenderState;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.framework.api.client.model.FrameworkBakedModel;
import com.mrcrayfish.framework.api.client.model.FrameworkModelResource;
import com.mrcrayfish.framework.api.client.model.renderer.StandaloneModelRenderer;
import net.minecraft.class_10442;
import net.minecraft.class_10889;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class ShelfRenderer
implements class_827<ShelfBlockEntity, ShelfRenderState> {
    private static final class_2561 RECALL_ICON = ScreenUtil.getIconComponent(Icons.RECALL);
    private final class_10442 itemModelResolver;
    private final class_898 entityRenderDispatcher;

    public ShelfRenderer(class_5614.class_5615 context) {
        this.itemModelResolver = context.comp_4536();
        this.entityRenderDispatcher = context.comp_4538();
    }

    public ShelfRenderState createRenderState() {
        return new ShelfRenderState();
    }

    public void extractRenderState(ShelfBlockEntity entity, ShelfRenderState state, float partialTick, class_243 camera, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_11683.class_11792 overlay) {
        class_2561 label;
        super.method_74331((class_2586)entity, (class_11954)state, partialTick, camera, overlay);
        state.direction = entity.getDirection();
        state.recallQueueCount = entity.getRecallQueueCount();
        class_1799 stack = entity.getBackpack();
        boolean bl = state.hasBackpack = !stack.method_7960();
        if (stack.method_57826(class_9334.field_49631) && (label = (class_2561)stack.method_58694(class_9334.field_49631)) != null) {
            state.nameplate = label;
        }
        CosmeticProperties properties = (CosmeticProperties)stack.method_58695((class_9331)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)CosmeticProperties.DEFAULT);
        class_2960 modelId = properties.cosmetic().orElse(BackpackManager.getDefaultOrFallbackCosmetic());
        ClientBackpack backpack = ClientRegistry.instance().getBackpackOrDefault(modelId);
        if (backpack != null) {
            ModelMeta meta = backpack.getModelMeta();
            state.shelfOffset = meta.shelfOffset();
            state.baseModel = backpack.getBaseModel();
            state.strapsModel = backpack.getStrapsModel();
        }
        state.partialTick = partialTick;
        state.playingAnimation = entity.isAnimationPlaying();
        state.animationTicks = entity.getAnimationTicks();
        state.renderTicks = entity.getRenderTicks();
    }

    public void submit(ShelfRenderState state, class_4587 pose, class_11659 collector, class_12075 camera) {
        Vector3fc offset;
        if (!state.hasBackpack) {
            return;
        }
        class_2350 facing = state.direction;
        this.renderBackpackName(state, facing, pose, collector, camera);
        pose.method_22903();
        pose.method_22904(0.5, 0.0, 0.5);
        pose.method_22904(0.0, 0.001, 0.0);
        pose.method_22907((Quaternionfc)facing.method_23224());
        pose.method_22904(-0.5, 0.0, -0.5);
        pose.method_22904(0.5, -0.375, -0.3125);
        if (state.playingAnimation) {
            state.applyAnimation(0, 1, time -> pose.method_22904(0.0, 0.0, -0.5 * (double)(1.0f - time.floatValue())));
            state.applyAnimation(0, 1, time -> {
                float scale = 0.25f + 0.75f * time.floatValue();
                pose.method_22904(0.0, 0.1875, 0.5);
                pose.method_22905(scale, scale, scale);
                pose.method_22904(0.0, -0.1875, -0.5);
            });
            state.applyAnimation(1, 4, time -> {
                float stretch = class_3532.method_15374((double)((float)Math.PI * time.floatValue())) * 0.25f;
                float flatten = class_3532.method_15374((double)((float)Math.PI * time.floatValue())) * 0.15f * -1.0f;
                pose.method_22904(0.0, 0.1875, 0.5);
                pose.method_22905(1.0f + stretch, 1.0f + stretch, 1.0f + flatten);
                pose.method_22904(0.0, -0.1875, -0.5);
            });
        }
        if ((offset = state.shelfOffset) != null) {
            pose.method_22904((double)offset.x() * 0.0625, (double)offset.z() * 0.0625, (double)(-offset.y()) * 0.0625);
        }
        pose.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        pose.method_22905(1.0f, -1.0f, -1.0f);
        BackpackRenderer renderer = state.renderer;
        if (renderer != null) {
            BackpackRenderContext context = new BackpackRenderContext(Scene.ON_SHELF, RenderMode.MODELS_ONLY, pose, state.baseModel, state.strapsModel, null, null, 0, state.field_62676, state.renderTicks, state.partialTick, model -> {
                pose.method_22903();
                pose.method_46416(-0.5f, -0.5f, -0.5f);
                StandaloneModelRenderer.submitDraw((class_11659)collector, (class_10889)model, (class_4587)pose, (float)1.0f, (float)1.0f, (float)1.0f, (int)state.field_62676, (int)class_4608.field_21444);
                pose.method_22909();
            });
            renderer.render(context);
        } else {
            FrameworkBakedModel model2;
            FrameworkModelResource<FrameworkBakedModel> resource = StandaloneModels.getResource(state.baseModel);
            if (resource != null && (model2 = (FrameworkBakedModel)resource.getModel()) != null) {
                pose.method_22903();
                pose.method_46416(-0.5f, -0.5f, -0.5f);
                StandaloneModelRenderer.submitDraw((class_11659)collector, (class_10889)model2, (class_4587)pose, (float)1.0f, (float)1.0f, (float)1.0f, (int)state.field_62676, (int)class_4608.field_21444);
                pose.method_22909();
            }
        }
        pose.method_22909();
    }

    private void renderBackpackName(ShelfRenderState state, class_2350 facing, class_4587 poseStack, class_11659 collector, class_12075 camera) {
        int recallCount;
        class_3965 result;
        if (state.nameplate == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.0, 0.5);
        poseStack.method_22907((Quaternionfc)facing.method_23224());
        poseStack.method_22904(0.0, -0.1875, -1.1875);
        poseStack.method_22907((Quaternionfc)facing.method_23224().invert());
        poseStack.method_22907((Quaternionfc)this.entityRenderDispatcher.field_4686.method_23767());
        poseStack.method_22905(0.02f, -0.02f, 0.02f);
        class_310 mc = class_310.method_1551();
        class_239 class_2392 = mc.field_1765;
        if (class_2392 instanceof class_3965 && (result = (class_3965)class_2392).method_17777().equals((Object)state.field_62673)) {
            collector.method_73482(poseStack, null, 0, state.nameplate, true, state.field_62676, 0.0, camera);
        }
        if ((recallCount = state.recallQueueCount) > 0) {
            poseStack.method_22905(1.1f, 1.1f, 1.1f);
            class_2561 label = ScreenUtil.join(" ", new class_2561[]{RECALL_ICON, class_2561.method_43470((String)Integer.toString(recallCount))});
            collector.method_73482(poseStack, null, 0, label, true, state.field_62676, 0.0, camera);
        }
        poseStack.method_22909();
    }
}

