/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer;

import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.backpack.ModelMeta;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.LevelDataState;
import com.mrcrayfish.backpacked.client.renderer.backpack.LivingEntityDataState;
import com.mrcrayfish.backpacked.client.renderer.backpack.RenderMode;
import com.mrcrayfish.backpacked.client.renderer.backpack.Scene;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.Optional;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11890;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class FirstPersonEffectsRenderer {
    public static void draw(class_742 player, class_4587 pose, class_4597 source, float partialTick) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 cameraPos = camera.method_71156();
        double playerX = class_3532.method_16436((double)partialTick, (double)player.field_6038, (double)player.method_23317()) - cameraPos.method_10216();
        double playerY = class_3532.method_16436((double)partialTick, (double)player.field_5971, (double)player.method_23318()) - cameraPos.method_10214();
        double playerZ = class_3532.method_16436((double)partialTick, (double)player.field_5989, (double)player.method_23321()) - cameraPos.method_10215();
        class_1007 renderer = (class_1007)mc.method_1561().method_3953((class_1297)player);
        class_10055 avatarRenderState = new class_10055();
        avatarRenderState.field_53410 = player.method_18276();
        avatarRenderState.field_53453 = player.method_55693();
        class_243 offset = renderer.method_23206(avatarRenderState);
        double renderX = playerX + offset.method_10216();
        double renderY = playerY + offset.method_10214();
        double renderZ = playerZ + offset.method_10215();
        pose.method_22903();
        pose.method_22904(renderX, renderY, renderZ);
        FirstPersonEffectsRenderer.setupTransforms(player, (class_1007<class_742>)renderer, pose, partialTick);
        FirstPersonEffectsRenderer.setupBodyRotations(player, (class_1007<class_742>)renderer, pose);
        if (!player.method_7325()) {
            int light = mc.method_1561().method_23839((class_1297)player, partialTick);
            FirstPersonEffectsRenderer.renderBackpack(player, pose, source, light, partialTick);
        }
        pose.method_22909();
    }

    private static void setupTransforms(class_742 player, class_1007<class_742> renderer, class_4587 stack, float partialTick) {
        float scale = player.method_55693();
        stack.method_22905(scale, scale, scale);
        float bodyRot = class_3532.method_17821((float)partialTick, (float)player.field_6220, (float)player.field_6283);
        class_10055 state = new class_10055();
        renderer.method_62604((class_11890)player, state, partialTick);
        ClientServices.CLIENT.invokeRotationSetup(renderer, state, stack, bodyRot, scale);
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        stack.method_22905(0.9375f, 0.9375f, 0.9375f);
        stack.method_46416(0.0f, -1.501f, 0.0f);
        float defaultEyeHeight = player.method_18381(class_4050.field_18076);
        float deltaEyeHeight = player.method_5751() - defaultEyeHeight;
        stack.method_46416(0.0f, -deltaEyeHeight, 0.0f);
    }

    private static void setupBodyRotations(class_742 player, class_1007<class_742> renderer, class_4587 pose) {
        class_630 body = ((class_591)renderer.method_4038()).field_3391;
        body.field_3675 = 0.0f;
        body.field_3654 = player.method_18276() ? 0.5f : 0.0f;
        body.field_3656 = player.method_18276() ? 3.2f : 0.0f;
        body.method_22703(pose);
    }

    private static void renderBackpack(class_742 player, class_4587 pose, class_4597 source, int light, float partialTick) {
        Optional propertiesOptional = (Optional)ModSyncedDataKeys.COSMETIC_PROPERTIES.getValue((class_1297)player);
        if (propertiesOptional.isEmpty()) {
            return;
        }
        CosmeticProperties properties = (CosmeticProperties)propertiesOptional.get();
        class_1799 chestStack = player.method_6118(class_1304.field_6174);
        if (chestStack.method_7909() == class_1802.field_8833 && !properties.showWithElytra()) {
            return;
        }
        if (!Services.BACKPACK.isBackpackVisible((class_1657)player)) {
            return;
        }
        class_2960 cosmeticId = properties.cosmetic().orElse(BackpackManager.getDefaultOrFallbackCosmetic());
        ClientBackpack backpack = ClientRegistry.instance().getBackpackOrDefault(cosmeticId);
        if (backpack == null) {
            return;
        }
        pose.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        pose.method_22905(1.05f, -1.05f, -1.05f);
        int offset = !chestStack.method_7960() ? 3 : 2;
        pose.method_22904(0.0, -0.06, (double)offset * 0.0625);
        float giantScale = 1.0f + 0.5f * (float)((Integer)ModSyncedDataKeys.BACKPACK_SCALE.getValue((class_1297)player)).intValue();
        pose.method_22905(giantScale, giantScale, giantScale);
        ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
        meta.renderer().ifPresent(renderer -> renderer.render(new BackpackRenderContext(Scene.ON_ENTITY, RenderMode.EFFECTS_ONLY, pose, backpack.getBaseModel(), backpack.getStrapsModel(), LivingEntityDataState.create((class_1309)player, partialTick), LevelDataState.create(player.method_73183(), partialTick), player.method_5628(), light, player.field_6012, partialTick, model -> {})));
    }
}

