/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown;

import com.mrcrayfish.backpacked.client.gui.screen.layout.PaddedLinearLayout;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.Alignment;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.MenuItem;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import org.jetbrains.annotations.Nullable;

public class DropdownMenu
extends PopupMenu {
    private final PaddedLinearLayout layout = (PaddedLinearLayout)PaddedLinearLayout.vertical().padding(3).method_52735(2);

    private DropdownMenu(PopupMenuHandler handler) {
        super(handler);
    }

    @Override
    protected class_8133 layout() {
        return this.layout;
    }

    @Override
    public void method_48206(Consumer<class_339> consumer) {
        this.layout.method_48206(consumer);
    }

    protected void addItem(MenuItem item) {
        item.owner = this;
        this.layout.method_52736((class_8021)item);
        this.invalidateWidgets();
    }

    public static Builder builder(PopupMenuHandler handler) {
        return new Builder(handler);
    }

    public static class Builder {
        private final PopupMenuHandler handler;
        private final List<MenuItem> items = new ArrayList<MenuItem>();
        private int minItemWidth = 0;
        private int minItemHeight = 20;
        @Nullable
        private Alignment alignment;
        @Nullable
        private class_2960 background = Utils.id("backpack/dropdown/background");
        @Nullable
        private Integer border;
        @Nullable
        private Integer spacing;

        private Builder(PopupMenuHandler handler) {
            this.handler = handler;
        }

        public Builder setMinItemSize(int width, int height) {
            this.minItemWidth = width;
            this.minItemHeight = height;
            return this;
        }

        public Builder setBackground(@Nullable class_2960 background) {
            this.background = background;
            return this;
        }

        public Builder setBorder(int border) {
            this.border = border;
            return this;
        }

        public Builder setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder setAlignment(Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder addItem(MenuItem item) {
            this.items.add(item);
            return this;
        }

        public DropdownMenu build() {
            DropdownMenu menu = new DropdownMenu(this.handler);
            int maxWidth = this.items.stream().mapToInt(MenuItem::calculateWidth).max().orElse(100);
            this.items.forEach(item -> {
                item.method_55445(Math.max(maxWidth, this.minItemWidth), this.minItemHeight);
                menu.addItem((MenuItem)((Object)item));
            });
            if (this.alignment != null) {
                menu.setAlignment(this.alignment);
            }
            menu.setBackground(this.background);
            if (this.border != null) {
                menu.layout.padding(this.border);
            }
            if (this.spacing != null) {
                menu.layout.method_52735(this.spacing);
            }
            return menu;
        }
    }
}

