/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget.popup;

import com.mrcrayfish.backpacked.client.gui.screen.layout.PaddedLayout;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.Alignment;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuController;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.DeferredWidgetDraw;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8133;
import org.jetbrains.annotations.Nullable;

public abstract class PopupMenu
implements class_4068,
class_364,
class_8021 {
    final PopupMenuController controller;
    @Nullable
    PopupMenu parent;
    @Nullable
    PopupMenu child;
    private int x;
    private int y;
    private int width;
    private int height;
    @Nullable
    private List<class_339> cachedWidgets;
    private Alignment alignment = Alignment.END_TOP;
    @Nullable
    private class_2960 background;
    private int screenClampPadding = 0;
    private final List<class_339> deferredDraws = new LinkedList<class_339>();

    protected PopupMenu(PopupMenuHandler handler) {
        this.controller = handler.getPopupMenuController();
    }

    protected abstract class_8133 layout();

    protected int padding() {
        int n;
        class_8133 class_81332 = this.layout();
        if (class_81332 instanceof PaddedLayout) {
            PaddedLayout layout = (PaddedLayout)class_81332;
            n = layout.padding();
        } else {
            n = 0;
        }
        return n;
    }

    public void method_46421(int x) {
        this.x = x;
    }

    public void method_46419(int y) {
        this.y = y;
    }

    public int method_46426() {
        return this.x;
    }

    public int method_46427() {
        return this.y;
    }

    public int method_25368() {
        return this.width;
    }

    public int method_25364() {
        return this.height;
    }

    public void method_48206(Consumer<class_339> consumer) {
        this.layout().method_48206(consumer);
    }

    protected void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    protected void setBackground(@Nullable class_2960 background) {
        this.background = background;
    }

    List<class_339> getWidgets() {
        if (this.cachedWidgets == null) {
            ArrayList widgets = new ArrayList();
            this.layout().method_48206(widgets::add);
            this.cachedWidgets = List.copyOf(widgets);
        }
        return this.cachedWidgets;
    }

    protected void invalidateWidgets() {
        this.cachedWidgets = null;
    }

    protected void fillBackground(class_332 graphics) {
        class_310 minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        graphics.method_25294(0, 0, window.method_4489(), window.method_4506(), 0x50000000);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
        if (this.background != null) {
            graphics.method_52706(class_10799.field_56883, this.background, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }
        this.getWidgets().forEach(widget -> {
            DeferredWidgetDraw render;
            if (widget instanceof DeferredWidgetDraw && (render = (DeferredWidgetDraw)widget).shouldDefer()) {
                this.deferredDraws.add((class_339)widget);
            } else {
                widget.method_25394(graphics, mouseX, mouseY, deltaTick);
            }
        });
        if (this.child != null) {
            this.child.fillBackground(graphics);
            this.deferredDraws.forEach(widget -> widget.method_25394(graphics, mouseX, mouseY, deltaTick));
            this.child.method_25394(graphics, mouseX, mouseY, deltaTick);
        }
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return this.controller.top() == this;
    }

    public class_8030 method_48202() {
        return new class_8030(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
    }

    public void show(class_339 widget) {
        this.show(widget.method_48202());
    }

    public void show(class_8030 rect) {
        this.updatePosition(rect);
        this.controller.open(this);
    }

    public void close() {
        this.controller.close(this);
    }

    public void deepClose() {
        this.controller.closeAll();
    }

    private void updatePosition(class_8030 rect) {
        class_8133 layout = this.layout();
        layout.method_48222();
        this.width = layout.method_25368();
        this.height = layout.method_25364();
        this.alignment.aligner().accept(this, rect);
        layout.method_46421(this.method_46426());
        layout.method_46419(this.method_46427());
        this.clampToWindow();
    }

    private void clampToWindow() {
        class_1041 window = class_310.method_1551().method_22683();
        this.method_46421(class_3532.method_15340((int)this.method_46426(), (int)this.screenClampPadding, (int)(window.method_4486() - this.method_25368() - this.screenClampPadding)));
        this.method_46419(class_3532.method_15340((int)this.method_46427(), (int)this.screenClampPadding, (int)(window.method_4502() - this.method_25364() - this.screenClampPadding)));
        class_8133 layout = this.layout();
        layout.method_46421(this.method_46426());
        layout.method_46419(this.method_46427());
    }

    public boolean hasChild() {
        return this.child != null;
    }

    public void setScreenClampPadding(int screenClampPadding) {
        this.screenClampPadding = screenClampPadding;
    }

    public boolean isOpen() {
        return this.controller.contains(this);
    }
}

