/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class Stepper
extends class_339 {
    private static final class_8666 BUTTON_SPRITES = new class_8666(Utils.id("backpack/button_enabled"), Utils.id("backpack/button_disabled"), Utils.id("backpack/button_enabled_focused"));
    private static final class_2960 BACKGROUND_SPRITE = Utils.id("backpack/stepper_background");
    private static final class_2960 INCREMENT_SPRITE = Utils.id("backpack/stepper_increment");
    private static final class_2960 DECREMENT_SPRITE = Utils.id("backpack/stepper_decrement");
    private static final IntRange DEFAULT_RANGE = new IntRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final IntRange range;
    @Nullable
    private final Consumer<Integer> callback;
    private final boolean wrap;
    private int value;

    private Stepper(int x, int y, int width, int height, IntRange range, @Nullable Consumer<Integer> callback, boolean wrap, int initialValue) {
        super(x, y, width, height, class_5244.field_39003);
        this.range = range;
        this.callback = callback;
        this.wrap = wrap;
        this.value = initialValue;
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_52706(class_10799.field_56883, BACKGROUND_SPRITE, this.method_46426() + this.method_25364(), this.method_46427() + 1, this.method_25368() - this.method_25364() * 2, this.method_25364() - 2);
        boolean leftHovered = this.isDecrementHovered(mouseX, mouseY);
        graphics.method_52706(class_10799.field_56883, BUTTON_SPRITES.method_52729(true, leftHovered), this.method_46426(), this.method_46427(), this.method_25364(), this.method_25364());
        graphics.method_52706(class_10799.field_56883, DECREMENT_SPRITE, this.method_46426() + (this.method_25364() - 4) / 2, this.method_46427() + (this.method_25364() - 6) / 2, 4, 6);
        boolean rightHovered = this.isIncrementHovered(mouseX, mouseY);
        graphics.method_52706(class_10799.field_56883, BUTTON_SPRITES.method_52729(true, rightHovered), this.method_46426() + this.method_25368() - this.method_25364(), this.method_46427(), this.method_25364(), this.method_25364());
        graphics.method_52706(class_10799.field_56883, INCREMENT_SPRITE, this.method_46426() + this.method_25368() - this.method_25364() + (this.method_25364() - 4) / 2, this.method_46427() + (this.method_25364() - 6) / 2, 4, 6);
        graphics.method_25300(class_310.method_1551().field_1772, Integer.toString(this.value), this.method_46426() + this.method_25368() / 2, this.method_46427() + (this.method_25364() - 10) / 2 + 1, -1);
    }

    protected void method_47399(class_6382 output) {
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.isDecrementHovered((int)mouseX, (int)mouseY) || this.isIncrementHovered((int)mouseX, (int)mouseY);
    }

    protected boolean method_25351(class_11910 p_447020_) {
        return super.method_25351(p_447020_);
    }

    public void method_25348(class_11909 event, boolean doubleClick) {
        if (this.isDecrementHovered((int)event.comp_4798(), (int)event.comp_4799())) {
            this.adjustValue(-1);
            if (this.callback != null) {
                this.callback.accept(this.value);
            }
        } else if (this.isIncrementHovered((int)event.comp_4798(), (int)event.comp_4799())) {
            this.adjustValue(1);
            if (this.callback != null) {
                this.callback.accept(this.value);
            }
        }
    }

    private void adjustValue(int step) {
        long min = this.range.min();
        long max = this.range.max();
        if (this.wrap) {
            long length = max - min + 1L;
            long newValue = min + Math.floorMod((long)this.value - min + (long)step, length);
            this.value = (int)newValue;
        } else {
            long newValue = (long)this.value + (long)step;
            this.value = (int)class_3532.method_53062((long)newValue, (long)min, (long)max);
        }
    }

    private boolean isDecrementHovered(int mouseX, int mouseY) {
        return ScreenUtil.isPointInArea(mouseX, mouseY, this.method_46426(), this.method_46427(), this.method_25364(), this.method_25364());
    }

    private boolean isIncrementHovered(int mouseX, int mouseY) {
        return ScreenUtil.isPointInArea(mouseX, mouseY, this.method_46426() + this.method_25368() - this.method_25364(), this.method_46427(), this.method_25364(), this.method_25364());
    }

    public static Builder builder() {
        return new Builder();
    }

    private record IntRange(int min, int max) {
    }

    public static class Builder {
        private int x;
        private int y;
        private int width = 100;
        private int height = 20;
        private int initialValue;
        private IntRange range = DEFAULT_RANGE;
        private boolean wrap = false;
        @Nullable
        private Consumer<Integer> callback;

        private Builder() {
        }

        public Builder setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setInitialValue(int initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public Builder setRange(int min, int max) {
            this.range = new IntRange(min, max);
            return this;
        }

        public Builder setWrap(boolean wrap) {
            this.wrap = wrap;
            return this;
        }

        public Builder setOnChange(Consumer<Integer> callback) {
            this.callback = callback;
            return this;
        }

        public Stepper build() {
            return new Stepper(this.x, this.y, this.width, this.height, this.range, this.callback, this.wrap, this.initialValue);
        }
    }
}

