/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_10017;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PlayerDisplay
extends class_339 {
    private static final class_2960 FRAME = Utils.id("backpack/frame");
    private static final int FRAME_OFFSET = 4;
    private final class_1657 player;
    private final Supplier<CosmeticProperties> propertiesSupplier;
    private float rotationX = 35.0f;
    private float rotationY = 10.0f;
    private boolean grabbed;
    private int grabbedX;
    private int grabbedY;
    private float origBodyRot;
    private float origBodyRotOld;
    private float origYaw;
    private float origYawOld;
    private float origPitch;
    private float origPitchOld;
    private float origHeadYaw;
    private float origHeadYawOld;
    private CosmeticProperties origProperties;

    public PlayerDisplay(class_1657 player, int x, int y, int width, int height, Supplier<CosmeticProperties> propertiesSupplier) {
        super(x, y, width, height, class_5244.field_39003);
        this.player = player;
        this.propertiesSupplier = propertiesSupplier;
    }

    protected void method_47399(class_6382 output) {
        this.method_37021(output);
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int widgetX = this.method_46426();
        int widgetY = this.method_46427();
        int widgetWidth = this.method_25368();
        int widgetHeight = this.method_25364();
        graphics.method_52706(class_10799.field_56883, FRAME, widgetX, widgetY, widgetWidth, widgetHeight);
        Matrix3x2fStack pose = graphics.method_51448();
        pose.pushMatrix();
        graphics.method_44379(widgetX + 4, widgetY + 4, widgetX + widgetWidth - 4, widgetY + widgetHeight - 4);
        this.renderPlayerModel(graphics, widgetX, widgetY, widgetWidth, widgetHeight, mouseX, mouseY);
        graphics.method_44380();
        pose.popMatrix();
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (!(this.field_22763 && this.field_22764 && this.method_25351(event.comp_4800()))) {
            return false;
        }
        if (ScreenUtil.isPointInArea((int)event.comp_4798(), (int)event.comp_4799(), this.method_46426() + 4, this.method_46427() + 4, this.method_25368() - 8, this.method_25364() - 8) && !this.grabbed) {
            this.grabbed = true;
            this.grabbedX = (int)event.comp_4798();
            this.grabbedY = (int)event.comp_4799();
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 event) {
        if (this.grabbed && this.method_25351(event.comp_4800())) {
            this.rotationX += (float)(event.comp_4798() - (double)this.grabbedX);
            this.rotationY += (float)(event.comp_4799() - (double)this.grabbedY);
            this.grabbed = false;
            return true;
        }
        return false;
    }

    private void renderPlayerModel(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        if (this.player == null) {
            return;
        }
        this.captureValues();
        this.overrideValues();
        Quaternionf playerRotation = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraRotation = new Quaternionf();
        cameraRotation.mul((Quaternionfc)class_7833.field_40713.rotationDegrees(this.rotationY + (float)(this.grabbed ? mouseY - this.grabbedY : 0)));
        cameraRotation.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(this.rotationX + (float)(this.grabbed ? mouseX - this.grabbedX : 0)));
        playerRotation.mul((Quaternionfc)cameraRotation);
        class_10017 state = PlayerDisplay.createPlayerRenderState((class_1309)this.player);
        Vector3f box = new Vector3f(0.0f, state.field_53330 / 2.0f + 0.0625f, 0.0f);
        graphics.method_70856(state, 70.0f, box, playerRotation, cameraRotation, x, y, x + width, y + height);
        this.restoreValues();
    }

    private static class_10017 createPlayerRenderState(class_1309 entity) {
        class_898 dispatcher = class_310.method_1551().method_1561();
        class_897 renderer = dispatcher.method_3953((class_1297)entity);
        class_10017 state = renderer.method_62425((class_1297)entity, 1.0f);
        state.field_61820 = 0xF000F0;
        state.field_61823.clear();
        state.field_61821 = 0;
        return state;
    }

    private void captureValues() {
        this.origBodyRot = this.player.field_6283;
        this.origBodyRotOld = this.player.field_6220;
        this.origYaw = this.player.method_36454();
        this.origYawOld = this.player.field_5982;
        this.origPitch = this.player.method_36455();
        this.origPitchOld = this.player.field_6004;
        this.origHeadYaw = this.player.field_6241;
        this.origHeadYawOld = this.player.field_6259;
        this.origProperties = ((Optional)ModSyncedDataKeys.COSMETIC_PROPERTIES.getValue((class_1297)this.player)).orElse(CosmeticProperties.DEFAULT);
    }

    private void overrideValues() {
        this.player.field_6283 = 0.0f;
        this.player.field_6220 = 0.0f;
        this.player.method_36456(0.0f);
        this.player.field_5982 = 0.0f;
        this.player.method_36457(15.0f);
        this.player.field_6004 = 15.0f;
        this.player.field_6241 = this.player.method_36454();
        this.player.field_6259 = this.player.method_36454();
        ModSyncedDataKeys.COSMETIC_PROPERTIES.setValue((class_1297)this.player, Optional.ofNullable(this.propertiesSupplier.get()));
    }

    private void restoreValues() {
        this.player.field_6283 = this.origBodyRot;
        this.player.field_6220 = this.origBodyRotOld;
        this.player.method_36456(this.origYaw);
        this.player.field_5982 = this.origYawOld;
        this.player.method_36457(this.origPitch);
        this.player.field_6004 = this.origPitchOld;
        this.player.field_6241 = this.origHeadYaw;
        this.player.field_6259 = this.origHeadYawOld;
        ModSyncedDataKeys.COSMETIC_PROPERTIES.setValue((class_1297)this.player, Optional.ofNullable(this.origProperties));
    }
}

