/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.client.gui.StateSprites;
import com.mrcrayfish.backpacked.common.FilterableItems;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import com.mrcrayfish.framework.api.client.screen.widget.FrameworkSelectionList;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Border;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Padding;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public final class ItemGrid<T extends FilterableItems<T>>
extends FrameworkSelectionList {
    private static final class_2960 LIST_BACKGROUND_SPRITE = Utils.id("backpack/list/background");
    private static final StateSprites ITEM_SPRITES = new StateSprites(Utils.id("backpack/list/item"), Utils.id("backpack/list/item_hovered"), Utils.id("backpack/list/item_selected"), Utils.id("backpack/list/item_selected"));
    private static final FrameworkSelectionList.ScrollerSprites SCROLLER_SPRITES = FrameworkSelectionList.ScrollerSprites.of((class_2960)Utils.id("backpack/list/scroll_bar"), (class_2960)Utils.id("backpack/list/scroll_bar"), (class_2960)Utils.id("backpack/list/scroll_bar_hovered"), (class_2960)Utils.id("backpack/list/scroll_bar_selected"));
    private final Supplier<T> supplier;
    private final Consumer<T> updater;
    private final int itemSize;
    private final int spacing;
    private final List<class_1792> items;
    private String searchQuery;
    private boolean selectedOnly;
    @Nullable
    private class_1799 hoveredStack;

    private ItemGrid(Supplier<T> supplier, Consumer<T> updater, int width, int height, int itemSize, int spacing, String lastQuery, Predicate<class_1792> predicate) {
        super(width, height, 0, 0, itemSize);
        this.supplier = supplier;
        this.updater = updater;
        this.itemSize = itemSize;
        this.spacing = spacing;
        this.items = (List)class_7923.field_41178.method_10220().filter(predicate).collect(ImmutableList.toImmutableList());
        this.listBackground = LIST_BACKGROUND_SPRITE;
        this.scrollBarBackground = LIST_BACKGROUND_SPRITE;
        this.scrollBarBorder = Border.of((int)1);
        this.scrollBarPadding = Padding.of((int)spacing);
        this.scrollBarSpacing = spacing;
        this.scrollerSprites = SCROLLER_SPRITES;
        this.listBorder = Border.of((int)1);
        this.listPadding = Padding.of((int)spacing);
        this.itemSpacing = spacing;
        this.scrollerWidth = 10;
        this.scrollBarStyle = FrameworkSelectionList.ScrollBarStyle.DETACHED;
        this.scrollBarAlwaysVisible = true;
        this.searchQuery = lastQuery;
        this.updateList();
    }

    private void updateList() {
        String search = this.searchQuery.toLowerCase().trim();
        boolean empty = search.trim().isBlank();
        this.method_25339();
        ArrayList<class_1792> visibleItems = new ArrayList<class_1792>();
        this.items.forEach(item -> {
            if (item == class_1802.field_8162) {
                return;
            }
            if ((!this.selectedOnly || ((FilterableItems)this.supplier.get()).isFilteringItem((class_1792)item)) && (empty || item.method_63680().getString().toLowerCase(Locale.ROOT).contains(search))) {
                visibleItems.add((class_1792)item);
            }
        });
        if (!empty) {
            visibleItems.sort(Comparator.comparingInt(item -> {
                String name = item.method_63680().getString().toLowerCase(Locale.ROOT);
                if (name.equals(search)) {
                    return 0;
                }
                if (name.startsWith(search)) {
                    return 1;
                }
                return 2;
            }).thenComparing(item -> item.method_63680().getString()));
        } else {
            visibleItems.sort(Comparator.comparing(item -> item.method_63680().getString()));
        }
        int chunkSize = (this.method_25322() + this.spacing) / (this.itemSize + this.spacing);
        for (int i = 0; i < class_3532.method_38788((int)visibleItems.size(), (int)chunkSize); ++i) {
            int start = i * chunkSize;
            int end = Math.min(start + chunkSize, visibleItems.size());
            this.method_25321((class_350.class_351)new Row<T>(this, visibleItems.subList(start, end), this.supplier, this.updater));
        }
    }

    public void setSelectedOnly(boolean selectedOnly) {
        this.selectedOnly = selectedOnly;
        this.updateList();
        this.method_65506();
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.hoveredStack = null;
        super.method_48579(graphics, mouseX, mouseY, partialTick);
        if (ScreenUtil.isPointInArea(mouseX, mouseY, this.method_46426(), this.method_46427() + this.listBorder.top(), this.method_25368(), this.method_25364() - this.listBorder.top() - this.listBorder.bottom()) && this.hoveredStack != null) {
            graphics.method_51446(class_310.method_1551().field_1772, this.hoveredStack, mouseX, mouseY);
        }
    }

    public void setSelected(@Nullable FrameworkSelectionList.Item item) {
    }

    public void setSearchQuery(String searchQuery) {
        if (!this.searchQuery.equals(searchQuery)) {
            this.searchQuery = searchQuery;
            this.updateList();
            this.method_65506();
        }
    }

    public void setActive(Supplier<Boolean> activeSupplier) {
        this.activeSupplier = activeSupplier;
    }

    public static <T extends FilterableItems<T>> Builder<T> builder(Supplier<T> supplier, Consumer<T> updater) {
        return new Builder<T>(supplier, updater);
    }

    protected static final class Row<R extends FilterableItems<R>>
    extends FrameworkSelectionList.Item {
        private final ItemGrid<R> parent;
        private final List<class_1799> display;
        private final Supplier<R> supplier;
        private final Consumer<R> updater;

        private Row(ItemGrid<R> parent, List<class_1792> items, Supplier<R> augment, Consumer<R> updater) {
            this.parent = parent;
            this.display = (List)items.stream().map(class_1799::new).collect(ImmutableList.toImmutableList());
            this.supplier = augment;
            this.updater = updater;
        }

        protected void renderContent(class_332 graphics, int mouseX, int mouseY, boolean hovered, boolean selected, float partialTick) {
            int itemSize = this.parent.itemSize;
            int spacing = this.parent.spacing;
            int halfSpacing = spacing / 2;
            boolean active = this.parent.method_37303();
            for (int i = 0; i < this.display.size(); ++i) {
                class_1799 stack = this.display.get(i);
                int offset = i * (itemSize + spacing);
                boolean itemSelected = ((FilterableItems)this.supplier.get()).isFilteringItem(stack.method_7909());
                boolean itemHovered = active && ScreenUtil.isPointInArea(mouseX, mouseY, this.method_73380() + offset - halfSpacing, this.method_73382() - halfSpacing, itemSize + spacing, itemSize + spacing);
                int alpha = class_9848.method_61317((float)(active ? 1.0f : 0.5f));
                graphics.method_52707(class_10799.field_56883, ITEM_SPRITES.get(itemSelected, itemHovered), this.method_73380() + offset, this.method_73382(), itemSize, itemSize, alpha);
                graphics.method_51445(stack, this.method_73380() + offset + (itemSize - 16) / 2, this.method_73382() + (itemSize - 16) / 2);
                if (!itemHovered) continue;
                this.parent.hoveredStack = stack;
            }
        }

        public class_2561 method_37006() {
            return class_5244.field_39003;
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (event.method_74245() == 0) {
                int itemSize = this.parent.itemSize;
                int spacing = this.parent.spacing;
                int halfSpacing = spacing / 2;
                FilterableItems augment = (FilterableItems)this.supplier.get();
                for (int i = 0; i < this.display.size(); ++i) {
                    int offset = i * (itemSize + spacing);
                    if (!ScreenUtil.isPointInArea((int)event.comp_4798(), (int)event.comp_4799(), this.method_73380() + offset - halfSpacing, this.method_73382() - halfSpacing, itemSize + spacing, itemSize + spacing)) continue;
                    class_1799 stack = this.display.get(i);
                    if (!augment.isFilteringItem(stack.method_7909())) {
                        if (augment.isFilterFull()) continue;
                        this.updater.accept(augment.addItemFilter(stack.method_7909()));
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                        return true;
                    }
                    this.updater.accept(augment.removeItemFilter(stack.method_7909()));
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    return true;
                }
            }
            return false;
        }
    }

    public static class Builder<T extends FilterableItems<T>> {
        private final Supplier<T> supplier;
        private final Consumer<T> updater;
        private int width = 64;
        private int height = 64;
        private int itemSize = 18;
        private int spacing = 2;
        private String initialQuery = "";
        private Predicate<class_1792> predicate = item -> true;

        private Builder(Supplier<T> supplier, Consumer<T> updater) {
            this.supplier = supplier;
            this.updater = updater;
        }

        public Builder<T> setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder<T> setItemSize(int itemSize) {
            this.itemSize = itemSize;
            return this;
        }

        public Builder<T> setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder<T> setInitialQuery(String initialQuery) {
            this.initialQuery = initialQuery;
            return this;
        }

        public Builder<T> setPredicate(Predicate<class_1792> predicate) {
            this.predicate = predicate;
            return this;
        }

        public ItemGrid<T> build() {
            return new ItemGrid<T>(this.supplier, this.updater, this.width, this.height, this.itemSize, this.spacing, this.initialQuery, this.predicate);
        }
    }
}

