/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.inventory;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.gui.ExperienceCostTooltip;
import com.mrcrayfish.backpacked.client.gui.ItemCostTooltip;
import com.mrcrayfish.backpacked.client.gui.particle.Particle2D;
import com.mrcrayfish.backpacked.client.gui.particle.ScreenParticles;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.CustomContainerScreen;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageUnlockSlot;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_5819;
import net.minecraft.class_8001;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

public abstract class UnlockableContainerScreen<T extends class_1703>
extends CustomContainerScreen<T> {
    private static final class_2561 HOLD_TO_UNLOCK = class_2561.method_43471((String)"backpacked.gui.hold_to_unlock");
    private static final class_2960 ICON_LOCK = Utils.id("backpack/lock");
    private static final class_2960 ICON_LOCK_OUTLINED = Utils.id("backpack/lock_outlined");
    private static final class_2960 EXP_ORB = Utils.id("backpack/exp_orb");
    private static final int UNLOCK_TIME = 20;
    private final ScreenParticles screenParticles = new ScreenParticles();
    private final class_5819 random = class_5819.method_43047();
    private final class_1657 player;
    protected final Set<UnlockableSlot> selectedSlots = new LinkedHashSet<UnlockableSlot>();
    @Nullable
    private UnlockableSlot lastAddedUnlockableSlot;
    @Nullable
    private UnlockableSlot hoveredLockedSlot;
    private int heldUnlockTime;
    private int totalUnlockTime;
    protected boolean hideLockedSlots;
    protected boolean preventNextRelease;

    public UnlockableContainerScreen(T menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        this.player = inventory.field_7546;
    }

    public void setHideLockedSlots(boolean hideLockedSlots) {
        this.hideLockedSlots = hideLockedSlots;
    }

    protected void method_37432() {
        this.screenParticles.tickParticles();
        if (!this.selectedSlots.isEmpty()) {
            if (this.hoveredLockedSlot == null) {
                this.selectedSlots.clear();
                this.lastAddedUnlockableSlot = null;
                return;
            }
            if (this.heldUnlockTime-- <= 0) {
                List<Integer> slotIndexes = this.selectedSlots.stream().map(slot -> slot.field_7874).toList();
                Network.PLAY.sendToServer((Object)new MessageUnlockSlot(slotIndexes));
                this.selectedSlots.clear();
                this.lastAddedUnlockableSlot = null;
            } else if (this.heldUnlockTime % 2 == 0) {
                float pitch = 0.7f + 0.6f * (float)(this.totalUnlockTime - this.heldUnlockTime) / (float)Math.max(1, this.totalUnlockTime);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14627, (float)pitch, (float)0.25f));
            }
        }
    }

    @Override
    public void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.screenParticles.renderParticles(graphics);
    }

    protected void method_64508(class_332 graphics, int mouseX, int mouseY) {
        super.method_64508(graphics, mouseX, mouseY);
        if (!this.selectedSlots.isEmpty()) {
            int progressWidth = (int)((float)(16 * (this.totalUnlockTime - this.heldUnlockTime)) / (float)Math.max(1, this.totalUnlockTime));
            for (UnlockableSlot slot : this.selectedSlots) {
                int progressX = slot.field_7873;
                int progressY = slot.field_7872;
                graphics.method_25294(progressX, progressY, progressX + progressWidth, progressY + 16, -2002256052);
            }
        }
        this.hoveredLockedSlot = null;
        for (class_1735 slot : this.field_2797.field_7761) {
            if (!(slot instanceof UnlockableSlot)) continue;
            UnlockableSlot lockedSlot = (UnlockableSlot)slot;
            if (this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY)) {
                this.hoveredLockedSlot = lockedSlot;
            }
            if (lockedSlot.isUnlocked()) continue;
            if (this.selectedSlots.contains(slot)) {
                graphics.method_52706(class_10799.field_56883, ICON_LOCK_OUTLINED, slot.field_7873 + 1, slot.field_7872 + 1, 14, 14);
                continue;
            }
            graphics.method_52706(class_10799.field_56883, ICON_LOCK, slot.field_7873 + 2, slot.field_7872 + 2, 12, 12);
            if (this.hoveredLockedSlot != lockedSlot || this.hideLockedSlots) {
                graphics.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, -2002216310);
            }
            if (!this.hideLockedSlots) continue;
            graphics.method_25294(slot.field_7873 - 1, slot.field_7872 - 1, slot.field_7873 + 17, slot.field_7872 + 17, -1427121212);
        }
    }

    protected void method_2380(class_332 graphics, int mouseX, int mouseY) {
        if (!(this.hoveredLockedSlot == null || this.hoveredLockedSlot.isUnlocked() || !this.field_2797.method_34255().method_7960() || this.hideLockedSlots && this.selectedSlots.isEmpty())) {
            List<class_5684> components = this.createUnlockTooltip(this.hoveredLockedSlot);
            ClientServices.CLIENT.drawTooltip(graphics, this.field_22793, components, mouseX, mouseY, class_8001.field_41687);
            return;
        }
        super.method_2380(graphics, mouseX, mouseY);
    }

    protected List<class_5684> createUnlockTooltip(UnlockableSlot slot) {
        class_2561 hintText = HOLD_TO_UNLOCK;
        int nextCost = slot.getNextUnlockCost(Math.max(1, this.selectedSlots.size()));
        boolean canAfford = slot.canAffordToUnlock(this.player, Math.max(1, this.selectedSlots.size()));
        ArrayList<class_5684> components = new ArrayList<class_5684>();
        switch (slot.getController().getCostModel().getPaymentType()) {
            case EXPERIENCE: {
                if (!canAfford) {
                    hintText = class_2561.method_43471((String)"backpacked.gui.not_enough_exp").method_27692(class_124.field_1061);
                }
                components.add(new ExperienceCostTooltip(nextCost));
                components.add((class_5684)new class_5683(hintText.method_30937()));
                break;
            }
            case ITEM: {
                if (!canAfford) {
                    hintText = class_2561.method_43471((String)"backpacked.gui.missing_items").method_27692(class_124.field_1061);
                }
                components.add(new ItemCostTooltip(slot.getController().getPaymentItem(), nextCost));
                components.add((class_5684)new class_5683(hintText.method_30937()));
            }
        }
        return components;
    }

    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (!(this.hasPopupMenu() || event.method_74245() != 0 || this.hoveredLockedSlot == null || this.hoveredLockedSlot.isUnlocked() || this.hideLockedSlots)) {
            if (this.isHoldingUnlockToken()) {
                Network.PLAY.sendToServer((Object)new MessageUnlockSlot(List.of(Integer.valueOf(this.hoveredLockedSlot.field_7874))));
                this.preventNextRelease = true;
                return true;
            }
            if (this.field_2797.method_34255().method_7960() && this.hoveredLockedSlot.canAffordToUnlock(this.player, 1)) {
                this.addSlotToSelected(this.hoveredLockedSlot);
                return true;
            }
        }
        return super.method_25402(event, doubleClick);
    }

    @Override
    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (!(this.hasPopupMenu() || event.method_74245() != 0 || this.lastAddedUnlockableSlot == null || this.hoveredLockedSlot == null || this.lastAddedUnlockableSlot == this.hoveredLockedSlot || this.hoveredLockedSlot.isUnlocked() || this.isHoldingUnlockToken() || this.selectedSlots.contains((Object)this.hoveredLockedSlot) || !this.hoveredLockedSlot.canAffordToUnlock(this.player, this.selectedSlots.size() + 1))) {
            this.addSlotToSelected(this.hoveredLockedSlot);
        }
        return super.method_25403(event, deltaX, deltaY);
    }

    protected void addSlotToSelected(UnlockableSlot slot) {
        this.selectedSlots.add(slot);
        this.lastAddedUnlockableSlot = slot;
        this.heldUnlockTime = this.totalUnlockTime = class_3532.method_15340((int)(20 + 4 * (this.selectedSlots.size() - 1)), (int)20, (int)80);
        float pitch = 0.6f + 0.4f * this.random.method_43057();
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_26963, (float)pitch, (float)0.6f));
    }

    @Override
    public boolean method_25406(class_11909 event) {
        if (this.preventNextRelease) {
            this.preventNextRelease = false;
            if (this.isHoldingUnlockToken()) {
                return true;
            }
        }
        if (event.method_74245() == 0 && !this.selectedSlots.isEmpty()) {
            this.selectedSlots.clear();
            this.lastAddedUnlockableSlot = null;
            return true;
        }
        return super.method_25406(event);
    }

    public void onSlotUnlocked(List<Integer> slotIndexes) {
        boolean playSound = false;
        for (int slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= this.field_2797.field_7761.size()) continue;
            class_1735 slot = this.field_2797.method_7611(slotIndex);
            if (!(slot instanceof UnlockableSlot)) {
                return;
            }
            int slotX = this.field_2776 + slot.field_7873;
            int slotY = this.field_2800 + slot.field_7872;
            this.spawnSlotUnlockedParticles(slotX, slotY);
            playSound = true;
        }
        if (playSound) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14709, (float)1.3f, (float)0.25f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_24065, (float)1.3f, (float)0.7f));
        }
    }

    protected void spawnSlotUnlockedParticles(int slotX, int slotY) {
        int i;
        Particle2D top = new Particle2D(slotX + 2, slotY + 2, 12.0, 6.0).setLife(50).setSprite(0.0f, 0.0f, 1.0f, 0.5f, ICON_LOCK).setMotion(new Vector2d((double)this.random.method_39332(-20, 20), -100.0)).setRotationSpeed(this.random.method_39332(-180, 180)).setGravity(new Vector2d(0.0, 12.0)).setFriction(0.025).setStartScale(1.0f, 40).setEndScale(0.0f);
        this.screenParticles.addParticle(top);
        Particle2D bottom = new Particle2D(slotX + 2, slotY + 8, 12.0, 6.0).setLife(50).setSprite(0.0f, 0.5f, 1.0f, 1.0f, ICON_LOCK).setMotion(new Vector2d((double)this.random.method_39332(-20, 20), 50.0)).setRotationSpeed(this.random.method_39332(-180, 180)).setGravity(new Vector2d(0.0, 12.0)).setFriction(0.025).setStartScale(1.0f, 40).setEndScale(0.0f);
        this.screenParticles.addParticle(bottom);
        for (i = 0; i < 10; ++i) {
            Particle2D damageParticle = new Particle2D(slotX + 7, slotY + 7, 2.0, 2.0).setLife(20).setSprite(0.45f, 0.5f, 0.55f, 0.6f, ICON_LOCK).setMotion(new Vector2d((double)class_3532.method_15362((double)((float)Math.PI * 2 * this.random.method_43057())), (double)class_3532.method_15374((double)((float)Math.PI * 2 * this.random.method_43057()))).mul((double)this.random.method_39332(50, 100))).setRotationSpeed(180.0).setGravity(new Vector2d(0.0, 12.0)).setFriction(0.05).setStartScale(1.0f).setEndScale(0.0f);
            this.screenParticles.addParticle(damageParticle);
        }
        if (((Boolean)Config.CLIENT.glitterBomb.get()).booleanValue()) {
            for (i = 0; i < 200; ++i) {
                Particle2D expOrbParticle = new Particle2D(slotX + 6, slotY + 6, 4.0, 4.0).setLife(50).setSprite(0.0f, 0.0f, 1.0f, 1.0f, EXP_ORB).setMotion(new Vector2d((double)class_3532.method_15362((double)((float)Math.PI * 2 * this.random.method_43057())), (double)class_3532.method_15374((double)((float)Math.PI * 2 * this.random.method_43057()))).mul((double)this.random.method_39332(1, 500))).setRotationSpeed(180.0).setGravity(new Vector2d(0.0, 20.0)).setFriction(0.05).setStartScale(1.0f).setEndScale(0.0f);
                this.screenParticles.addParticle(expOrbParticle);
            }
        }
    }

    protected boolean isHoldingUnlockToken() {
        return this.field_2797.method_34255().method_31574((class_1792)ModItems.UNLOCK_TOKEN.get());
    }
}

