/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.inventory;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.Icons;
import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentMenuFactory;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsFactories;
import com.mrcrayfish.backpacked.client.gui.ExperienceCostTooltip;
import com.mrcrayfish.backpacked.client.gui.ItemCostTooltip;
import com.mrcrayfish.backpacked.client.gui.MouseRestorer;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.UnlockableContainerScreen;
import com.mrcrayfish.backpacked.client.gui.screen.widget.AugmentPopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.BackpackButtons;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.EnumButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.MiniButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.TextInputMenu;
import com.mrcrayfish.backpacked.common.ItemSorting;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.UnlockableSlotMode;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.core.ModKeyMappings;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.inventory.container.UnlockableController;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageChangeAugment;
import com.mrcrayfish.backpacked.network.message.MessageRenameBackpack;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestManagement;
import com.mrcrayfish.backpacked.network.message.MessageSetAugmentState;
import com.mrcrayfish.backpacked.network.message.MessageSortBackpack;
import com.mrcrayfish.backpacked.network.message.MessageUnlockAugmentBay;
import com.mrcrayfish.backpacked.network.message.MessageUpdateAugment;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import com.mrcrayfish.framework.api.client.screen.widget.FrameworkButton;
import com.mrcrayfish.framework.api.client.screen.widget.element.Icon;
import com.mrcrayfish.framework.api.client.screen.widget.element.Sound;
import com.mrcrayfish.framework.api.client.screen.widget.input.Action;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8001;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8666;
import net.minecraft.class_8667;
import net.minecraft.class_9848;

public class BackpackScreen
extends UnlockableContainerScreen<BackpackContainerMenu> {
    private static final class_2561 MANAGEMENT_TOOLTIP = class_2561.method_43471((String)"backpacked.gui.manage_backpacks");
    private static final class_2561 CUSTOMISE_TOOLTIP = class_2561.method_43471((String)"backpacked.button.customise.tooltip");
    private static final class_2561 CONFIG_TOOLTIP = class_2561.method_43471((String)"backpacked.button.config.tooltip");
    private static final class_2561 CONFIGURE = class_2561.method_43471((String)"backpacked.gui.configure");
    private static final class_2561 SWAP_AUGMENT = class_2561.method_43471((String)"backpacked.gui.swap_augment");
    private static final class_2561 RENAME = class_2561.method_43471((String)"backpacked.gui.rename");
    private static final class_2561 SORT = class_2561.method_43471((String)"backpacked.gui.sort");
    public static final Function<class_2561, class_5250> HOLD_TO_EXPAND = component -> class_2561.method_43469((String)"backpacked.gui.hold_button_to_expand", (Object[])new Object[]{component});
    private static final class_2561 CLICK_TO_UNLOCK = class_2561.method_43471((String)"backpacked.gui.click_to_unlock");
    private static final class_2561 AUGMENT_BAY = class_2561.method_43471((String)"backpacked.gui.augment_bay");
    private static final class_2561 NOT_ENOUGH_EXP = class_2561.method_43471((String)"backpacked.gui.not_enough_exp");
    private static final class_2561 MISSING_ITEMS = class_2561.method_43471((String)"backpacked.gui.missing_items");
    private static final class_2960 BACKPACK_BACKGROUND = Utils.id("backpack/background");
    private static final class_2960 BACKPACK_SLOT = Utils.id("backpack/slot");
    private static final class_2960 INVENTORY_SPRITE = Utils.id("backpack/inventory");
    private static final class_2960 INVENTORY_SLOT = Utils.id("backpack/inventory_slot");
    private static final class_2960 LABEL_BACKGROUND = Utils.id("backpack/label");
    private static final class_2960 ICON_MANAGEMENT = Utils.id("backpack/management");
    private static final class_2960 ICON_CUSTOMISE = Utils.id("backpack/customise");
    private static final class_2960 ICON_CONFIG = Utils.id("backpack/config");
    private static final class_2960 ICON_PREVIOUS = Utils.id("backpack/previous");
    private static final class_2960 ICON_NEXT = Utils.id("backpack/next");
    private static final class_2960 ICON_RENAME = Utils.id("backpack/rename");
    private static final class_2960 ICON_SORT = Utils.id("backpack/sort");
    private static final class_2960 ICON_LOCK = Utils.id("backpack/lock");
    private static final class_2960 CHECKERS = Utils.id("backpack/checkers");
    private static final class_8666 AUGMENT_TOGGLE_SPRITES = new class_8666(Utils.id("backpack/augment_toggle_on"), Utils.id("backpack/augment_toggle_off"), Utils.id("backpack/augment_toggle_on_focused"), Utils.id("backpack/augment_toggle_off_focused"));
    private static final class_8666 AUGMENT_SETTINGS_SPRITES = new class_8666(Utils.id("backpack/augment_settings"), Utils.id("backpack/augment_settings_disabled"), Utils.id("backpack/augment_settings_focused"));
    private static final class_8666 BUTTON_TEXTURES = new class_8666(Utils.id("backpack/button_enabled"), Utils.id("backpack/button_disabled"), Utils.id("backpack/button_enabled_focused"));
    private static final class_8666 DISABLED_BUTTON_TEXTURES = new class_8666(Utils.id("backpack/button_disabled"), Utils.id("backpack/button_disabled"));
    private static final int TITLE_LABEL_WIDTH = 110;
    private static final int TITLE_PADDING = 5;
    private static final int BACKPACK_TOP = 16;
    private static final int BACKPACK_PADDING_TOP = 11;
    private static final int BACKPACK_PADDING_SIDE = 11;
    private static final int BACKPACK_PADDING_BOTTOM = 14;
    private static final int GAP = 3;
    private static final int INVENTORY_WIDTH = 176;
    private static final int INVENTORY_HEIGHT = 101;
    public static final int LABEL_PADDING = 5;
    private static ItemSorting sorting = ItemSorting.ALPHABETICAL;
    private final class_1657 player;
    private final int cols;
    private final int rows;
    private final boolean owner;
    private boolean opened;
    private int timer;
    private final List<class_8133> layouts = new ArrayList<class_8133>();
    private EnumMap<Augments.Position, FrameworkButton> augmentsButtons;

    public BackpackScreen(BackpackContainerMenu menu, class_1661 playerInventory, class_2561 titleIn) {
        super(menu, playerInventory, titleIn);
        this.player = playerInventory.field_7546;
        this.cols = menu.getCols();
        this.rows = menu.getRows();
        this.owner = menu.isOwner();
        this.field_2792 = 11 + Math.max(this.cols, 9) * 18 + 11;
        this.field_2779 = 27 + this.rows * 18 + 14 + 3 + 101;
        this.field_25267 = 6;
        this.field_25268 = 0;
        this.field_25269 = this.field_2792 / 2 - 80;
        this.field_25270 = this.field_2779 - 94;
        this.augmentsButtons = new EnumMap(Augments.Position.class);
    }

    public void method_25426() {
        MouseRestorer.loadCapturedPosition();
        super.method_25426();
        if (!this.opened) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_14581.comp_349()), (float)0.75f, (float)1.0f));
            this.opened = true;
        }
        this.layouts.clear();
        class_8133 titleLayout = this.createTitleLayout();
        titleLayout.method_48222();
        titleLayout.method_48229(this.field_2776 + (this.field_2792 - titleLayout.method_25368()) / 2, this.field_2800 + 5);
        titleLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.layouts.add(titleLayout);
        class_8667 actionsLayout = this.createActionsLayout();
        actionsLayout.method_48222();
        actionsLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        int backpackHeight = 11 + this.rows * 18 + 14;
        int buttonsHeight = 5 + actionsLayout.method_25364() + 5;
        int buttonLeft = this.field_2776 + this.field_2792 + 2;
        if (buttonsHeight > backpackHeight - 10) {
            buttonLeft += 6;
        }
        int buttonTop = this.field_2800 + 16 + (backpackHeight - buttonsHeight) / 2 + 5;
        actionsLayout.method_48229(buttonLeft, buttonTop);
        this.layouts.add((class_8133)actionsLayout);
        Pagination pagination = ((BackpackContainerMenu)this.field_2797).getPagination();
        if (pagination.totalPages() > 1) {
            class_7919 navigateTooltip = class_7919.method_47407((class_2561)class_2561.method_43470((String)Integer.toString(pagination.currentPage())).method_10852((class_2561)class_2561.method_43470((String)" / ").method_27695(new class_124[]{class_124.field_1067, class_124.field_1080})).method_27693(Integer.toString(pagination.totalPages())));
            MiniButton navPrevious = (MiniButton)this.method_37063((class_364)new MiniButton(titleLayout.method_46426() - 12 - 5 - 2, this.field_2800 + 3, 12, 12, ICON_PREVIOUS, onPress -> pagination.previousPage()));
            navPrevious.method_47400(navigateTooltip);
            navPrevious.field_22763 = pagination.currentPage() > 1;
            MiniButton navNext = (MiniButton)this.method_37063((class_364)new MiniButton(titleLayout.method_46426() + titleLayout.method_25368() + 5 + 2, this.field_2800 + 3, 12, 12, ICON_NEXT, onPress -> pagination.nextPage()));
            navNext.method_47400(navigateTooltip);
            boolean bl = navNext.field_22763 = pagination.currentPage() < pagination.totalPages();
        }
        if (this.owner) {
            class_8667 augmentsLayout = this.createAugmentsPanel();
            augmentsLayout.method_48222();
            augmentsLayout.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            int augmentsX = this.field_2776 - augmentsLayout.method_25368() - 2;
            if (backpackHeight < 5 + augmentsLayout.method_25364() + 5) {
                augmentsX = this.field_2776 - augmentsLayout.method_25368() - 8;
            }
            augmentsLayout.method_46421(augmentsX);
            augmentsLayout.method_46419(this.field_2800 + 16 + (backpackHeight - augmentsLayout.method_25364()) / 2);
            this.layouts.add((class_8133)augmentsLayout);
        }
        this.updateUnlockableSlots();
    }

    private class_8667 createAugmentsPanel() {
        class_8667 layout = class_8667.method_52741().method_52735(2);
        UnlockableController bays = ((BackpackContainerMenu)this.field_2797).getAugmentBayController();
        Augments.Position[] positions = Augments.Position.values();
        for (int i = 0; i < bays.getMaxSlots() && i < positions.length; ++i) {
            if (i != 0) {
                layout.method_52736((class_8021)Divider.horizontal(30).colour(-2044489));
            }
            layout.method_52736((class_8021)this.createAugmentLayout(positions[i]));
        }
        return layout;
    }

    private class_8667 createAugmentLayout(Augments.Position position) {
        class_8667 layout = class_8667.method_52742().method_52735(1);
        FrameworkButton augmentBtn = (FrameworkButton)layout.method_52738((class_8021)FrameworkButton.builder().setSize(20, 20).setTexture(() -> {
            if (!((BackpackContainerMenu)this.field_2797).getAugmentBayController().isSlotUnlocked(position.ordinal())) {
                return DISABLED_BUTTON_TEXTURES;
            }
            return BUTTON_TEXTURES;
        }).setIcon(btn -> new AugmentIcon((FrameworkButton)btn, (BackpackContainerMenu)this.field_2797, position)).setDependent(() -> {
            if (!((BackpackContainerMenu)this.field_2797).getAugmentBayController().isSlotUnlocked(position.ordinal())) {
                return ((BackpackContainerMenu)this.field_2797).getAugmentBayController().canAffordNextSlot((class_1657)this.field_22787.field_1724, 1);
            }
            return true;
        }).setAction(btn -> {
            if (!((BackpackContainerMenu)this.field_2797).getAugmentBayController().isSlotUnlocked(position.ordinal())) {
                Network.getPlay().sendToServer((Object)new MessageUnlockAugmentBay(position));
                return;
            }
            new AugmentPopupMenu(this, ((BackpackContainerMenu)this.field_2797)::getAugments, augment -> Network.getPlay().sendToServer((Object)new MessageChangeAugment(position, (Augment<?>)augment)), class_310.method_1551().method_74187() && class_310.method_1551().method_74188() && class_310.method_1551().method_74189()).show((class_339)btn);
        }).setTooltip(btn -> {
            if (!((BackpackContainerMenu)this.field_2797).getAugmentBayController().isSlotUnlocked(position.ordinal())) {
                return null;
            }
            AugmentType<?> type = ((BackpackContainerMenu)this.field_2797).getAugments().getAugment(position).type();
            ArrayList<class_2561> lines = new ArrayList<class_2561>();
            lines.add(SWAP_AUGMENT);
            lines.add((class_2561)type.name().method_27662().method_27692(class_124.field_1078));
            AugmentType<?> depends = type.requires().get();
            if (depends != null) {
                lines.add((class_2561)class_2561.method_43469((String)"backpacked.gui.requires_augment", (Object[])new Object[]{depends.name()}).method_27692(class_124.field_1076));
            }
            if (!type.isEmpty()) {
                Object rawDescription = type.description().getString();
                int firstBreak = ((String)rawDescription).indexOf("\n");
                rawDescription = !class_310.method_1551().method_74187() && firstBreak != -1 ? "\u2022 " + ((String)rawDescription).substring(0, firstBreak) : "\u2022 " + ((String)rawDescription).replace("\n", "\n\u2022 ");
                lines.add((class_2561)class_2561.method_43470((String)rawDescription).method_27692(class_124.field_1080));
                if (!class_310.method_1551().method_74187() && firstBreak != -1) {
                    lines.add((class_2561)HOLD_TO_EXPAND.apply(ScreenUtil.getShiftIcon()).method_27692(class_124.field_1063));
                }
            }
            if (class_310.method_1551().field_1690.field_1827) {
                lines.add((class_2561)class_2561.method_43470((String)type.id().toString()).method_27692(class_124.field_1063));
            }
            return ScreenUtil.createMultilineTooltip(lines);
        }).setTooltipOptions(2).build(), class_7847::method_46467);
        this.augmentsButtons.put(position, augmentBtn);
        class_7845 options = new class_7845().method_48637(0);
        options.method_46452((class_8021)BackpackButtons.state(() -> ((BackpackContainerMenu)this.field_2797).getAugments().getState(position), newValue -> this.updateAugments(((BackpackContainerMenu)this.field_2797).getAugments().setState(position, (boolean)newValue)), newValue -> Network.getPlay().sendToServer((Object)new MessageSetAugmentState(position, (boolean)newValue))).setIcon(btn -> () -> {
            boolean state = ((BackpackContainerMenu)this.field_2797).getAugments().getState(position);
            return AUGMENT_TOGGLE_SPRITES.method_52729(state, btn.method_49606() && btn.method_37303());
        }, 10, 10).setDependent(() -> ((BackpackContainerMenu)this.field_2797).getAugmentBayController().isSlotUnlocked(position.ordinal())).noTexture().setSize(10, 10).build(), 0, 0);
        options.method_46452((class_8021)FrameworkButton.builder().setSize(10, 10).setTexture(AUGMENT_SETTINGS_SPRITES).setTooltip(btn -> class_7919.method_47407((class_2561)CONFIGURE)).setTooltipDelay(0).setTooltipOptions(1).setAction(btn -> {
            Augment<?> augment = ((BackpackContainerMenu)this.field_2797).getAugments().getAugment(position);
            AugmentMenuFactory<Augment<?>> factory = AugmentSettingsFactories.getFactory(augment);
            if (factory == null) {
                return;
            }
            AugmentHolder<Augment> holder = new AugmentHolder<Augment>(() -> ((BackpackContainerMenu)this.field_2797).getAugments().getAugment(position), updatedAugment -> {
                Network.getPlay().sendToServer((Object)new MessageUpdateAugment(position, (Augment<?>)updatedAugment));
                this.updateAugments(((BackpackContainerMenu)this.field_2797).getAugments().setAugment(position, (Augment<?>)updatedAugment));
            }, position, ((BackpackContainerMenu)this.field_2797).getBackpackIndex());
            factory.apply(this, holder).show((class_339)btn);
        }).setDependent(() -> {
            if (!((BackpackContainerMenu)this.field_2797).getAugmentBayController().isSlotUnlocked(position.ordinal())) {
                return false;
            }
            AugmentType<?> type = ((BackpackContainerMenu)this.field_2797).getAugments().getAugment(position).type();
            return AugmentSettingsFactories.hasFactory(type);
        }).build(), 1, 0);
        layout.method_52738((class_8021)options, class_7847::method_46467);
        return layout;
    }

    private void updateAugments(Augments augments) {
        ((BackpackContainerMenu)this.field_2797).setAugments(augments);
    }

    public void updateAugment(Augments.Position position, Augment<?> augment) {
        ((BackpackContainerMenu)this.field_2797).setAugments(((BackpackContainerMenu)this.field_2797).getAugments().setAugment(position, augment));
        FrameworkButton augmentBtn = this.augmentsButtons.get((Object)position);
        if (augmentBtn != null) {
            augmentBtn.rebuildTooltip();
        }
    }

    private class_8133 createTitleLayout() {
        class_8667 layout = class_8667.method_52742().method_52735(2);
        TitleWidget title = new TitleWidget(this.getTrimmedTitle(), this.field_22785, class_310.method_1551().field_1772);
        title.method_25358(110);
        layout.method_52736((class_8021)title);
        if (this.owner) {
            title.setShift(6);
            ((MiniButton)layout.method_52736((class_8021)new MiniButton(0, 0, ICON_RENAME, onPress -> new TextInputMenu(this, this.field_22785.getString(), 50, s -> Network.PLAY.sendToServer((Object)new MessageRenameBackpack((String)s))).show(this.method_48202())))).method_47400(class_7919.method_47407((class_2561)RENAME));
        }
        return layout;
    }

    private class_8667 createActionsLayout() {
        class_8667 layout = class_8667.method_52741().method_52735(2);
        layout.method_52736((class_8021)FrameworkButton.builder().setSize(10, 10).setIcon(ICON_SORT, 10, 10).setTooltipDelay(0).setTooltip(btn -> ScreenUtil.createMultilineTooltip(List.of(SORT, sorting.label().method_27662().method_27692(class_124.field_1078), class_2561.method_43469((String)"backpacked.gui.cycle_sort_mode", (Object[])new Object[]{ScreenUtil.getIconComponent(Icons.MIDDLE_MOUSE)}).method_27692(class_124.field_1063)))).setPrimaryAction(btn -> Network.getPlay().sendToServer((Object)new MessageSortBackpack(sorting))).setTertiaryAction(Action.create(btn -> {
            ItemSorting[] values = ItemSorting.values();
            sorting = values[(sorting.ordinal() + 1) % values.length];
        }, (Sound)Sound.create((class_3414)class_3417.field_14699))).setContentRenderer((btn, graphics, mouseX, mouseY, partialTick) -> {
            Icon icon = btn.getIcon();
            if (icon != null) {
                int alpha = class_9848.method_61317((float)(btn.method_37303() ? 1.0f : 0.5f));
                icon.draw(graphics, btn.method_46426(), btn.method_46427(), alpha, partialTick);
            }
            if (btn.method_49606() && btn.method_37303()) {
                graphics.method_25296(btn.method_46426(), btn.method_46427(), btn.method_46426() + btn.method_25368(), btn.method_46427() + btn.method_25364(), -2130706433, -2130706433);
            }
        }).build());
        if (this.owner && !((Boolean)Config.BACKPACK.cosmetics.disableCustomisation.get()).booleanValue()) {
            MiniButton customiseButton = (MiniButton)layout.method_52736((class_8021)new MiniButton(0, 0, ICON_CUSTOMISE, onPress -> {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    int backpackIndex = (Integer)ModSyncedDataKeys.SELECTED_BACKPACK.getValue((class_1297)player);
                    Network.getPlay().sendToServer((Object)new MessageRequestCustomisation(backpackIndex));
                }
            }));
            customiseButton.method_47400(class_7919.method_47407((class_2561)CUSTOMISE_TOOLTIP));
        }
        if (!((Boolean)Config.BACKPACK.inventory.slots.unlockAllSlots.get()).booleanValue()) {
            EnumButton lockButton = (EnumButton)layout.method_52736(new EnumButton<UnlockableSlotMode>(0, 0, 10, 10, (UnlockableSlotMode)Config.CLIENT.unlockableSlotMode.get(), (btn, value) -> {
                if (Config.CLIENT.unlockableSlotMode.get() != value) {
                    Config.CLIENT.unlockableSlotMode.set(value);
                    btn.method_47400(this.createLockTooltip((UnlockableSlotMode)value));
                }
                this.updateUnlockableSlots();
            }));
            lockButton.method_47400(this.createLockTooltip((UnlockableSlotMode)Config.CLIENT.unlockableSlotMode.get()));
        }
        if (this.owner || !((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            layout.method_52736((class_8021)Divider.horizontal(10).colour(-2044489));
        }
        if (this.owner) {
            MiniButton manageButton = (MiniButton)layout.method_52736((class_8021)new MiniButton(0, 0, ICON_MANAGEMENT, button -> Network.getPlay().sendToServer((Object)new MessageRequestManagement())));
            manageButton.method_47400(class_7919.method_47407((class_2561)MANAGEMENT_TOOLTIP));
        }
        if (!((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            MiniButton configButton = (MiniButton)layout.method_52736((class_8021)new MiniButton(0, 0, ICON_CONFIG, onPress -> this.openConfigScreen()));
            configButton.method_47400(class_7919.method_47407((class_2561)CONFIG_TOOLTIP));
        }
        return layout;
    }

    private class_7919 createLockTooltip(UnlockableSlotMode mode) {
        class_5250 tooltip = class_2561.method_43470((String)"");
        tooltip.method_10852((class_2561)class_2561.method_43471((String)"backpacked.button.unlockable_slot_mode.tooltip").method_27692(class_124.field_1073));
        tooltip.method_27693("\n");
        tooltip = tooltip.method_10852((class_2561)class_2561.method_43471((String)mode.getKey()).method_27692(mode.getFormat()));
        return class_7919.method_47407((class_2561)tooltip);
    }

    private void updateUnlockableSlots() {
        if (((Boolean)Config.BACKPACK.inventory.slots.unlockAllSlots.get()).booleanValue()) {
            this.setHideLockedSlots(false);
            return;
        }
        switch ((UnlockableSlotMode)Config.CLIENT.unlockableSlotMode.get()) {
            case ENABLED: {
                this.setHideLockedSlots(false);
                break;
            }
            case DISABLED: {
                this.setHideLockedSlots(true);
                break;
            }
            case PURCHASABLE: {
                this.setHideLockedSlots(!((BackpackContainerMenu)this.method_17577()).getSlotController().canAffordNextSlot(this.player, Math.max(1, this.selectedSlots.size() + 1)));
            }
        }
    }

    @Override
    protected void addSlotToSelected(UnlockableSlot slot) {
        super.addSlotToSelected(slot);
        this.updateUnlockableSlots();
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        if (Config.CLIENT.unlockableSlotMode.get() == UnlockableSlotMode.PURCHASABLE && this.timer-- <= 0) {
            this.updateUnlockableSlots();
            this.timer = 5;
        }
    }

    @Override
    protected void method_2380(class_332 graphics, int mouseX, int mouseY) {
        for (Map.Entry<Augments.Position, FrameworkButton> entry : this.augmentsButtons.entrySet()) {
            if (((BackpackContainerMenu)this.field_2797).getAugmentBayController().isSlotUnlocked(entry.getKey().ordinal()) || !entry.getValue().method_49606()) continue;
            List<class_5684> components = this.createUnlockAugmentBayTooltip();
            ClientServices.CLIENT.drawTooltip(graphics, this.field_22793, components, mouseX, mouseY, class_8001.field_41687);
            return;
        }
        super.method_2380(graphics, mouseX, mouseY);
    }

    protected List<class_5684> createUnlockAugmentBayTooltip() {
        class_2561 hintText = CLICK_TO_UNLOCK;
        UnlockableController bayController = ((BackpackContainerMenu)this.field_2797).getAugmentBayController();
        int nextCost = bayController.getNextUnlockCost(1);
        boolean canAfford = bayController.canAffordNextSlot(this.player, 1);
        ArrayList<class_5684> components = new ArrayList<class_5684>();
        components.add((class_5684)new class_5683(AUGMENT_BAY.method_27661().method_27692(class_124.field_1080).method_30937()));
        switch (bayController.getCostModel().getPaymentType()) {
            case EXPERIENCE: {
                if (!canAfford) {
                    hintText = NOT_ENOUGH_EXP.method_27661().method_27692(class_124.field_1061);
                }
                components.add((class_5684)new class_5683(hintText.method_30937()));
                components.add(new ExperienceCostTooltip(nextCost));
                break;
            }
            case ITEM: {
                if (!canAfford) {
                    hintText = MISSING_ITEMS.method_27661().method_27692(class_124.field_1061);
                }
                components.add((class_5684)new class_5683(hintText.method_30937()));
                components.add(new ItemCostTooltip(bayController.getPaymentItem(), nextCost));
            }
        }
        return components;
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, -12566464, false);
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        this.drawBackgroundWindow(graphics, this.field_2776, this.field_2800, this.field_2792, this.field_2779, mouseX, mouseY);
    }

    private class_5481 getTrimmedTitle() {
        int maxWidth = 100;
        if (this.field_22793.method_27525((class_5348)this.field_22785) > maxWidth) {
            return class_2477.method_10517().method_30934(class_5348.method_29433((class_5348[])new class_5348[]{this.field_22793.method_1714((class_5348)this.field_22785, maxWidth - this.field_22793.method_1727("...")), class_5348.method_29430((String)"...")}));
        }
        return this.field_22785.method_30937();
    }

    private void drawBackgroundWindow(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        this.layouts.forEach(layout -> graphics.method_52706(class_10799.field_56883, LABEL_BACKGROUND, layout.method_46426() - 5, layout.method_46427() - 5, 5 + layout.method_25368() + 5, 5 + layout.method_25364() + 5));
        int backpackHeight = 11 + this.rows * 18 + 14;
        graphics.method_52706(class_10799.field_56883, BACKPACK_BACKGROUND, x, y + 16, width, backpackHeight);
        int backpackSlotsWidth = this.cols * 18;
        int backpackSlotsHeight = this.rows * 18;
        int backpackSlotsX = (width - backpackSlotsWidth) / 2;
        int backpackSlotsY = 27;
        graphics.method_52706(class_10799.field_56883, BACKPACK_SLOT, x + backpackSlotsX, y + backpackSlotsY, backpackSlotsWidth, backpackSlotsHeight);
        int backpackCheckersWidth = (width - 11 - 11 - backpackSlotsWidth) / 2 - 3;
        if (backpackCheckersWidth > 0) {
            graphics.method_52706(class_10799.field_56883, CHECKERS, x + 11, y + 27, backpackCheckersWidth, backpackSlotsHeight);
            graphics.method_52706(class_10799.field_56883, CHECKERS, x + backpackSlotsX + backpackSlotsWidth + 3, y + 27, backpackCheckersWidth, backpackSlotsHeight);
        }
        int inventoryX = (width - 176) / 2;
        int inventoryY = 16 + backpackHeight + 3;
        graphics.method_52706(class_10799.field_56883, INVENTORY_SPRITE, x + inventoryX, y + inventoryY, 176, 101);
        int inventorySlotsWidth = 162;
        int inventorySlotsHeight = 54;
        int inventorySlotsX = (width - inventorySlotsWidth) / 2;
        int inventorySlotsY = inventoryY + 18;
        graphics.method_52706(class_10799.field_56883, INVENTORY_SLOT, x + inventorySlotsX, y + inventorySlotsY, inventorySlotsWidth, inventorySlotsHeight);
        graphics.method_52706(class_10799.field_56883, INVENTORY_SLOT, x + inventorySlotsX, y + inventorySlotsY + inventorySlotsHeight + 4, 162, 18);
    }

    private void openConfigScreen() {
        ClientServices.CLIENT.openConfigScreen();
    }

    @Override
    public boolean method_25404(class_11908 event) {
        if (!this.hasPopupMenu() && ModKeyMappings.KEY_BACKPACK.method_1417(event)) {
            this.method_25419();
            return true;
        }
        if (!this.hasPopupMenu() && this.owner && ModKeyMappings.KEY_MANAGEMENT.method_1417(event)) {
            Network.getPlay().sendToServer((Object)new MessageRequestManagement());
            return true;
        }
        return super.method_25404(event);
    }

    public void method_25432() {
        super.method_25432();
        MouseRestorer.capturePosition();
    }

    public void onAugmentBayUnlocked(Augments.Position position) {
        FrameworkButton button = this.augmentsButtons.get((Object)position);
        if (button != null) {
            this.spawnSlotUnlockedParticles(button.method_46426(), button.method_46427());
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14709, (float)1.3f, (float)0.25f));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_24065, (float)1.3f, (float)0.7f));
        }
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top) {
        for (class_8133 layout : this.layouts) {
            if (!ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, layout.method_46426() - 5, layout.method_46427() - 5, 5 + layout.method_25368() + 5, 5 + layout.method_25364() + 5)) continue;
            return false;
        }
        int backpackX = this.field_2776;
        int backpackY = this.field_2800 + 16;
        int backpackWidth = this.field_2792;
        int backpackHeight = 11 + this.rows * 18 + 14;
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, backpackX, backpackY, backpackWidth, backpackHeight)) {
            return false;
        }
        int inventoryX = this.field_2776 + (this.field_2792 - 176) / 2;
        int inventoryY = this.field_2800 + 16 + backpackHeight + 3;
        return !ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, inventoryX, inventoryY, 176, 101);
    }

    public List<class_8133> getLayouts() {
        return this.layouts;
    }

    private static class AugmentIcon
    extends Icon {
        private final FrameworkButton button;
        private final BackpackContainerMenu menu;
        private final Augments.Position position;

        private AugmentIcon(FrameworkButton button, BackpackContainerMenu menu, Augments.Position position) {
            this.button = button;
            this.menu = menu;
            this.position = position;
        }

        public int width() {
            return 12;
        }

        public int height() {
            return 12;
        }

        public void draw(class_332 graphics, int x, int y, int alpha, float partialTick) {
            if (!this.menu.getAugmentBayController().isSlotUnlocked(this.position.ordinal())) {
                if (this.button.method_37303() && this.button.method_49606()) {
                    graphics.method_52707(class_10799.field_56883, ICON_LOCK, x, y, 12, 12, alpha);
                } else {
                    graphics.method_52707(class_10799.field_56883, ICON_LOCK, x, y, 12, 12, alpha);
                }
            } else {
                class_2960 sprite = this.menu.getAugments().getAugment(this.position).type().sprite();
                graphics.method_52707(class_10799.field_56883, sprite, x, y, 12, 12, alpha);
            }
        }
    }
}

