/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.backpack.ModelMeta;
import com.mrcrayfish.backpacked.client.gui.MouseRestorer;
import com.mrcrayfish.backpacked.client.gui.pip.GuiBackpackRenderState;
import com.mrcrayfish.backpacked.client.gui.screen.widget.BackpackButtons;
import com.mrcrayfish.backpacked.client.gui.screen.widget.PlayerDisplay;
import com.mrcrayfish.backpacked.client.gui.screen.widget.ScrollBar;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.Alignment;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.CustomScreen;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.DropdownMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.item.CheckboxItem;
import com.mrcrayfish.backpacked.client.renderer.backpack.LevelDataState;
import com.mrcrayfish.backpacked.client.renderer.backpack.LivingEntityDataState;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import com.mrcrayfish.framework.api.client.screen.widget.FrameworkButton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class CustomiseBackpackScreen
extends CustomScreen {
    private static final class_2960 BACKPACK_BACKGROUND = Utils.id("backpack/background");
    private static final class_2960 LABEL_BACKGROUND = Utils.id("backpack/label");
    private static final class_2960 CHECKERS = Utils.id("backpack/checkers");
    private static final class_2960 LABEL_WARNING_BACKGROUND = Utils.id("backpack/label_warning");
    private static final class_2960 ROUNDED_BOX = Utils.id("backpack/rounded_box");
    private static final class_2960 LIST_ITEM = Utils.id("backpack/list_item");
    private static final class_2960 LIST_ITEM_FOCUSED = Utils.id("backpack/list_item_focused");
    private static final class_2960 LIST_ITEM_SELECTED = Utils.id("backpack/list_item_selected");
    private static final class_2960 LIST_ITEM_LOCKED = Utils.id("backpack/list_item_locked");
    private static final class_2960 ICON_LOCK = Utils.id("backpack/lock");
    private static final class_2960 UNLOCK_PROGRESS_BAR = Utils.id("backpack/unlock_progress_bar");
    private static final class_2960 UNLOCK_PROGRESS_BAR_INNER = Utils.id("backpack/unlock_progress_bar_inner");
    private static final class_2960 SETTINGS = Utils.id("backpack/settings");
    private static final class_2960 ARROW_LEFT = Utils.id("backpack/arrow_left");
    private static final class_2561 SAVE = class_2561.method_43471((String)"backpacked.button.save");
    private static final class_2561 SHOW_PARTICLES = class_2561.method_43471((String)"backpacked.button.show_particles");
    private static final class_2561 HIDE_WITH_ELYTRA = class_2561.method_43471((String)"backpacked.button.hide_with_elytra");
    private static final class_2561 LOCKED = class_2561.method_43471((String)"backpacked.gui.locked").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    private static final class_2561 COSMETIC_WARNING = class_2561.method_43471((String)"backpacked.gui.cosmetic_warning");
    private static final class_2561 BACK_TO_INVENTORY = class_2561.method_43471((String)"backpacked.gui.back_to_inventory");
    private static final class_2561 UNSAVED_CHANGES = class_2561.method_43471((String)"backpacked.gui.unsaved_changes").method_27692(class_124.field_1061);
    private static final int PLAYER_DISPLAY_WIDTH = 80;
    private static final int MAX_VISIBLE_ITEMS = 5;
    private static final int ITEM_WIDTH = 133;
    private static final int ITEM_HEIGHT = 24;
    private static final int ITEM_LIST_GAP = 2;
    private static final int ITEM_LIST_LEFT = 96;
    private static final int ITEM_LIST_TOP = 30;
    private static final int ITEM_LIST_WIDTH = 133;
    private static final int ITEM_LIST_HEIGHT = 129;
    private static final int DEFAULT_ITEM_TEXT_COLOUR = -10727099;
    private static final int SELECTED_ITEM_TEXT_COLOUR = -1;
    private static final int UNLOCKED_ITEM_TEXT_COLOUR = -9937334;
    private static final int MODEL_LIGHTING = 0xF000F0;
    private final int backpackIndex;
    private final int windowWidth;
    private final int windowHeight;
    private final boolean showCosmeticWarning;
    private int windowLeft;
    private int windowTop;
    private FrameworkButton saveButton;
    private FrameworkButton settingsButton;
    private FrameworkButton backButton;
    private CosmeticProperties currentProperties;
    private CosmeticProperties displayBackpack = null;
    private final List<CosmeticItem> items;
    private PlayerDisplay playerDisplay;
    private final MutableInt scroll = new MutableInt();
    private ScrollBar scrollBar;
    private int tickCount;

    public CustomiseBackpackScreen(int backpackIndex, Map<class_2960, class_2561> progressMap, CosmeticProperties properties, boolean showCosmeticWarning, Map<class_2960, Double> completionMap) {
        super((class_2561)class_2561.method_43471((String)"backpacked.title.customise_backpack"));
        this.backpackIndex = backpackIndex;
        this.windowWidth = 260;
        this.windowHeight = 174;
        Comparator<BackpackModelItem> compareUnlock = Comparator.comparing(e -> !e.backpack.isUnlocked((class_1657)class_310.method_1551().field_1724));
        Comparator<BackpackModelItem> compareLabel = Comparator.comparing(e -> e.label.getString());
        List items = ClientRegistry.instance().getBackpacks().stream().filter(backpack -> !BackpackHelper.isCosmeticDisabled(backpack.getId())).map(backpack -> new BackpackModelItem((ClientBackpack)backpack, progressMap, completionMap)).sorted(compareUnlock.thenComparing(compareLabel)).collect(Collectors.toCollection(ArrayList::new));
        if (!((Boolean)Config.CLIENT.hideAddonsCallToAction.get()).booleanValue()) {
            items.add(new GuideItem());
        }
        this.items = ImmutableList.copyOf((Collection)items);
        this.showCosmeticWarning = showCosmeticWarning;
        this.currentProperties = properties;
    }

    protected void method_25426() {
        MouseRestorer.loadCapturedPosition();
        super.method_25426();
        if (this.displayBackpack == null) {
            this.displayBackpack = this.currentProperties;
        }
        this.windowLeft = (this.field_22789 - this.windowWidth) / 2;
        this.windowTop = (this.field_22790 - this.windowHeight) / 2;
        int contentHeight = this.windowHeight - 27 - 13;
        this.playerDisplay = (PlayerDisplay)this.method_37063((class_364)new PlayerDisplay((class_1657)this.field_22787.field_1724, this.windowLeft + 10, this.windowTop + 27, 80, contentHeight - 1 - 20, () -> this.displayBackpack));
        this.saveButton = (FrameworkButton)this.method_37063((class_364)BackpackButtons.builder().setPosition(this.windowLeft + 10, this.playerDisplay.method_55443() + 1).setSize(60, 20).setLabel(SAVE).setAction(btn -> {
            Network.getPlay().sendToServer((Object)new MessageBackpackCosmetics(this.backpackIndex, this.displayBackpack));
            this.currentProperties = this.displayBackpack;
        }).build());
        DropdownMenu settingMenu = DropdownMenu.builder(this).setMinItemSize(70, 16).addItem(CheckboxItem.create(HIDE_WITH_ELYTRA, new MutableBoolean(!this.displayBackpack.showWithElytra()), value -> {
            this.displayBackpack = this.displayBackpack.setShowWithElytra(value == false);
            return false;
        })).addItem(CheckboxItem.create(SHOW_PARTICLES, new MutableBoolean(this.displayBackpack.showEffects()), value -> {
            this.displayBackpack = this.displayBackpack.setShowEffects((boolean)value);
            return false;
        })).setAlignment(Alignment.ABOVE_LEFT).build();
        this.settingsButton = (FrameworkButton)this.method_37063((class_364)BackpackButtons.builder().setPosition(this.saveButton.method_46426() + this.saveButton.method_25368(), this.saveButton.method_46427()).setSize(20, 20).setIcon(SETTINGS, 10, 10).setAction(settingMenu::show).build());
        this.scrollBar = (ScrollBar)this.method_37063((class_364)new ScrollBar(this.windowLeft + this.windowWidth - 24, this.windowTop + 29, contentHeight - 4, this.scroll));
        this.scrollBar.field_22763 = this.items.size() > 5;
        this.backButton = (FrameworkButton)this.method_37063((class_364)BackpackButtons.builder().setPosition(this.windowLeft - 20, this.windowTop + (this.windowHeight - 17 - 20) / 2 + 17).setSize(16, 16).setIcon(ARROW_LEFT, 4, 6).setAction(btn -> Network.getPlay().sendToServer((Object)new MessageOpenBackpack())).build());
        this.updateButtons();
    }

    private void updateButtons() {
        this.saveButton.field_22763 = this.needsToSave();
    }

    private boolean needsToSave() {
        return !this.displayBackpack.equals(this.currentProperties);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        this.updateButtons();
        ++this.tickCount;
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_52752(graphics);
        this.drawBackgroundWindow(graphics, this.windowLeft, this.windowTop, this.windowWidth, this.windowHeight);
        this.renderWarning(graphics);
        int scrollBarBgX = this.scrollBar.method_46426() - 2;
        int scrollBarBgY = this.scrollBar.method_46427() - 2;
        int scrollBarBgWidth = this.scrollBar.method_25368() + 4;
        int scrollBarBgHeight = this.scrollBar.method_25364() + 4;
        graphics.method_52706(class_10799.field_56883, ROUNDED_BOX, scrollBarBgX, scrollBarBgY, scrollBarBgWidth, scrollBarBgHeight);
        int itemBgX = this.playerDisplay.method_55442() + 3;
        int itemBgWidth = this.scrollBar.method_46426() - 2 - 2 - itemBgX;
        graphics.method_52706(class_10799.field_56883, ROUNDED_BOX, itemBgX, this.windowTop + 27, itemBgWidth, scrollBarBgHeight);
        if (this.backButton.method_49606()) {
            if (this.saveButton.field_22763) {
                graphics.method_71274(List.of(BACK_TO_INVENTORY.method_30937(), UNSAVED_CHANGES.method_30937()), mouseX, mouseY);
            } else {
                graphics.method_71274(List.of(BACK_TO_INVENTORY.method_30937()), mouseX, mouseY);
            }
        }
    }

    @Override
    public void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int itemY;
        int itemX;
        int startIndex;
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        graphics.method_51439(this.field_22793, this.field_22785, this.windowLeft + (this.windowWidth - titleWidth) / 2, this.windowTop + 6, -10399683, false);
        for (int i = startIndex = (int)((double)Math.max(0, this.items.size() - 5) * this.scrollBar.getScroll(mouseY)); i < this.items.size() && i < startIndex + 5; ++i) {
            itemX = this.windowLeft + 96;
            itemY = this.windowTop + 30 + (i - startIndex) * 26;
            graphics.method_44379(itemX, itemY, itemX + 133, itemY + 24);
            this.items.get(i).draw(graphics, itemX, itemY, mouseX, mouseY, partialTick, this.field_22787);
            graphics.method_44380();
        }
        if (this.hasPopupMenu()) {
            return;
        }
        int hoveredIndex = this.getHoveredIndex(mouseX, mouseY);
        if (hoveredIndex != -1) {
            itemX = this.windowLeft + 96;
            itemY = this.windowTop + 30 + (hoveredIndex - startIndex) * 26;
            CosmeticItem item = this.items.get(hoveredIndex);
            item.onMouseHover(graphics, this.field_22787, itemX, itemY, mouseX, mouseY);
        }
    }

    private void renderWarning(class_332 graphics) {
        if (!this.showCosmeticWarning) {
            return;
        }
        int messageWidth = this.field_22793.method_27525((class_5348)COSMETIC_WARNING);
        int messageBgWidth = 7 + messageWidth + 7;
        int messageY = 8;
        graphics.method_25296(0, 0, this.field_22789, 50, -1442840576, 0);
        graphics.method_52706(class_10799.field_56883, LABEL_WARNING_BACKGROUND, (this.field_22789 - messageBgWidth) / 2, messageY, messageBgWidth, 20);
        graphics.method_27535(this.field_22793, COSMETIC_WARNING, (this.field_22789 - messageWidth) / 2, messageY + 6, -1);
    }

    private void drawBackgroundWindow(class_332 graphics, int x, int y, int width, int height) {
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        int labelWidth = 20 + titleWidth + 20;
        int labelX = x + (this.windowWidth - labelWidth) / 2;
        graphics.method_52706(class_10799.field_56883, LABEL_BACKGROUND, labelX, y, labelWidth, 21);
        int titleX = x + (this.windowWidth - titleWidth) / 2;
        int checkersX = labelX + 5;
        int checkersWidth = titleX - checkersX - 2;
        if (checkersWidth > 0) {
            graphics.method_52706(class_10799.field_56883, CHECKERS, checkersX, y + 7, checkersWidth, 5);
            graphics.method_52706(class_10799.field_56883, CHECKERS, titleX + titleWidth + 1, y + 7, checkersWidth, 5);
        }
        int backPanelX = this.backButton.method_46426() - 6;
        int backPanelY = this.backButton.method_46427() - 5;
        graphics.method_52706(class_10799.field_56883, LABEL_BACKGROUND, backPanelX, backPanelY, 50, 26);
        graphics.method_52706(class_10799.field_56883, BACKPACK_BACKGROUND, x, y + 17, width, height - 17);
    }

    public static void drawBackpackInGui(class_310 mc, class_332 graphics, ClientBackpack backpack, int windowX, int windowY, int windowWidth, int windowHeight, float partialTick, int tickCount) {
        assert (mc.field_1724 != null && mc.field_1687 != null);
        ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
        GuiBackpackRenderState state = new GuiBackpackRenderState(meta.display().comp_3373(), meta.renderer().orElse(null), LivingEntityDataState.create((class_1309)mc.field_1724, partialTick), LevelDataState.create((class_1937)mc.field_1687, partialTick), backpack.getBaseModel(), backpack.getStrapsModel(), mc.field_1724.method_5628(), tickCount, partialTick, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), windowX, windowX + windowWidth, windowY, windowY + windowHeight, 16.0f, null);
        ClientServices.CLIENT.submitGuiPipRenderState(graphics, state);
    }

    private int getHoveredIndex(int mouseX, int mouseY) {
        int offsetIndex;
        int startIndex;
        int hoveredIndex;
        if (ScreenUtil.isPointInArea(mouseX, mouseY, this.windowLeft + 96, this.windowTop + 30, 133, 129) && (hoveredIndex = (startIndex = (int)((double)Math.max(0, this.items.size() - 5) * this.scrollBar.getScroll(mouseY))) + (offsetIndex = (mouseY - this.windowTop - 30) / 26)) >= 0 && hoveredIndex < this.items.size()) {
            return hoveredIndex;
        }
        return -1;
    }

    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        CosmeticItem item;
        int hoveredIndex;
        if (!this.hasPopupMenu() && ScreenUtil.isPointInArea((int)event.comp_4798(), (int)event.comp_4799(), this.windowLeft + 96, this.windowTop + 30, 133, 129) && event.method_74245() == 0 && (hoveredIndex = this.getHoveredIndex((int)event.comp_4798(), (int)event.comp_4799())) != -1 && (item = this.items.get(hoveredIndex)).onMouseClicked(event, this.field_22787)) {
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.hasPopupMenu() && !this.scrollBar.isGrabbed() && ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 96, this.windowTop + 30, 133, 129)) {
            int scrollableContentHeight = Math.max(this.items.size() * 26 - 129, 0);
            double scrollNormal = this.scrollBar.getScroll((int)mouseY);
            int currentIndex = (int)((double)scrollableContentHeight * scrollNormal) / 26;
            int nextIndex = currentIndex + class_3532.method_17822((double)(-deltaY));
            double amount = (double)nextIndex / (double)Math.max(this.items.size() - 5, 1);
            this.scrollBar.scrollTo(amount);
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public void method_25432() {
        super.method_25432();
        MouseRestorer.capturePosition();
    }

    private class GuideItem
    extends CosmeticItem {
        private static final class_2561 MESSAGE = class_2561.method_43471((String)"backpacked.gui.want_more_backpacks");
        private static final class_2561 VIEW_ADDONS = class_2561.method_43471((String)"backpacked.gui.view_addons");
        private final FrameworkButton button = BackpackButtons.builder().setSize(100, 14).setLabel(VIEW_ADDONS).setAction(btn -> {
            class_2558.class_10608 event = new class_2558.class_10608(URI.create("https://mrcrayfish.github.io/Backpacked/"));
            CustomiseBackpackScreen.method_71847((class_2558)((class_2558)event), (class_310)CustomiseBackpackScreen.this.field_22787, (class_437)CustomiseBackpackScreen.this);
        }).build();

        private GuideItem() {
        }

        @Override
        protected void draw(class_332 graphics, int x, int y, int mouseX, int mouseY, float partialTick, class_310 mc) {
            int width = mc.field_1772.method_27525((class_5348)MESSAGE);
            graphics.method_51439(mc.field_1772, MESSAGE, x + (133 - width) / 2, y + 1, -9937334, false);
            this.button.method_46421(x + (133 - this.button.method_25368()) / 2);
            this.button.method_46419(y + 24 - this.button.method_25364());
            this.button.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        protected boolean onMouseClicked(class_11909 event, class_310 mc) {
            if (this.button.method_49606()) {
                this.button.method_25306((class_11907)event);
            }
            return false;
        }
    }

    private static abstract class CosmeticItem {
        private CosmeticItem() {
        }

        protected abstract void draw(class_332 var1, int var2, int var3, int var4, int var5, float var6, class_310 var7);

        protected boolean onMouseClicked(class_11909 event, class_310 mc) {
            return false;
        }

        protected void onMouseHover(class_332 graphics, class_310 mc, int x, int y, int mouseX, int mouseY) {
        }
    }

    private class BackpackModelItem
    extends CosmeticItem {
        private final class_2960 cosmeticId;
        private final ClientBackpack backpack;
        private final class_2561 label;
        private final List<class_5481> unlockTooltip;
        private final double completionProgress;

        public BackpackModelItem(ClientBackpack backpack, Map<class_2960, class_2561> labelMap, Map<class_2960, Double> completionMap) {
            this.cosmeticId = backpack.getId();
            this.backpack = backpack;
            this.label = class_2561.method_43471((String)backpack.getTranslationKey());
            class_5250 unlockMessage = class_2561.method_43471((String)(backpack.getTranslationKey() + ".unlock"));
            ArrayList<class_5481> list = new ArrayList<class_5481>(class_310.method_1551().field_1772.method_1728((class_5348)unlockMessage, 150));
            list.addFirst(class_2477.method_10517().method_30934((class_5348)LOCKED));
            if (labelMap.containsKey(backpack.getId())) {
                class_5250 component = labelMap.get(backpack.getId()).method_27662().method_27692(class_124.field_1054);
                list.add(class_2477.method_10517().method_30934((class_5348)component));
            }
            this.unlockTooltip = ImmutableList.copyOf(list);
            this.completionProgress = completionMap.getOrDefault(backpack.getId(), 1.0);
        }

        @Override
        protected void draw(class_332 graphics, int x, int y, int mouseX, int mouseY, float partialTick, class_310 mc) {
            boolean unlocked = this.backpack.isUnlocked((class_1657)mc.field_1724);
            boolean selected = unlocked && CustomiseBackpackScreen.this.displayBackpack.cosmetic().orElse(BackpackManager.getDefaultOrFallbackCosmetic()).equals((Object)this.cosmeticId);
            boolean hovered = unlocked && (selected || ScreenUtil.isPointInArea(mouseX, mouseY, x, y, 133, 24));
            class_2960 itemTexture = this.getItemTexture(unlocked, selected, hovered);
            graphics.method_52706(class_10799.field_56883, itemTexture, x, y, 133, 24);
            if (!unlocked) {
                int progressBarX = x + 24;
                int progressBarY = y + 24 - 5 - 4;
                graphics.method_52706(class_10799.field_56883, UNLOCK_PROGRESS_BAR, progressBarX, progressBarY, 89, 5);
                int progressWidth = (int)(87.0 * this.completionProgress);
                graphics.method_52706(class_10799.field_56883, UNLOCK_PROGRESS_BAR_INNER, progressBarX + 1, progressBarY + 1, progressWidth, 3);
                graphics.method_52706(class_10799.field_56883, ICON_LOCK, x + 133 - 12 - 4, y + 6, 12, 12);
            }
            int textColour = this.getItemTextColour(unlocked, selected);
            int textY = y + (unlocked ? 8 : 5);
            graphics.method_51439(mc.field_1772, this.label, x + 24, textY, textColour, selected);
            CustomiseBackpackScreen.drawBackpackInGui(mc, graphics, this.backpack, x, y, 24, 24, partialTick, CustomiseBackpackScreen.this.tickCount);
        }

        @Override
        protected void onMouseHover(class_332 graphics, class_310 mc, int x, int y, int mouseX, int mouseY) {
            if (class_310.method_1551().method_74188()) {
                graphics.method_51438(mc.field_1772, (class_2561)class_2561.method_43470((String)this.backpack.getId().toString()), mouseX, mouseY);
                return;
            }
            if (!this.backpack.isUnlocked((class_1657)mc.field_1724)) {
                int progressBarX = x + 24;
                int progressBarY = y + 24 - 5 - 4;
                int lockX = x + 133 - 12 - 4;
                int lockY = y + 6;
                if (ScreenUtil.isPointInArea(mouseX, mouseY, progressBarX, progressBarY, 89, 5) || ScreenUtil.isPointInArea(mouseX, mouseY, lockX, lockY, 12, 12)) {
                    graphics.method_51447(mc.field_1772, this.unlockTooltip, mouseX, mouseY);
                }
            }
        }

        @Override
        protected boolean onMouseClicked(class_11909 event, class_310 mc) {
            if (class_310.method_1551().method_74188()) {
                class_310.method_1551().field_1774.method_1455(this.backpack.getId().toString());
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)("Copied " + String.valueOf(this.backpack.getId()) + " to the clipboard")));
                return true;
            }
            if (event.method_74245() == 0 && this.backpack.isUnlocked((class_1657)mc.field_1724)) {
                if (!CustomiseBackpackScreen.this.displayBackpack.cosmetic().orElse(BackpackManager.getDefaultOrFallbackCosmetic()).equals((Object)this.cosmeticId)) {
                    CustomiseBackpackScreen.this.displayBackpack = CustomiseBackpackScreen.this.displayBackpack.setCosmetic(this.cosmeticId);
                    mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
                return true;
            }
            return false;
        }

        private class_2960 getItemTexture(boolean unlocked, boolean selected, boolean hovered) {
            if (selected) {
                return LIST_ITEM_SELECTED;
            }
            if (unlocked) {
                return hovered ? LIST_ITEM_FOCUSED : LIST_ITEM;
            }
            return LIST_ITEM_LOCKED;
        }

        private int getItemTextColour(boolean unlocked, boolean selected) {
            if (selected) {
                return -1;
            }
            if (unlocked) {
                return -9937334;
            }
            return -10727099;
        }
    }
}

