/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mrcrayfish.backpacked.client.gui.ParticleRenderState;
import com.mrcrayfish.backpacked.platform.ClientServices;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_12137;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class Particle2D {
    private int life = 10;
    private int totalLife = 10;
    private double prevX;
    private double prevY;
    private double x;
    private double y;
    private final double width;
    private final double height;
    private float u1;
    private float v1;
    private float u2;
    private float v2;
    private class_2960 sprite;
    private Vector2d motion = new Vector2d();
    private Vector2d gravity = new Vector2d();
    private double friction;
    private double prevRotation;
    private double rotation;
    private double rotationSpeed;
    private float startScale = 1.0f;
    private float endScale = 1.0f;
    private float prevScale = this.startScale;
    private float scale = this.startScale;
    private int startScaleAtLife = 0;
    private int endScaleAtLife = this.totalLife;

    public Particle2D(double x, double y, double width, double height) {
        this.prevX = x;
        this.prevY = y;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Particle2D setLife(int life) {
        this.totalLife = life;
        this.life = life;
        return this;
    }

    public Particle2D setSprite(float u1, float v1, float u2, float v2, class_2960 sprite) {
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        this.sprite = sprite;
        return this;
    }

    public Particle2D setMotion(Vector2d motion) {
        this.motion = motion;
        return this;
    }

    public Particle2D setGravity(Vector2d gravity) {
        this.gravity = gravity;
        return this;
    }

    public Particle2D setFriction(double friction) {
        this.friction = friction;
        return this;
    }

    public Particle2D setRotation(double rotation) {
        this.prevRotation = rotation;
        this.rotation = rotation;
        return this;
    }

    public Particle2D setRotationSpeed(double rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public Particle2D setStartScale(float scale) {
        return this.setStartScale(scale, 0);
    }

    public Particle2D setStartScale(float scale, int startAt) {
        this.startScale = scale;
        this.startScaleAtLife = startAt;
        this.scale = scale;
        this.prevScale = scale;
        return this;
    }

    public Particle2D setEndScale(float scale) {
        return this.setEndScale(scale, this.totalLife);
    }

    public Particle2D setEndScale(float scale, int endAt) {
        this.endScale = scale;
        this.endScaleAtLife = endAt;
        return this;
    }

    public boolean tick() {
        if (this.life <= 0) {
            return true;
        }
        this.prevX = this.x;
        this.prevY = this.y;
        this.prevRotation = this.rotation;
        this.prevScale = this.scale;
        this.motion.add((Vector2dc)this.gravity);
        this.x += this.motion.x / 20.0;
        this.y += this.motion.y / 20.0;
        this.x += this.gravity.x / 20.0;
        this.y += this.gravity.y / 20.0;
        this.motion.sub(this.motion.x * this.friction, this.motion.y * this.friction);
        this.rotation += this.rotationSpeed / 20.0;
        this.rotationSpeed -= this.rotationSpeed * this.friction;
        int maxScaleLife = Math.max(this.endScaleAtLife - this.startScaleAtLife, 1);
        this.scale = (float)class_3532.method_15340((int)(this.totalLife - this.life - this.startScaleAtLife), (int)0, (int)maxScaleLife) / (float)maxScaleLife;
        this.scale = class_3532.method_16439((float)this.scale, (float)this.startScale, (float)this.endScale);
        --this.life;
        return false;
    }

    public void render(class_332 graphics, float partialTick) {
        if (this.life <= 0) {
            return;
        }
        Matrix3x2fStack pose = graphics.method_51448();
        pose.pushMatrix();
        pose.translate((float)class_3532.method_16436((double)partialTick, (double)this.prevX, (double)this.x), (float)class_3532.method_16436((double)partialTick, (double)this.prevY, (double)this.y));
        pose.translate((float)(this.width / 2.0), (float)(this.height / 2.0));
        pose.rotate((float)class_3532.method_16436((double)partialTick, (double)this.prevRotation, (double)this.rotation) * ((float)Math.PI / 180));
        pose.scale(class_3532.method_16439((float)partialTick, (float)this.prevScale, (float)this.scale));
        pose.translate((float)(-this.width / 2.0), (float)(-this.height / 2.0));
        class_1058 sprite = class_310.method_1551().method_72703().method_73025(class_10725.field_56385).method_4608(this.sprite);
        GpuTextureView gpuTexture = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_71659();
        Matrix3x2f matrix = new Matrix3x2f((Matrix3x2fc)pose);
        ParticleRenderState state = new ParticleRenderState(class_10799.field_56883, class_11231.method_70900((GpuTextureView)gpuTexture, (class_12137)RenderSystem.getSamplerCache().method_75294(FilterMode.NEAREST)), matrix, this.width, this.height, sprite.method_4580(this.u1), sprite.method_4570(this.v1), sprite.method_4580(this.u2), sprite.method_4570(this.v2), null, new class_8030((int)this.x, (int)this.y, class_3532.method_15384((double)this.width), class_3532.method_15384((double)this.height)).method_71523((Matrix3x2fc)matrix));
        ClientServices.CLIENT.submitGuiElementRenderState(graphics, state);
        pose.popMatrix();
    }
}

