/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.augment.menu;

import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.BackpackButtons;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageCheckShelfKey;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3965;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class RecallMenu
extends AugmentSettingsMenu {
    private static final class_2561 OPTIONS_LABEL = class_2561.method_43471((String)"backpacked.gui.options");
    private static final class_2561 SET_SHELF_LABEL = class_2561.method_43471((String)"augment.backpacked.recall.link_shelf");
    private static final class_2561 SET_SHELF_TOOLTIP = class_2561.method_43471((String)"augment.backpacked.recall.link_shelf.tooltip");
    private static final class_2561 CHECKING_STATUS_LABEL = class_2561.method_43471((String)"augment.backpacked.recall.status.checking");
    private static final class_2561 NOT_SET_LABEL = class_2561.method_43471((String)"augment.backpacked.recall.status.no_shelf_linked");
    private static final class_2561 NO_SHELF_LABEL = class_2561.method_43471((String)"augment.backpacked.recall.status.shelf_missing");
    private static final int MIN_CONTENT_WIDTH = 110;

    public RecallMenu(PopupMenuHandler handler, AugmentHolder<RecallAugment> holder) {
        super(handler, (PopupMenu menu) -> {
            class_8667 layout = class_8667.method_52741().method_52735(2);
            TitleWidget title = (TitleWidget)layout.method_52736((class_8021)new TitleWidget(OPTIONS_LABEL, class_310.method_1551().field_1772));
            Divider divider = (Divider)layout.method_52736((class_8021)Divider.horizontal(Math.max(110, title.method_25368())).colour(-2044489));
            title.method_25358(divider.method_25368());
            ShelfStatus status = (ShelfStatus)layout.method_52738((class_8021)new ShelfStatus(108, 16, holder), class_7847::method_46467);
            status.check();
            layout.method_52736((class_8021)BackpackButtons.builder().setSize(110, 20).setLabel(SET_SHELF_LABEL).setTooltip(btn -> {
                if (!btn.method_37303()) {
                    return class_7919.method_47407((class_2561)SET_SHELF_TOOLTIP);
                }
                return null;
            }).setTooltipDelay(0).setDependent(() -> {
                class_239 patt0$temp;
                class_310 mc = class_310.method_1551();
                if (mc.field_1687 == null || mc.field_1724 == null || !((patt0$temp = mc.field_1765) instanceof class_3965)) {
                    return false;
                }
                class_3965 result = (class_3965)patt0$temp;
                class_2338 pos = result.method_17777();
                if (pos.method_19770((class_2374)mc.field_1724.method_33571()) > 256.0) {
                    return false;
                }
                class_2586 patt1$temp = mc.field_1687.method_8321(pos);
                if (!(patt1$temp instanceof ShelfBlockEntity)) {
                    return false;
                }
                ShelfBlockEntity shelf = (ShelfBlockEntity)patt1$temp;
                return !Objects.equals(((RecallAugment)holder.get()).shelfKey().orElse(null), shelf.key());
            }).setAction(btn -> {
                class_3965 result;
                class_2338 pos;
                class_2586 patt1$temp;
                class_239 patt0$temp;
                class_310 mc = class_310.method_1551();
                if (mc.field_1687 != null && (patt0$temp = mc.field_1765) instanceof class_3965 && (patt1$temp = mc.field_1687.method_8321(pos = (result = (class_3965)patt0$temp).method_17777())) instanceof ShelfBlockEntity) {
                    ShelfBlockEntity shelf = (ShelfBlockEntity)patt1$temp;
                    if (!Objects.equals(((RecallAugment)holder.get()).shelfKey().orElse(null), shelf.key())) {
                        holder.update(((RecallAugment)holder.get()).setShelfKey(shelf.key()));
                        status.check();
                    }
                }
            }).build());
            return layout;
        });
    }

    public static class ShelfStatus
    extends class_339 {
        private static final WeakHashMap<Key, Consumer<Boolean>> PENDING = new WeakHashMap();
        private static final class_2960 SHELF_STATUS_DEFAULT_SPRITE = Utils.id("backpack/shelf_status_default");
        private static final class_2960 SHELF_STATUS_INVALID_SPRITE = Utils.id("backpack/shelf_status_invalid");
        private static final class_2960 SHELF_STATUS_VALID_SPRITE = Utils.id("backpack/shelf_status_valid");
        private final Key key;
        private final AugmentHolder<RecallAugment> holder;
        private Status status = Status.NOT_SET;

        public ShelfStatus(int width, int height, AugmentHolder<RecallAugment> holder) {
            super(0, 0, width, height, class_5244.field_39003);
            this.key = new Key(holder.backpackIndex(), holder.position());
            this.holder = holder;
        }

        private void check() {
            Optional<ShelfKey> optional = this.holder.get().shelfKey();
            optional.ifPresentOrElse(shelfKey -> {
                Network.getPlay().sendToServer((Object)new MessageCheckShelfKey(this.holder.backpackIndex(), this.holder.position()));
                PENDING.put(this.key, valid -> {
                    this.status = valid != false ? Status.VALID : Status.INVALID;
                });
            }, () -> {
                this.status = Status.NOT_SET;
            });
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            graphics.method_52706(class_10799.field_56883, this.getStatusSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            int textX = this.method_46426() + this.method_25368() / 2;
            int textY = this.method_46427() + (int)Math.ceil((double)(this.method_25364() - 9) / 2.0);
            graphics.method_27534(class_310.method_1551().field_1772, this.getLabel(), textX, textY, -1);
        }

        private class_2960 getStatusSprite() {
            return switch (this.status.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SHELF_STATUS_DEFAULT_SPRITE;
                case 1 -> SHELF_STATUS_INVALID_SPRITE;
                case 2 -> SHELF_STATUS_VALID_SPRITE;
            };
        }

        private class_2561 getLabel() {
            if (PENDING.containsKey(this.key)) {
                return CHECKING_STATUS_LABEL;
            }
            return switch (this.status.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> NOT_SET_LABEL;
                case 1 -> NO_SHELF_LABEL;
                case 2 -> this.holder.get().shelfKey().map(k -> class_2338.method_10092((long)k.position()).method_23854()).map(class_2561::method_43470).map(c -> c).orElse(NOT_SET_LABEL);
            };
        }

        protected void method_47399(class_6382 output) {
        }

        public static void handle(int backpackIndex, Augments.Position position, boolean valid) {
            Key key = new Key(backpackIndex, position);
            Consumer<Boolean> consumer = PENDING.remove(key);
            if (consumer != null) {
                consumer.accept(valid);
            }
        }

        private static enum Status {
            NOT_SET,
            INVALID,
            VALID;

        }

        private record Key(int backpackIndex, Augments.Position position) {
        }
    }
}

