/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.augment.menu;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.BackpackButtons;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.ItemGrid;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.common.augment.impl.FunnellingAugment;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import com.mrcrayfish.framework.api.client.screen.widget.Buttons;
import com.mrcrayfish.framework.api.client.screen.widget.FrameworkEditBox;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8666;
import net.minecraft.class_8667;

public class FunnellingMenu
extends AugmentSettingsMenu {
    private static final class_2561 SEARCH_HINT = class_2561.method_43471((String)"backpacked.gui.search_hint").method_27692(class_124.field_1068);
    private static final class_2561 ACTIVE_LABEL = class_2561.method_43471((String)"backpacked.gui.active");
    private static final class_2561 FILTERS_LABEL = class_2561.method_43471((String)"backpacked.gui.filters");
    private static final class_2561 SHOW_ALL_LABEL = class_2561.method_43471((String)"backpacked.gui.show_all");
    private static final class_2561 ACTIVATED_ONLY_LABEL = class_2561.method_43471((String)"backpacked.gui.activated_only");
    private static final Predicate<class_1792> REMOVE_BLOCKS_WITHOUT_LOOT_TABLE = item -> {
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            Optional key = blockItem.method_7711().method_26162();
            return key.isPresent();
        }
        return true;
    };
    private static final int MIN_CONTENT_WIDTH = 162;
    private static String lastQuery = "";
    private static boolean selectedOnly = false;

    public FunnellingMenu(PopupMenuHandler handler, AugmentHolder<FunnellingAugment> holder) {
        super(handler, (PopupMenu menu) -> {
            class_8667 layout = class_8667.method_52741().method_52735(2);
            TitleWidget title = (TitleWidget)layout.method_52736((class_8021)new TitleWidget(() -> {
                int filterCount = ((FunnellingAugment)holder.get()).filters().ids().size();
                int maxFilters = (Integer)Config.AUGMENTS.funnelling.maxFilters.get();
                class_5250 amount = class_2561.method_43469((String)"backpacked.gui.x_of_y", (Object[])new Object[]{filterCount, maxFilters});
                return ScreenUtil.join(" ", new class_2561[]{FILTERS_LABEL, amount});
            }, class_310.method_1551().field_1772));
            Divider divider = (Divider)layout.method_52736((class_8021)Divider.horizontal(Math.max(162, title.method_25368())).colour(-2044489));
            title.method_25358(divider.method_25368());
            ItemGrid<FunnellingAugment> grid = ItemGrid.builder(holder::get, holder::update).setWidth(divider.method_25368()).setHeight(84).setInitialQuery(lastQuery).setPredicate(REMOVE_BLOCKS_WITHOUT_LOOT_TABLE).build();
            grid.setSelectedOnly(selectedOnly);
            int filterButtonWidth = 55;
            class_8667 header = class_8667.method_52742().method_52735(3);
            FrameworkEditBox searchField = FrameworkEditBox.builder().setWidth(divider.method_25368() - 3 - filterButtonWidth).setPadding(2, 0, 2, 0).setHeight(16).setIcon(Utils.id("backpack/editbox/search"), 12, 12).setInitialText(lastQuery).setHint(SEARCH_HINT).setCallback(s -> {
                grid.setSearchQuery((String)s);
                lastQuery = s;
            }).setBackground(new class_8666(Utils.id("backpack/editbox/background"), Utils.id("backpack/editbox/background_focused"))).build();
            header.method_52738((class_8021)searchField, class_7847::method_46474);
            header.method_52736((class_8021)Buttons.createToggle(() -> selectedOnly, newValue -> {
                selectedOnly = newValue;
            }, grid::setSelectedOnly).setSize(filterButtonWidth, 18).setSpacing(2).setLabel(ACTIVE_LABEL).setTooltip(btn -> class_7919.method_47407((class_2561)(selectedOnly ? ACTIVATED_ONLY_LABEL : SHOW_ALL_LABEL))).setTexture(new class_8666(Utils.id("backpack/button_enabled"), Utils.id("backpack/button_enabled_focused"))).build());
            layout.method_52736((class_8021)header);
            layout.method_52736(grid);
            layout.method_52736((class_8021)BackpackButtons.values(() -> ((FunnellingAugment)holder.get()).mode(), mode -> holder.update(((FunnellingAugment)holder.get()).setMode((FunnellingAugment.Mode)mode)), mode -> {}).setSize(divider.method_25368(), 18).build());
            return layout;
        });
    }
}

