/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.renderer.backpack.advanced.function.SpawnParticleFunction;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModKeyMappings;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.data.pickpocket.TraderPickpocketing;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessagePickpocketBackpack;
import com.mrcrayfish.backpacked.network.message.MessageRequestManagement;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.event.client.FrameworkClientConnectionEvents;
import com.mrcrayfish.framework.api.event.client.FrameworkClientTickEvents;
import com.mrcrayfish.framework.api.event.client.FrameworkInputEvents;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_11908;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_5575;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_9331;

public class ClientEvents {
    public static void init() {
        FrameworkClientTickEvents.END_CLIENT.register(ClientEvents::onClientTickEnd);
        FrameworkClientConnectionEvents.LOGGING_IN.register(ClientEvents::onPlayerLogin);
        FrameworkInputEvents.KEY_PRESS.register(ClientEvents::onKeyInput);
        FrameworkInputEvents.INTERACTION.register(ClientEvents::onInteraction);
    }

    private static void onPlayerLogin(class_746 player, class_636 gameMode, class_2535 connection) {
        Config.updateBannedItemsList();
    }

    public static void onKeyInput(int action, class_11908 event) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1755 == null) {
            if (ModKeyMappings.KEY_BACKPACK.method_1434() && ModKeyMappings.KEY_BACKPACK.method_1436()) {
                Network.getPlay().sendToServer((Object)new MessageOpenBackpack());
            }
            if (ModKeyMappings.KEY_MANAGEMENT.method_1434() && ModKeyMappings.KEY_MANAGEMENT.method_1436()) {
                Network.getPlay().sendToServer((Object)new MessageRequestManagement());
            }
        }
    }

    private static void onClientTickEnd() {
        SpawnParticleFunction.clearSpawned();
    }

    public static boolean canShowBackpackEffects(class_1799 stack) {
        return ((CosmeticProperties)stack.method_58695((class_9331)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)CosmeticProperties.DEFAULT)).showEffects();
    }

    private static boolean onInteraction(boolean attack, boolean use, boolean pick, class_1268 hand) {
        if (!use || hand != class_1268.field_5808) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null || mc.field_1761 == null) {
            return false;
        }
        double range = (Double)Config.PICKPOCKETING.maxReachDistance.get();
        ArrayList entities = new ArrayList();
        if (((Boolean)Config.PICKPOCKETING.enabled.get()).booleanValue()) {
            entities.addAll(mc.field_1687.method_18023((class_5575)class_1299.field_6097, mc.field_1724.method_5829().method_1014(range), player -> {
                Optional optional = (Optional)ModSyncedDataKeys.COSMETIC_PROPERTIES.getValue((class_1297)player);
                return !player.equals((Object)mc.field_1724) && optional.isPresent() && PickpocketUtil.canPickpocketEntity((class_1309)player, (class_1657)mc.field_1724);
            }));
        }
        entities.addAll(mc.field_1687.method_18023((class_5575)class_1299.field_17713, mc.field_1724.method_5829().method_1014(mc.field_1724.method_55755()), entity -> TraderPickpocketing.get((class_1297)entity).map(TraderPickpocketing::isBackpackEquipped).orElse(false) != false && PickpocketUtil.canPickpocketEntity((class_1309)entity, (class_1657)mc.field_1724, mc.field_1724.method_55755())));
        if (entities.isEmpty()) {
            return false;
        }
        class_243 start = mc.field_1724.method_5836(1.0f);
        class_243 end = mc.field_1724.method_5828(1.0f).method_1021(mc.field_1724.method_55755()).method_1019(start);
        double closestDistance = Double.MAX_VALUE;
        class_1309 hitEntity = null;
        for (class_1309 entity2 : entities) {
            double distance;
            class_238 box = PickpocketUtil.getBackpackBox(entity2, 1.0f);
            Optional optionalHitVec = box.method_992(start, end);
            if (optionalHitVec.isEmpty() || !((distance = start.method_1022((class_243)optionalHitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            hitEntity = entity2;
        }
        if (hitEntity != null) {
            if (PickpocketUtil.canSeeBackpack(hitEntity, (class_1657)mc.field_1724)) {
                Network.getPlay().sendToServer((Object)new MessagePickpocketBackpack(hitEntity.method_5628()));
                mc.field_1724.method_6104(hand);
            }
            return true;
        }
        return false;
    }
}

