/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.block.ShelfBlock;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.augment.data.Recall;
import com.mrcrayfish.backpacked.common.backpack.BackpackState;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackShelfMenu;
import com.mrcrayfish.backpacked.inventory.container.UnlockableContainer;
import com.mrcrayfish.backpacked.inventory.container.data.ManagementContainerData;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageLootboundTakeItem;
import com.mrcrayfish.backpacked.network.message.MessageShelfPlaceAnimation;
import com.mrcrayfish.backpacked.util.BlockEntityUtil;
import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.menu.IMenuData;
import com.mrcrayfish.framework.api.network.LevelLocation;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ShelfBlockEntity
extends class_2586 {
    public static final int SIZE = 1;
    public static final int TOTAL_ANIMATION_TICKS = 4;
    private final class_1277 container = new ShelfContainer(this);
    private int recallQueueCount;
    @Nullable
    private UUID recallOwner = null;
    private int recallIndex = -1;
    @Nullable
    private ShelfKey key;
    private boolean loadingItems;
    private int animation = -1;
    public int tickCount;

    public ShelfBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public ShelfBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.BACKPACK_SHELF.get(), pos, state);
    }

    public class_1277 getContainer() {
        return this.container;
    }

    public int getRecallQueueCount() {
        return this.recallQueueCount;
    }

    public void setRecallQueueCount(int queueCount) {
        if (this.recallQueueCount != queueCount) {
            this.recallQueueCount = queueCount;
            this.method_5431();
        }
    }

    public void recall(class_1799 stack, UUID owner, int originalIndex) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            this.setBackpack(stack.method_51164());
            this.recallOwner = owner;
            this.recallIndex = originalIndex;
            class_243 center = this.method_11010().method_26218((class_1922)this.field_11863, this.field_11867).method_1107().method_1005().method_1019(class_243.method_24954((class_2382)this.field_11867));
            level.method_65096((class_2394)class_2398.field_23190, center.field_1352, center.field_1351, center.field_1350, 20, 0.25, 0.25, 0.25, 0.1);
            float pitch = 0.7f + 0.1f * level.field_9229.method_43057();
            level.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_46945, class_3419.field_15245, 1.0f, pitch);
        }
    }

    public ShelfKey key() {
        Preconditions.checkNotNull((Object)this.field_11863);
        if (this.key == null) {
            this.key = new ShelfKey((class_5321<class_1937>)this.field_11863.method_27983(), this.field_11867.method_10063());
        }
        return this.key;
    }

    public void popBackpack(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_1799 backpack = this.getBackpack();
        if (backpack.method_7960()) {
            return;
        }
        class_243 pos = this.field_11867.method_46558().method_1023(0.0, 0.25, 0.0);
        UUID originalOwner = this.recallOwner;
        int originalIndex = this.recallIndex;
        this.setBackpack(class_1799.field_8037);
        if (player.method_5667().equals(originalOwner) && originalIndex != -1 && BackpackHelper.getBackpackStack(player, originalIndex).method_7960() && BackpackHelper.setBackpackStack(player, backpack.method_7972(), originalIndex)) {
            Network.getPlay().sendToTrackingLocation(() -> LevelLocation.create((class_3218)serverLevel, (class_2338)this.field_11867, (double)16.0), (Object)new MessageLootboundTakeItem(player.method_5628(), new class_1799((class_1935)backpack.method_7909()), pos, false));
            serverLevel.method_47967(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)class_3417.field_14581.comp_349(), player.method_5634(), 1.0f, 1.0f, player.method_59922().method_43055());
            return;
        }
        class_1542 entity = new class_1542((class_1937)serverLevel, pos.field_1352, pos.field_1351 - 0.25, pos.field_1350, backpack.method_51164());
        if (serverLevel.method_8649((class_1297)entity)) {
            entity.method_5694(player);
        }
    }

    private void openBackpackInventory(class_3222 player) {
    }

    public void openShelfManagement(class_3222 player) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots((class_1657)player);
        FrameworkAPI.openMenuWithData((class_3222)player, (class_3908)new class_747((windowId, playerInventory, player1) -> new BackpackShelfMenu(windowId, playerInventory, new ManagementInventory(player), (class_1263)this.container, slots), (class_2561)class_2561.method_43471((String)"container.backpack_shelf")), (IMenuData)new ManagementContainerData(slots, false));
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        class_1799 backpack = input.method_71426("Backpack", class_1799.field_49266).orElse(class_1799.field_8037);
        Optional itemsOptional = input.method_71420("Items");
        if (!backpack.method_7960() && itemsOptional.isPresent()) {
            BackpackShelfContainer container1 = new BackpackShelfContainer(this, this.getBackpackSize());
            container1.load(input);
            backpack.method_57379(class_9334.field_49622, (Object)container1.createContents());
        }
        this.container.method_5447(0, backpack);
        this.recallQueueCount = input.method_71424("QueueCount", 0);
        input.method_71426("RecallOwner", class_4844.field_25122).ifPresent(uuid -> {
            this.recallOwner = uuid;
            input.method_71439("RecallIndex").ifPresent(index -> {
                this.recallIndex = index;
            });
        });
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71468("Backpack", class_1799.field_49266, (Object)this.container.method_5438(0));
        if (this.recallOwner != null) {
            output.method_71468("RecallOwner", class_4844.field_25122, (Object)this.recallOwner);
            if (this.recallIndex > 0) {
                output.method_71465("RecallIndex", this.recallIndex);
            }
        }
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_58692(provider);
    }

    public void method_71401(class_11372 output) {
        output.method_71468("Backpack", class_1799.field_49266, (Object)this.container.method_5438(0));
        output.method_71465("QueueCount", this.recallQueueCount);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_1799 getBackpack() {
        return this.container.method_5438(0);
    }

    public void setBackpack(class_1799 stack) {
        this.container.method_5447(0, stack);
        this.recallOwner = null;
        this.recallIndex = -1;
        this.method_5431();
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)ShelfBlock.field_11177);
    }

    @Nullable
    private UnlockableSlots getUnlockableSlots() {
        class_1799 stack = this.container.method_5438(0);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem item = (BackpackItem)class_17922;
            return item.getUnlockableSlots(stack);
        }
        return null;
    }

    private Optional<BackpackItem> getBackpackItem() {
        class_1799 backpack = this.container.method_5438(0);
        class_1792 class_17922 = backpack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem item = (BackpackItem)class_17922;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    private int getBackpackSize() {
        return this.getBackpackItem().map(item -> item.getRowCount() * item.getColumnCount()).orElse(0);
    }

    public void method_5431() {
        super.method_5431();
        BlockEntityUtil.sendUpdatePacket(this);
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ((Recall.Access)serverLevel).backpacked$getRecall().onShelfBroken(serverLevel, this);
            class_1799 stack = this.getBackpack();
            class_1264.method_5449((class_1937)serverLevel, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack.method_51164());
            serverLevel.method_8455(pos, state.method_26204());
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, ShelfBlockEntity shelf) {
        if (shelf.animation >= 0 && shelf.animation < 4) {
            ++shelf.animation;
        }
        ++shelf.tickCount;
    }

    public void playAnimation() {
        if (!this.isAnimationPlaying()) {
            this.animation = 0;
        }
    }

    public int getAnimationTicks() {
        return this.animation;
    }

    public boolean isAnimationPlaying() {
        return this.animation >= 0 && this.animation < 4;
    }

    public int getRenderTicks() {
        return this.tickCount;
    }

    public static class ShelfContainer
    extends class_1277 {
        private final ShelfBlockEntity shelf;

        public ShelfContainer(ShelfBlockEntity shelf) {
            super(1);
            this.shelf = shelf;
        }

        public void method_5431() {
            class_1937 level = this.shelf.field_11863;
            if (level instanceof class_3218) {
                this.shelf.method_5431();
            }
        }

        public void method_5447(int slot, class_1799 stack) {
            class_1799 before = this.method_5438(slot);
            class_1937 class_19372 = this.shelf.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 level = (class_3218)class_19372;
                if (before.method_7960() ^ stack.method_7960()) {
                    float pitch = stack.method_7960() ? 0.75f : 1.0f;
                    level.method_8396(null, this.shelf.field_11867, (class_3414)ModSounds.ITEM_BACKPACK_PLACE.get(), class_3419.field_15245, 1.0f, pitch);
                    if (!this.shelf.loadingItems && !stack.method_7960()) {
                        Network.getPlay().sendToTrackingBlockEntity(() -> this.shelf, (Object)new MessageShelfPlaceAnimation(this.shelf.field_11867));
                    }
                }
            }
            super.method_5447(slot, stack);
        }

        public class_1799 method_5434(int slot, int count) {
            class_1799 stack = class_1262.method_5430((List)this.method_54454(), (int)slot, (int)count);
            if (!stack.method_7960()) {
                this.method_5431();
            }
            return stack;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            return stack.method_7909() instanceof BackpackItem;
        }

        public int method_5444() {
            return 1;
        }

        public ShelfBlockEntity getShelf() {
            return this.shelf;
        }
    }

    public static class BackpackShelfContainer
    extends UnlockableContainer {
        private final ShelfBlockEntity entity;
        private final class_1799 stack;
        private final BackpackState state;

        public BackpackShelfContainer(ShelfBlockEntity entity, int size) {
            super(size);
            this.entity = entity;
            this.stack = this.entity.getBackpack();
            this.state = BackpackState.create(this.entity.getBackpack());
        }

        @Override
        protected UnlockableSlots getUnlockableSlots() {
            UnlockableSlots slots = this.entity.getUnlockableSlots();
            return slots != null ? slots : UnlockableSlots.ALL;
        }

        public void method_5431() {
            this.entity.method_5431();
        }

        @Override
        public boolean method_5437(int slot, class_1799 stack) {
            return BackpackInventory.isAllowedItem(stack) && super.method_5437(slot, stack);
        }

        @Override
        public boolean method_5443(class_1657 player) {
            return this.stack == this.entity.getBackpack() && !this.entity.field_11865;
        }

        public class_1799 getBackpack() {
            return this.entity.getBackpack();
        }

        public ShelfBlockEntity getBlockEntity() {
            return this.entity;
        }

        public BackpackState getState() {
            return this.state;
        }
    }
}

