/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.blockentity;

import com.mrcrayfish.backpacked.blockentity.IOptionalStorage;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.backpack.BackpackState;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.container.UnlockableContainer;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.BlockEntityUtil;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BackpackDockBlockEntity
extends class_2586
implements IOptionalStorage {
    private class_1799 backpack = class_1799.field_8037;
    @Nullable
    private ItemStackContainer inventory;

    public BackpackDockBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.BACKPACK_DOCK.get(), pos, state);
    }

    @Override
    @Nullable
    public class_1263 getInventory() {
        return this.inventory;
    }

    public boolean hasBackpack() {
        return !this.backpack.method_7960();
    }

    public class_1799 getBackpack() {
        return this.backpack;
    }

    public boolean setBackpackOrPop(class_1799 backpack) {
        if (this.popBackpack()) {
            return true;
        }
        if (backpack.method_7909() instanceof BackpackItem) {
            if (this.field_11863 instanceof class_3218) {
                this.backpack = backpack.method_51164();
                this.updateInventory();
                this.method_5431();
                BlockEntityUtil.sendUpdatePacket(this);
                this.playSound(class_3417.field_14667);
            }
            return true;
        }
        return false;
    }

    private boolean popBackpack() {
        if (!this.backpack.method_7960()) {
            if (this.field_11863 instanceof class_3218) {
                class_1799 stack = this.getBackpackWithContents();
                this.backpack = class_1799.field_8037;
                this.inventory = null;
                this.method_5431();
                class_243 spawn = this.getPopPosition();
                class_1542 entity = new class_1542(this.field_11863, spawn.field_1352, spawn.field_1351, spawn.field_1350, stack);
                entity.method_6988();
                this.field_11863.method_8649((class_1297)entity);
                BlockEntityUtil.sendUpdatePacket(this);
                this.playSound(class_3417.field_14770);
            }
            return true;
        }
        return false;
    }

    private void playSound(class_3414 event) {
        float pitch = this.field_11863.field_9229.method_43057() * 0.2f + 0.9f;
        this.field_11863.method_8396(null, this.field_11867, event, class_3419.field_15245, pitch, 1.0f);
    }

    private class_243 getPopPosition() {
        return this.method_11016().method_46558().method_43206(this.getDirection(), 0.6875);
    }

    private class_1799 getBackpackWithContents() {
        class_1799 stack = this.backpack;
        if (!stack.method_7960()) {
            this.copyInventoryToStack(stack);
        }
        return stack.method_7972();
    }

    private void copyInventoryToStack(class_1799 stack) {
        if (!stack.method_7960() && this.inventory != null) {
            stack.method_57379(class_9334.field_49622, (Object)this.inventory.createContents());
        }
    }

    public class_2350 getDirection() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)class_2741.field_12481)) {
            return ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153();
        }
        return class_2350.field_11043;
    }

    private void updateInventory() {
        if (this.field_11863 instanceof class_3218) {
            class_1799 stack = this.backpack;
            if (stack.method_7909() instanceof BackpackItem) {
                if (this.inventory == null || stack != this.inventory.stack) {
                    class_9288 contents = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
                    this.inventory = new ItemStackContainer(this, this.getBackpackSize());
                    this.inventory.copyFrom(contents);
                    this.method_5431();
                    return;
                }
                this.resizeInventory();
                return;
            }
            this.inventory = null;
            this.method_5431();
        }
    }

    private void resizeInventory() {
        int backpackSize = this.getBackpackSize();
        if (this.inventory != null && this.inventory.getState().isInvalid()) {
            ItemStackContainer oldInventory = this.inventory;
            this.inventory = new ItemStackContainer(this, backpackSize);
            InventoryHelper.mergeInventoryOrSpawnIntoLevel(oldInventory, this.inventory, this.field_11863, this.getPopPosition());
            this.method_5431();
        }
    }

    private int getBackpackSize() {
        class_1792 class_17922 = this.backpack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem item = (BackpackItem)class_17922;
            return item.getRowCount() * item.getColumnCount();
        }
        return 0;
    }

    public void openBackpackMenu(class_3222 player) {
        class_1792 class_17922;
        this.updateInventory();
        if (this.inventory != null && this.inventory.method_5443((class_1657)player) && (class_17922 = this.backpack.method_7909()) instanceof BackpackItem) {
            BackpackItem item = (BackpackItem)class_17922;
            class_2561 title = this.backpack.method_7964();
            int cols = item.getColumnCount();
            int rows = item.getRowCount();
            UnlockableSlots slots = item.getUnlockableSlots(this.backpack);
            if (slots != null) {
                Services.BACKPACK.openBackpackScreen(player, this.inventory, -1, -1, cols, rows, false, slots, Pagination.NONE, Augments.EMPTY, title, UnlockableSlots.NONE);
            }
        }
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.backpack = input.method_71426("Backpack", class_1799.field_49266).orElse(class_1799.field_8037);
        this.updateInventory();
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71468("Backpack", class_1799.field_49266, (Object)this.getBackpackWithContents());
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_58692(provider);
    }

    public void method_71401(class_11372 output) {
        output.method_71468("Backpack", class_1799.field_49266, (Object)this.backpack);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        class_1799 stack = this.getBackpackWithContents();
        if (!stack.method_7960() && this.field_11863 != null) {
            class_1264.method_5449((class_1937)this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack);
        }
    }

    public static class ItemStackContainer
    extends UnlockableContainer {
        private final BackpackDockBlockEntity entity;
        private final class_1799 stack;
        private final BackpackState state;

        public ItemStackContainer(BackpackDockBlockEntity entity, int size) {
            super(size);
            this.entity = entity;
            this.stack = this.entity.backpack;
            this.state = BackpackState.create(this.stack);
        }

        @Override
        protected UnlockableSlots getUnlockableSlots() {
            class_1792 class_17922 = this.stack.method_7909();
            if (class_17922 instanceof BackpackItem) {
                BackpackItem item = (BackpackItem)class_17922;
                return item.getUnlockableSlots(this.stack);
            }
            return UnlockableSlots.ALL;
        }

        public void method_5431() {
            this.entity.method_5431();
        }

        @Override
        public boolean method_5437(int slot, class_1799 stack) {
            return BackpackInventory.isAllowedItem(stack) && super.method_5437(slot, stack);
        }

        @Override
        public boolean method_5443(class_1657 player) {
            return this.entity.inventory == this && this.stack == this.entity.backpack && this.stack.method_7909() instanceof BackpackItem && !this.entity.method_11015();
        }

        @Override
        public class_9288 createContents() {
            return class_9288.method_57493((List)this.items);
        }

        public class_1799 getBackpackStack() {
            return this.stack;
        }

        public BackpackDockBlockEntity getBlockEntity() {
            return this.entity;
        }

        public BackpackState getState() {
            return this.state;
        }
    }
}

