/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends class_2383
implements class_2343 {
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.method_54094(ShelfBlock::new);
    private static final Map<class_2350, class_265> EMPTY_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)5.0, (double)16.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)5.0, (double)9.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)7.0, (double)3.0, (double)2.0, (double)16.0, (double)5.0, (double)14.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)2.0, (double)9.0, (double)5.0, (double)14.0)));
    private static final Map<class_2350, class_265> SHELVED_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)15.0, (double)16.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)15.0, (double)9.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)7.0, (double)3.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)2.0, (double)9.0, (double)15.0, (double)14.0)));

    public ShelfBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    protected MapCodec<ShelfBlock> method_53969() {
        return CODEC;
    }

    private boolean isInteractionTargetingShelf(class_2338 pos, class_3965 result) {
        class_243 localHit = result.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        return localHit.field_1351 <= 0.3125;
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        ShelfBlockEntity shelf;
        class_2586 class_25862;
        if (stack.method_7909() instanceof BackpackItem && (class_25862 = level.method_8321(pos)) instanceof ShelfBlockEntity && (shelf = (ShelfBlockEntity)class_25862).getBackpack().method_7960()) {
            shelf.setBackpack(stack.method_51164());
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 result) {
        class_2586 class_25862;
        if (!level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelf = (ShelfBlockEntity)class_25862;
            if (this.isInteractionTargetingShelf(pos, result)) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    shelf.openShelfManagement(serverPlayer);
                }
            } else if (!player.method_18276() && !shelf.getBackpack().method_7960()) {
                shelf.popBackpack(player);
            }
        }
        return class_1269.field_5812;
    }

    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 context) {
        ShelfBlockEntity shelfBlockEntity;
        class_2586 class_25862 = getter.method_8321(pos);
        if (class_25862 instanceof ShelfBlockEntity && !(shelfBlockEntity = (ShelfBlockEntity)class_25862).getBackpack().method_7960()) {
            return SHELVED_SHAPES.get(state.method_11654((class_2769)field_11177));
        }
        return EMPTY_SHAPES.get(state.method_11654((class_2769)field_11177));
    }

    public boolean method_9558(class_2680 state, class_4538 reader, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        class_2338 relativePos = pos.method_10093(facing.method_10153());
        class_2680 relativeState = reader.method_8320(relativePos);
        return relativeState.method_26206((class_1922)reader, relativePos, facing);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 potentialState;
        class_2350 clickedFace = context.method_8038();
        if (clickedFace.method_10166().method_10179() && this.method_9558(potentialState = (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)clickedFace), (class_4538)context.method_8045(), context.method_8037())) {
            return potentialState;
        }
        return null;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos, class_2350 face) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelf = (ShelfBlockEntity)class_25862;
            return class_1703.method_7618((class_1263)shelf.getContainer());
        }
        return 0;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return Services.BACKPACK.createShelfBlockEntityType(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return level.method_8608() ? ShelfBlock.ticker(type, (class_2591)ModBlockEntities.BACKPACK_SHELF.get(), ShelfBlockEntity::clientTick) : null;
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> ticker(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

