/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.backpacked.common.CostModel;
import com.mrcrayfish.backpacked.common.InterpolateFunction;
import com.mrcrayfish.backpacked.common.PaymentItem;
import com.mrcrayfish.backpacked.common.PaymentType;
import com.mrcrayfish.backpacked.common.SelectionFunction;
import com.mrcrayfish.backpacked.common.UnlockableSlotMode;
import com.mrcrayfish.backpacked.common.augment.impl.EmptyAugment;
import com.mrcrayfish.backpacked.core.ModRegistries;
import com.mrcrayfish.framework.api.config.BoolProperty;
import com.mrcrayfish.framework.api.config.ConfigProperty;
import com.mrcrayfish.framework.api.config.ConfigType;
import com.mrcrayfish.framework.api.config.DoubleProperty;
import com.mrcrayfish.framework.api.config.EnumProperty;
import com.mrcrayfish.framework.api.config.FrameworkConfig;
import com.mrcrayfish.framework.api.config.IntProperty;
import com.mrcrayfish.framework.api.config.ListProperty;
import com.mrcrayfish.framework.api.config.StringProperty;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.framework.api.config.validate.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8111;

public class Config {
    @FrameworkConfig(id="backpacked", name="client", type=ConfigType.CLIENT)
    public static final Client CLIENT = new Client();
    @FrameworkConfig(id="backpacked", name="backpack", type=ConfigType.SERVER_SYNC)
    public static final Backpack BACKPACK = new Backpack();
    @FrameworkConfig(id="backpacked", name="pickpocketing", type=ConfigType.SERVER_SYNC)
    public static final Pickpocketing PICKPOCKETING = new Pickpocketing();
    @FrameworkConfig(id="backpacked", name="wandering_trader", type=ConfigType.SERVER)
    public static final WanderingTrader WANDERING_TRADER = new WanderingTrader();
    @FrameworkConfig(id="backpacked", name="augments", type=ConfigType.SERVER_SYNC)
    public static final Augments AUGMENTS = new Augments();
    public static final int MAX_EQUIPPABLE_BACKPACKS = 9;
    private static final PaymentItem INVENTORY_PAYMENT_ITEM = new PaymentItem(() -> ((StringProperty)Config.BACKPACK.inventory.slots.unlockCost.paymentItem).get());
    private static final PaymentItem BACKPACK_PAYMENT_ITEM = new PaymentItem(() -> ((StringProperty)Config.BACKPACK.equipable.unlockCost.paymentItem).get());
    private static final PaymentItem AUGMENT_BAY_PAYMENT_ITEM = new PaymentItem(() -> ((StringProperty)Config.BACKPACK.augmentBays.unlockCost.paymentItem).get());
    private static Set<class_2960> bannedItemsList;
    private static Set<class_2960> disabledAugments;

    public static void init() {
        FrameworkConfigEvents.LOAD.register(object -> {
            if (object == BACKPACK) {
                Config.updateBannedItemsList();
                INVENTORY_PAYMENT_ITEM.clearItem();
                BACKPACK_PAYMENT_ITEM.clearItem();
                AUGMENT_BAY_PAYMENT_ITEM.clearItem();
            } else if (object == AUGMENTS) {
                disabledAugments = null;
            }
        });
        FrameworkConfigEvents.RELOAD.register(object -> {
            if (object == BACKPACK) {
                Config.updateBannedItemsList();
                INVENTORY_PAYMENT_ITEM.clearItem();
                BACKPACK_PAYMENT_ITEM.clearItem();
                AUGMENT_BAY_PAYMENT_ITEM.clearItem();
            } else if (object == AUGMENTS) {
                disabledAugments = null;
            }
        });
    }

    public static void updateBannedItemsList() {
        bannedItemsList = ImmutableSet.copyOf((Collection)((List)Config.BACKPACK.inventory.bannedItems.get()).stream().map(class_2960::method_12829).collect(Collectors.toSet()));
    }

    public static Set<class_2960> getBannedItemsList() {
        return bannedItemsList != null ? bannedItemsList : Collections.emptySet();
    }

    public static PaymentItem getInventoryPaymentItem() {
        return INVENTORY_PAYMENT_ITEM;
    }

    public static PaymentItem getBackpackPaymentItem() {
        return BACKPACK_PAYMENT_ITEM;
    }

    public static PaymentItem getAugmentBayPaymentItem() {
        return AUGMENT_BAY_PAYMENT_ITEM;
    }

    public static Set<class_2960> getDisabledAugments() {
        if (disabledAugments == null) {
            disabledAugments = ImmutableSet.copyOf((Collection)((List)Config.AUGMENTS.disabledAugments.get()).stream().map(class_2960::method_12829).filter(Objects::nonNull).filter(arg_0 -> ModRegistries.AUGMENT_TYPES.containsKey(arg_0)).filter(id -> !EmptyAugment.TYPE.id().equals(id)).collect(Collectors.toSet()));
        }
        return disabledAugments;
    }

    public static class Backpack {
        @ConfigProperty(name="equipable", comment="Equipable related properties")
        public final Equipable equipable = new Equipable();
        @ConfigProperty(name="cosmetics", comment="Cosmetic related properties")
        public final Cosmetics cosmetics = new Cosmetics();
        @ConfigProperty(name="inventory", comment="Inventory related properties")
        public final Inventory inventory = new Inventory();
        @ConfigProperty(name="augmentBays", comment="Augment Bay related properties")
        public final AugmentBays augmentBays = new AugmentBays();

        public static class Equipable {
            @ConfigProperty(name="maxEquipable", comment="The maximum amount of backpacks that can be equipped by a player. This will determine\nhow many slots will appear when opening the \"Equipped Backpacks\" menu.")
            public final IntProperty maxEquipable = IntProperty.create((int)5, (int)1, (int)9);
            @ConfigProperty(name="keepOnDeath", comment="If enabled, backpacks will stay equipped on the player after death (same as the\nkeepInventory game rule). Please note that this will make the Recall augment\neffectively useless.")
            public final BoolProperty keepOnDeath = BoolProperty.create((boolean)false);
            @ConfigProperty(name="initialUnlockedEquipableSlots", comment="The number of equippable slots that will automatically be unlocked by default and for free.\nPlease note that the cost model will still factor these free slots into the calculation\nfor unlocking the next locked slot. The slots also cannot be revoked once unlocked.")
            public final IntProperty initialUnlockedEquipableSlots = IntProperty.create((int)1, (int)0, (int)9);
            @ConfigProperty(name="unlockAllEquipableSlots", comment="If set to true, all equipable slots will be unlocked by default.\nWARNING: Reverting the option from true to false will cause backpacks to be dropped\ninto the world if the slot they are in is now locked. You have been warned.")
            public final BoolProperty unlockAllEquipableSlots = BoolProperty.create((boolean)false);
            @ConfigProperty(name="allowUnlockingUsingUnlockToken", comment="If set to true, equipable slots may be unlocked using Unlock Tokens")
            public final BoolProperty allowUnlockingUsingUnlockToken = BoolProperty.create((boolean)false);
            @ConfigProperty(name="unlockCost", comment="Cost related properties for equipable slots")
            public final UnlockCost unlockCost = new UnlockCost(List.of(Integer.valueOf(30), Integer.valueOf(30), Integer.valueOf(30), Integer.valueOf(40)), SelectionFunction.INDEX_WITH_CLAMP);
        }

        public static class Cosmetics {
            @ConfigProperty(name="defaultCosmetic", comment="The default cosmetic (model) of the backpack. This should generally be a backpack\nthat is unlocked by default")
            public final StringProperty defaultCosmetic = StringProperty.create((String)"backpacked:vintage", (Validator)new IdentifierValidator("Value needs to be a match an existing backpack"));
            @ConfigProperty(name="disableCustomisation", comment="If enabled, prevents backpacks from being customised. This will remove the\ncustomise button from the backpack inventory")
            public final BoolProperty disableCustomisation = BoolProperty.create((boolean)false);
            @ConfigProperty(name="unlockAllCosmetics", comment="Allows every player to use any backpack cosmetic variant without needing to\ncomplete the challenges. Side note, any progress to a challenge will not be\ntracked while enabled.")
            public final BoolProperty unlockAllCosmetics = BoolProperty.create((boolean)false);
            @ConfigProperty(name="disabledCosmetics", comment="A list that contains ids of backpack cosmetics that will be disabled. The default\ncosmetic (as configured by defaultCosmetic) cannot be disabled even if added to this\nlist. You can grab the ID of backpacks by hovering them in the customisation screen\nwhile holding down CTRL button on your keyboard, and clicking will copy the ID to\nyour clipboard.\nExample: disabledCosmetics = [\"backpacked:rocket\", \"backpacked:classic\", \"backpacked:honey_jar\"]")
            public final ListProperty<String> disabledCosmetics = ListProperty.create((ListProperty.Type)ListProperty.STRING, (Validator)new IdentifierValidator(""));
        }

        public static class Inventory {
            @ConfigProperty(name="bannedItems", comment="A list of items that are not allowed inside the inventory of a backpack.\nNote: It is recommended to ban items that have an inventory as this will create\nlarge NBT data and potentially crash the server!")
            public final ListProperty<String> bannedItems = ListProperty.create((ListProperty.Type)ListProperty.STRING, (Validator)new IdentifierValidator("Value needs to be a valid item identifier"), Inventory::getDefaultBannedItems);
            @ConfigProperty(name="slots", comment="Slots related properties")
            public final Slots slots = new Slots();
            @ConfigProperty(name="size", comment="Size related properties")
            public final Size size = new Size();

            private static List<String> getDefaultBannedItems() {
                ArrayList<String> bannedItems = new ArrayList<String>();
                bannedItems.add("travelersbackpack:custom_travelers_backpack");
                bannedItems.add("pinesbarrels:better_barrel");
                bannedItems.add("quark:seed_pouch");
                bannedItems.add("quark:backpack");
                bannedItems.add("sophisticatedbackpacks:backpack");
                bannedItems.add("sophisticatedbackpacks:iron_backpack");
                bannedItems.add("sophisticatedbackpacks:gold_backpack");
                bannedItems.add("sophisticatedbackpacks:diamond_backpack");
                bannedItems.add("sophisticatedbackpacks:netherite_backpack");
                bannedItems.add("improvedbackpacks:tiny_pocket");
                bannedItems.add("improvedbackpacks:medium_pocket");
                bannedItems.add("improvedbackpacks:large_pocket");
                bannedItems.add("improvedbackpacks:white_backpack");
                bannedItems.add("improvedbackpacks:orange_backpack");
                bannedItems.add("improvedbackpacks:magenta_backpack");
                bannedItems.add("improvedbackpacks:light_blue_backpack");
                bannedItems.add("improvedbackpacks:yellow_backpack");
                bannedItems.add("improvedbackpacks:lime_backpack");
                bannedItems.add("improvedbackpacks:pink_backpack");
                bannedItems.add("improvedbackpacks:gray_backpack");
                bannedItems.add("improvedbackpacks:light_gray_backpack");
                bannedItems.add("improvedbackpacks:cyan_backpack");
                bannedItems.add("improvedbackpacks:purple_backpack");
                bannedItems.add("improvedbackpacks:blue_backpack");
                bannedItems.add("improvedbackpacks:brown_backpack");
                bannedItems.add("improvedbackpacks:green_backpack");
                bannedItems.add("improvedbackpacks:red_backpack");
                bannedItems.add("improvedbackpacks:black_backpack");
                bannedItems.add("immersiveengineering:toolbox");
                bannedItems.add("immersiveengineering:crate");
                bannedItems.add("immersiveengineering:reinforced_crate");
                bannedItems.add("create:white_toolbox");
                bannedItems.add("create:orange_toolbox");
                bannedItems.add("create:magenta_toolbox");
                bannedItems.add("create:light_blue_toolbox");
                bannedItems.add("create:yellow_toolbox");
                bannedItems.add("create:lime_toolbox");
                bannedItems.add("create:pink_toolbox");
                bannedItems.add("create:gray_toolbox");
                bannedItems.add("create:light_gray_toolbox");
                bannedItems.add("create:cyan_toolbox");
                bannedItems.add("create:purple_toolbox");
                bannedItems.add("create:blue_toolbox");
                bannedItems.add("create:brown_toolbox");
                bannedItems.add("create:green_toolbox");
                bannedItems.add("create:red_toolbox");
                bannedItems.add("create:black_toolbox");
                bannedItems.add("mekanism:personal_chest");
                bannedItems.add("supplementaries:sack");
                return bannedItems;
            }

            public static class Slots {
                @ConfigProperty(name="unlockAllSlots", comment="If set to true, all backpacks slots will be unlocked by default.\nWARNING: Reverting the option from true to false will cause items to be dropped\ninto the world if the slot they are in is now locked. You have been warned.")
                public final BoolProperty unlockAllSlots = BoolProperty.create((boolean)false);
                @ConfigProperty(name="initialUnlockedSlots", comment="The number of slots that will automatically be unlocked by default and for free.\nPlease note that the cost model will still factor these free slots into the calculation\nfor unlocking the next locked slot. The slots also cannot be revoked once unlocked.")
                public final IntProperty initialUnlockedSlots = IntProperty.create((int)9, (int)0, (int)253);
                @ConfigProperty(name="allowUnlockingUsingUnlockToken", comment="If set to true, backpack slots may be unlocked using Unlock Tokens")
                public final BoolProperty allowUnlockingUsingUnlockToken = BoolProperty.create((boolean)true);
                @ConfigProperty(name="unlockCost", comment="Cost related properties for inventory slots")
                public final UnlockCost unlockCost = new UnlockCost(InterpolateFunction.CUBIC, 1, 20);
            }

            public static class Size {
                @ConfigProperty(name="columns", comment="The amount of columns in the backpack inventory.\nWARNING: Larger than 15 columns will start to cut off GUI elements when using auto GUI\nscale. If you make the size of the backpack smaller, items in the backpack that no\nlonger fit will spawn into the world. Take care when changing this property on a\nrunning game/server since the changes will be automatically reloaded upon saving this file.")
                public final IntProperty columns = IntProperty.create((int)9, (int)1, (int)23);
                @ConfigProperty(name="rows", comment="The amount of rows in the backpack inventory.\nWARNING: Larger than 6 rows will not fit on some resolutions when using auto GUI scale.\nIf you make the size of the backpack smaller, items in the backpack that no\nlonger fit will spawn into the world. Take care when changing this property on a\nrunning game/server since the changes will be automatically reloaded upon saving this file.")
                public final IntProperty rows = IntProperty.create((int)5, (int)1, (int)11);
            }
        }

        public static class AugmentBays {
            @ConfigProperty(name="unlockFirstAugmentBay", comment="If true, the first augment bay will automatically be unlocked by default and for free.")
            public final BoolProperty unlockFirstAugmentBay = BoolProperty.create((boolean)false);
            @ConfigProperty(name="unlockAllAugmentBays", comment="If set to true, all augment bays will be unlocked by default.")
            public final BoolProperty unlockAllAugmentBays = BoolProperty.create((boolean)false);
            @ConfigProperty(name="allowUnlockingUsingUnlockToken", comment="If set to true, augment bays may be unlocked using Unlock Tokens")
            public final BoolProperty allowUnlockingUsingUnlockToken = BoolProperty.create((boolean)false);
            @ConfigProperty(name="unlockCost", comment="Cost related properties for augment bays")
            public final UnlockCost unlockCost = new UnlockCost(List.of(Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(30), Integer.valueOf(40)), SelectionFunction.INDEX_WITH_CLAMP);
        }

        public static class UnlockCost
        implements CostModel {
            @ConfigProperty(name="paymentType", comment="The type of payment to use to unlock backpack slots. By default this value is set to EXPERIENCE,\nwhich will use the players experience levels are used to unlock new slots. If value is set to\nITEM, this will instead consume a specified item from the player's inventory (including anything\nplaced in the backpack) to unlock new slots.")
            public final EnumProperty<PaymentType> paymentType = EnumProperty.create((Enum)PaymentType.EXPERIENCE);
            @ConfigProperty(name="paymentItem", comment="Only applicable if paymentType is set to ITEM. This option will control the item used when paying\nto unlock new slots.")
            public final StringProperty paymentItem = StringProperty.create((String)"minecraft:emerald", (Validator)new IdentifierValidator("Must be a valid resource location that matches the id of an item"));
            @ConfigProperty(name="costInterpolateFunction", comment="The interpolate method to use when calculating the cost of unlocking a slot. The cost\nof slots increases the more slots that are unlocked. This function determines how steep\nthe price will increase after each slot is unlocked. The interpolated value is calculated\nusing the minCost and maxCost.\n\nFunction Descriptions:\nLINEAR - A constant grow in the cost. Cost will jump by the same value after every slot unlocked.\nSQUARED - Slowly scales the cost for about half, then cost will increase noticeably for the final half.\nCUBIC - Very slowly scales the cost for about two thirds, then cost increases sharply for the final third.\n\nNote: This property has no effect if useCustomCosts is set to true\n")
            public final EnumProperty<InterpolateFunction> costInterpolateFunction;
            @ConfigProperty(name="minCost", comment="The minimum cost to unlock a backpack slot. This value would be the cost\nwhen unlocking the first slot in a backpack inventory. The cost to unlock\nsubsequent slots are interpolated from the this value to the maxCost, and\nscaled by the scaleFunction.\n\nNote: This property has no effect if useCustomCosts is set to true")
            public final IntProperty minCost;
            @ConfigProperty(name="maxCost", comment="The maximum cost to unlock a backpack slot. This value would be the cost\nwhen unlocking the final slot in a backpack inventory. The cost to unlock\nprior slots are interpolated from the minCost to this value, and scaled\nby the scaleFunction.\n\nNote: This property has no effect if useCustomCosts is set to true")
            public final IntProperty maxCost;
            @ConfigProperty(name="useCustomCosts", comment="If enabled, instead of using a cost that is calculated based on a minCost\nand maxCost, custom costs allow the cost to be specified manually using\na list of values (see customCosts).")
            public final BoolProperty useCustomCosts;
            @ConfigProperty(name="customCosts", comment="A list of numbers that represent the cost values, must be whole and positive\nnumbers only. See customCostsSelectionFunction property to set the behaviour of\nhow values are selected from the custom costs list.\n")
            public final ListProperty<Integer> customCosts;
            @ConfigProperty(name="customCostsSelectionFunction", comment="Determines how the cost value is selected from the customCosts list.\n\nPossible Functions:\nLINEAR_INTERPOLATION - This will count how many slots/bays are unlocked plus one and divide it by the\n                       maximum unlockable slots/bays. For example, if 10 out of 20 slots are unlocked,\n                       a value of 11 divided by 20 will be evaluated and that will equal 0.55 or 55%.\n                       A cost value is then picked out of the customCosts list at the position that\n                       represents 55% percent of the lists length. So if customCosts contained 20 values, it\n                       will be picking the 11th value. The formula is custom_costs_length * ((unlocked_count + 1) / total_unlockable).\n                       (See below for real examples)\nINDEX_WITH_CLAMP     - This option will exactly match the next unlock count to an index in the customCosts\n                       list. For example, if 10 out of 20 slots are unlocked, the next unlock count will\n                       be 11, so the 11th value in the custom costs list will be used as the cost to\n                       unlock the next slot/bay. This option will safely handle cases where if the 11th value\n                       doesn't exist, due the custom costs list containing less than 11 values, the last\n                       value in the list will be selected. (See below for real examples)\n\nExamples:\n1. Backpack has 27 unlockable slots, and this option is set to INDEX_WITH_CLAMP. The custom costs\nlist contains the values [5, 5, 5, 5, 5, 10]. This is interpreted as \"the first five unlock costs\nwill be 5, all the remaining will cost 10\".\n\n2. Backpack has 3 unlockable augment bays, and this option is set to INDEX_WITH_CLAMP. The custom\ncost lists contains the values [5, 10, 15]. This is interpreted as \"the first augment bay will\ncost 5, the second will cost 10, and the final will cost 15\".\n\n3. Backpack has 18 unlockable slots, and this option is set to LINEAR_INTERPOLATION. The custom costs\nlist contains the values [1, 100]. This is interpreted as \"the first nine unlock costs will\ncost 1, then the final nine will cost 100\".\n\n4. Backpack has 9 unlockable slots, and this option is set to LINEAR_INTERPOLATION, and the custom costs\nlist contains the values [1, 2, 3, 4, 5, 6, 7, 8, 9]. Since the count of the unlockable slots (9) and the\nlength of the customCosts list (9) are the exact same, the first unlock cost will be 1, the\nsecond 2, the third 3, and so on until 9. However, if you bumped the backpack to 18 unlockable slots,\nthis would then change to, the first two unlock costs will be 1, the next two unlock costs will be 2, the\nfollowing two unlock costs will be 3.\n\nNote from MrCrayfish:\nThis may seem confusing (and it is), but just play around with this config property. Always start with a\nfresh backpack everytime you change this property, or you may not see how the property affects the selection\nprocess. I suggest starting with LINEAR_INTERPOLATION and then adding enough values to the customCosts list\nso it matches the number of slots in the backpack (so if the backpack has 54 slots, put 54 values into customCosts).\nOnce you've tried that, half the number of values in customCosts (so if 54 slots, put 27 values into customCosts)\nand this will give you an understanding of how the function works. Then afterwards, try INDEX_WITH_CLAMP but set\nthe values [1, 2, 3] as the customCosts. You will see the first unlock cost 1, the second cost 2, and every other\nunlock will cost 3.\n")
            public final EnumProperty<SelectionFunction> customCostsSelectionFunction;

            public UnlockCost(InterpolateFunction defaultFunction, int defaultMinCost, int defaultMaxCost) {
                this.costInterpolateFunction = EnumProperty.create((Enum)defaultFunction);
                this.minCost = IntProperty.create((int)defaultMinCost, (int)1, (int)100);
                this.maxCost = IntProperty.create((int)defaultMaxCost, (int)1, (int)100);
                this.useCustomCosts = BoolProperty.create((boolean)false);
                this.customCosts = ListProperty.create((ListProperty.Type)ListProperty.INT);
                this.customCostsSelectionFunction = EnumProperty.create((Enum)SelectionFunction.LINEAR_INTERPOLATION);
            }

            public UnlockCost(List<Integer> customCosts, SelectionFunction selectionFunction) {
                this.costInterpolateFunction = EnumProperty.create((Enum)InterpolateFunction.LINEAR);
                this.minCost = IntProperty.create((int)10, (int)1, (int)100);
                this.maxCost = IntProperty.create((int)40, (int)1, (int)100);
                this.useCustomCosts = BoolProperty.create((boolean)true);
                this.customCosts = ListProperty.create((ListProperty.Type)ListProperty.INT, () -> customCosts);
                this.customCostsSelectionFunction = EnumProperty.create((Enum)selectionFunction);
            }

            @Override
            public PaymentType getPaymentType() {
                return (PaymentType)((Object)this.paymentType.get());
            }

            @Override
            public String getPaymentItemId() {
                return (String)this.paymentItem.get();
            }

            @Override
            public InterpolateFunction getInterpolateFunction() {
                return (InterpolateFunction)((Object)this.costInterpolateFunction.get());
            }

            @Override
            public int getMinCost() {
                return (Integer)this.minCost.get();
            }

            @Override
            public int getMaxCost() {
                return (Integer)this.maxCost.get();
            }

            @Override
            public boolean useCustomCosts() {
                return (Boolean)this.useCustomCosts.get();
            }

            @Override
            public List<Integer> getCustomCosts() {
                return (List)this.customCosts.get();
            }

            @Override
            public SelectionFunction getCustomCostsSelectionFunction() {
                return (SelectionFunction)((Object)this.customCostsSelectionFunction.get());
            }
        }
    }

    public static class Augments {
        @ConfigProperty(name="disabledAugments", comment="A list that contains ids of augments that should be disabled. The augments will be\nhidden from the popup menu and cannot be selected. Augments applied on existing\nbackpacks will simply be removed. Use advanced tooltips (F3 + H) to discover the IDs\nof augments.\nExample: disabledAugments = [\"backpacked:recall\", \"backpacked:lootbound\"]")
        public final ListProperty<String> disabledAugments = ListProperty.create((ListProperty.Type)ListProperty.STRING, (Validator)new IdentifierValidator(""));
        @ConfigProperty(name="funnelling", comment="Funnelling related properties")
        public final Funnelling funnelling = new Funnelling();
        @ConfigProperty(name="hopperBridge", comment="Hopper Bridge related properties")
        public final HopperBridge hopperBridge = new HopperBridge();
        @ConfigProperty(name="imbuedHide", comment="Hopper Bridge related properties")
        public final ImbuedHide imbuedHide = new ImbuedHide();
        @ConfigProperty(name="immortal", comment="Immortal related properties")
        public final Immortal immortal = new Immortal();

        public static class Funnelling {
            @ConfigProperty(name="maxFilters", comment="The maximum amount of filters that can be configured")
            public final IntProperty maxFilters = IntProperty.create((int)32, (int)1, (int)256);
        }

        public static class HopperBridge {
            @ConfigProperty(name="maxFilters", comment="The maximum amount of filters that can be configured")
            public final IntProperty maxFilters = IntProperty.create((int)32, (int)1, (int)256);
        }

        public static class ImbuedHide {
            @ConfigProperty(name="fireImmunity", comment="If enabled, Imbued Hide will make the backpack immune to fire regardless of the damage source")
            public final BoolProperty fireImmunity = BoolProperty.create((boolean)true);
            @ConfigProperty(name="invulnerableToDamageTypes", comment="A list containing ids of damage types that the backpack will be invulnerable to when Imbued Hide is applied.\nYou can discover all valid damage types in-game by pasting in the command (include all characters between the quotes): \"/damage @s 1 \"\nExample: invulnerableToDamageTypes = [\"minecraft:cactus\", \"minecraft:explosion\"]")
            public final ListProperty<String> invulnerableToDamageTypes = ListProperty.create((ListProperty.Type)ListProperty.STRING, (Validator)new IdentifierValidator("Must be a valid damage type"), () -> List.of(class_8111.field_42344.method_29177().toString(), class_8111.field_42331.method_29177().toString(), class_8111.field_42333.method_29177().toString()));
        }

        public static class Immortal {
            @ConfigProperty(name="cooldown", comment="The amount of ticks to wait after Immortal has been triggered for it to be able to be triggered again.\nBy default, Immortal is set to 1 minute. Use the formula: ticks = 20 * <seconds>")
            public final IntProperty cooldown = IntProperty.create((int)1200, (int)0, (int)Integer.MAX_VALUE);
        }
    }

    public static class Client {
        @ConfigProperty(name="hideConfigButton", comment="If enabled, hides the config button from the backpack screen")
        public final BoolProperty hideConfigButton = BoolProperty.create((boolean)false);
        @ConfigProperty(name="unlockableSlotMode", comment="Determines how unlockable slots are displayed and interactions are handled. This\noption can be changed directly in the backpack inventory GUI.\n\nMode descriptions:\nENABLED     - Unlockable slots will always be enabled (visible and interactable).\nPURCHASABLE - Unlockable slots will only be enabled if the player has has exp levels\n              to purchase/unlock the slot, otherwise they will be disabled (faded out\n              and not interactable).\nDISABLED    - Unlockable slots will always be disabled. (faded out and not interactable).\n")
        public final EnumProperty<UnlockableSlotMode> unlockableSlotMode = EnumProperty.create((Enum)UnlockableSlotMode.ENABLED);
        @ConfigProperty(name="glitterBomb", comment="Very secret feature, do not enable if you don't want your screen filled with particle effects")
        public final BoolProperty glitterBomb = BoolProperty.create((boolean)false);
        @ConfigProperty(name="hideAddonsCallToAction", comment="If enabled, hides the call to action at the bottom of the customisation menu which links out to community addons and a guide.")
        public final BoolProperty hideAddonsCallToAction = BoolProperty.create((boolean)false);
    }

    public static class Pickpocketing {
        @ConfigProperty(name="enabledPickpocketing", comment="If enabled, allows players to access the backpack of another player by interacting\nwith the visible backpack on their back.")
        public final BoolProperty enabled = BoolProperty.create((boolean)true);
        @ConfigProperty(name="maxReachDistance", comment="The maximum reach distance of a player to interact with another player's backpack.")
        public final DoubleProperty maxReachDistance = DoubleProperty.create((double)2.0, (double)0.0, (double)4.0);
        @ConfigProperty(name="maxAngleRange", comment="The maximum angle at which another player's backpack can be accessed.\nThink of this as how directly behind the backpack the player needs to be\nin order to pickpocket. A smaller range prevents the player from accessing\nthe backpack from the side.")
        public final DoubleProperty maxRangeAngle = DoubleProperty.create((double)80.0, (double)0.0, (double)90.0);
    }

    public static class WanderingTrader {
        @ConfigProperty(name="enableBackpack", comment="If enabled, wandering traders will have a chance to spawn with a backpack")
        public final BoolProperty enableBackpack = BoolProperty.create((boolean)true);
        @ConfigProperty(name="spawnWithBackpackChance", comment="The chance a Wandering Trader will spawn with a backpack. The chance is interpreted\nas one out of x, with x being the number given from this config option.")
        public final IntProperty spawnWithBackpackChance = IntProperty.create((int)2, (int)1, (int)100);
        @ConfigProperty(name="pickpocketingChallenge")
        public final PickpocketingChallenge challenge = new PickpocketingChallenge();

        public static class PickpocketingChallenge {
            @ConfigProperty(name="maxDetectionDistance", comment="The maximum distance a Wandering Trader can detect a player. The longer the\ndistance, the more difficult the challenge to pickpocket their backpack.")
            public final DoubleProperty maxDetectionDistance = DoubleProperty.create((double)10.0, (double)1.0, (double)32.0);
            @ConfigProperty(name="timeToForgetPlayer", comment="The time (in ticks) a Wandering Trader will wait before it decides to forget\nabout a detected player. The Wandering Trader will wait indefinitely if the\ndetected player is within the maximum detection distance.")
            public final IntProperty timeToForgetPlayer = IntProperty.create((int)200, (int)1, (int)12000);
            @ConfigProperty(name="dislikedPlayersCanTrade", comment="If true, allows players who are disliked by Wandering Traders to continue to\ntrade normally with them. A player is considered disliked if they are caught when\ntrying to pickpocket a Wandering Trader's backpack.")
            public final BoolProperty dislikedPlayersCanTrade = BoolProperty.create((boolean)false);
            @ConfigProperty(name="dislikeCooldown", comment="The amount of time (in ticks) a player has to wait before a Wandering Trader will\nlike them again. If a player gets caught pickpocketing a Wandering Trader, the\ncooldown will be reset")
            public final IntProperty dislikeCooldown = IntProperty.create((int)6000, (int)0, (int)24000);
            @ConfigProperty(name="generateEmeraldsOnly", comment="Instead of generating trades as loot in the Wandering Traders backpacks, only generate emeralds.")
            public final BoolProperty generateEmeraldsOnly = BoolProperty.create((boolean)false);
            @ConfigProperty(name="maxLootMultiplier", comment="The maximum multiplier to apply when generating loot in the Wandering Trader backpack.")
            public final IntProperty maxLootMultiplier = IntProperty.create((int)12, (int)1, (int)64);
            @ConfigProperty(name="maxEmeraldStack", comment="The maximum size of an emerald stack that can generate in the Wandering Trader backpack.")
            public final IntProperty maxEmeraldStack = IntProperty.create((int)32, (int)1, (int)64);
        }
    }

    public record IdentifierValidator(String hint) implements Validator<String>
    {
        public boolean test(String value) {
            return class_2960.method_12829((String)value) != null;
        }

        public class_2561 getHint() {
            return class_2561.method_43470((String)this.hint);
        }
    }
}

