/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.InventoryAugmentSnapshot;
import com.mrcrayfish.backpacked.common.Navigate;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class BackpackHelper {
    public static int getSelectedBackpackIndex(class_1657 player) {
        BackpackHelper.updateSelectedBackpackIndex(player);
        return (Integer)ModSyncedDataKeys.SELECTED_BACKPACK.getValue((class_1297)player);
    }

    private static void updateSelectedBackpackIndex(class_1657 player) {
        int selected = (Integer)ModSyncedDataKeys.SELECTED_BACKPACK.getValue((class_1297)player);
        if (BackpackHelper.getBackpackStack(player, selected).method_7960()) {
            int radius = 1;
            if (selected == -1) {
                selected = 0;
                radius = 0;
            }
            while (radius <= ManagementInventory.getMaxEquipable()) {
                class_1799 stack = BackpackHelper.getBackpackStack(player, selected + radius);
                if (!stack.method_7960()) {
                    ModSyncedDataKeys.SELECTED_BACKPACK.setValue((class_1297)player, (Object)(selected + radius));
                    return;
                }
                if (radius > 0 && !(stack = BackpackHelper.getBackpackStack(player, selected - radius)).method_7960()) {
                    ModSyncedDataKeys.SELECTED_BACKPACK.setValue((class_1297)player, (Object)(selected - radius));
                    return;
                }
                ++radius;
            }
            ModSyncedDataKeys.SELECTED_BACKPACK.setValue((class_1297)player, (Object)-1);
        }
    }

    public static int navigateBackpackIndex(class_1657 player, int currentIndex, Navigate navigate) {
        int newSelected = currentIndex + navigate.step();
        if (newSelected != currentIndex) {
            while (newSelected >= 0 && newSelected < ManagementInventory.getMaxEquipable()) {
                class_1799 stack = BackpackHelper.getBackpackStack(player, newSelected);
                if (!stack.method_7960()) {
                    return newSelected;
                }
                newSelected += navigate.step();
            }
        }
        return currentIndex;
    }

    public static int firstAvailableBackpackIndex(class_1657 player) {
        for (int i = 0; i < ManagementInventory.getMaxEquipable(); ++i) {
            class_1799 stack = BackpackHelper.getBackpackStack(player, i);
            if (stack.method_7960()) continue;
            return i;
        }
        return -1;
    }

    public static class_1799 getBackpackStack(class_1657 player, int index) {
        if (index < 0 || index >= ManagementInventory.getMaxEquipable()) {
            return class_1799.field_8037;
        }
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(player);
        if (!slots.isUnlocked(index)) {
            return class_1799.field_8037;
        }
        class_2371<class_1799> backpacks = BackpackHelper.getBackpacks(player);
        class_1799 stack = (class_1799)backpacks.get(index);
        if (stack.method_7960() && !(stack = (class_1799)ModSyncedDataKeys.BACKPACK.getValue((class_1297)player)).method_7960()) {
            BackpackHelper.setBackpackStack(player, stack, index);
            ModSyncedDataKeys.BACKPACK.setValue((class_1297)player, (Object)class_1799.field_8037);
        }
        return stack;
    }

    public static boolean setBackpackStack(class_1657 player, class_1799 stack, int index) {
        if (index < 0 || index >= ManagementInventory.getMaxEquipable()) {
            return false;
        }
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(player);
        if (!slots.isUnlocked(index)) {
            return false;
        }
        if (stack.method_31574((class_1792)ModItems.BACKPACK.get())) {
            BackpackHelper.getBackpacks(player).set(index, (Object)stack);
            return true;
        }
        return false;
    }

    public static class_2371<class_1799> getBackpacks(class_1657 player) {
        class_2371 backpacks = (class_2371)ModSyncedDataKeys.BACKPACKS.getValue((class_1297)player);
        if (backpacks.size() != ManagementInventory.getMaxEquipable()) {
            class_2371 newBackpacks = class_2371.method_10213((int)ManagementInventory.getMaxEquipable(), (Object)class_1799.field_8037);
            InventoryHelper.mergeItemsOrSpawnIntoLevel((class_2371<class_1799>)backpacks, (class_2371<class_1799>)newBackpacks, player.method_73183(), player.method_73189());
            ModSyncedDataKeys.BACKPACKS.setValue((class_1297)player, (Object)newBackpacks);
            backpacks = newBackpacks;
        }
        return backpacks;
    }

    public static UnlockableSlots getBackpackUnlockableSlots(class_1657 player) {
        int initialUnlocked;
        UnlockableSlots before;
        if (((Boolean)Config.BACKPACK.equipable.unlockAllEquipableSlots.get()).booleanValue()) {
            return UnlockableSlots.ALL;
        }
        UnlockableSlots slots = (UnlockableSlots)ModSyncedDataKeys.UNLOCKABLE_BACKPACK_SLOTS.getValue((class_1297)player);
        if (slots.getMaxSlots() != ManagementInventory.getMaxEquipable()) {
            slots = slots.setMaxSlots(ManagementInventory.getMaxEquipable());
            ModSyncedDataKeys.UNLOCKABLE_BACKPACK_SLOTS.setValue((class_1297)player, (Object)slots);
        }
        if ((before = slots) != (slots = BackpackHelper.unlockInitialSlots(slots, initialUnlocked = ((Integer)Config.BACKPACK.equipable.initialUnlockedEquipableSlots.get()).intValue()))) {
            ModSyncedDataKeys.UNLOCKABLE_BACKPACK_SLOTS.setValue((class_1297)player, (Object)slots);
        }
        return slots;
    }

    public static UnlockableSlots unlockInitialSlots(UnlockableSlots slots, int initialCount) {
        if ((initialCount = class_3532.method_15340((int)initialCount, (int)0, (int)slots.getMaxSlots())) > 0 && slots.getUnlockCount() < initialCount) {
            int unlockCount = slots.getUnlockCount();
            ArrayList<Integer> unlockSlots = new ArrayList<Integer>();
            for (int i = 0; i < slots.getMaxSlots() && unlockCount < initialCount; ++i) {
                if (slots.isUnlocked(i)) continue;
                unlockSlots.add(i);
                ++unlockCount;
            }
            if (!unlockSlots.isEmpty()) {
                return slots.unlockSlots(unlockSlots);
            }
        }
        return slots;
    }

    public static void setBackpackUnlockableSlots(class_1657 player, UnlockableSlots slots) {
        if (((Boolean)Config.BACKPACK.equipable.unlockAllEquipableSlots.get()).booleanValue()) {
            return;
        }
        if (slots.getMaxSlots() != ManagementInventory.getMaxEquipable()) {
            slots = slots.setMaxSlots(ManagementInventory.getMaxEquipable());
        }
        ModSyncedDataKeys.UNLOCKABLE_BACKPACK_SLOTS.setValue((class_1297)player, (Object)slots);
    }

    public static class_1799 getFirstBackpackStack(class_1657 player) {
        return BackpackHelper.getFirstBackpackStack(player, stack -> true);
    }

    public static class_1799 getFirstBackpackStack(class_1657 player, Predicate<class_1799> filter) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(player);
        class_2371<class_1799> backpacks = BackpackHelper.getBackpacks(player);
        for (int i = 0; i < backpacks.size(); ++i) {
            class_1799 stack;
            if (!slots.isUnlocked(i) || (stack = (class_1799)backpacks.get(i)).method_7960() || !filter.test(stack)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public static boolean equipBackpack(class_1657 player, class_1799 stack) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(player);
        class_2371<class_1799> backpacks = BackpackHelper.getBackpacks(player);
        for (int i = 0; i < backpacks.size(); ++i) {
            if (!slots.isUnlocked(i) || !((class_1799)backpacks.get(i)).method_7960()) continue;
            backpacks.set(i, (Object)stack.method_51164());
            return true;
        }
        return false;
    }

    public static class_2371<class_1799> removeAllBackpacks(class_1657 player) {
        class_2371<class_1799> backpacks = BackpackHelper.getBackpacks(player);
        ModSyncedDataKeys.BACKPACKS.setValue((class_1297)player, (Object)class_2371.method_10213((int)ManagementInventory.getMaxEquipable(), (Object)class_1799.field_8037));
        return backpacks;
    }

    public static Pagination createPaginationInfo(class_1657 owner, int backpackIndex) {
        IntArrayList list = new IntArrayList();
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(owner);
        class_2371<class_1799> backpacks = BackpackHelper.getBackpacks(owner);
        for (int i = 0; i < backpacks.size(); ++i) {
            if (!slots.isUnlocked(i) || ((class_1799)backpacks.get(i)).method_7960()) continue;
            list.add(i);
        }
        int currentPage = !list.isEmpty() ? list.indexOf(backpackIndex) : 0;
        int totalPages = list.size();
        return new Pagination(currentPage + 1, totalPages);
    }

    @Nullable
    public static <T extends Augment<T>> T findAugment(class_1799 stack, AugmentType<T> type) {
        if (Config.getDisabledAugments().contains(type.id())) {
            return null;
        }
        Augments augments = Augments.get(stack);
        UnlockableSlots bays = BackpackHelper.getUnlockableAugmentBays(stack);
        if (bays.isUnlocked(0) && augments.firstState() && augments.firstAugment().type() == type) {
            return (T)augments.firstAugment();
        }
        if (bays.isUnlocked(1) && augments.secondState() && augments.secondAugment().type() == type) {
            return (T)augments.secondAugment();
        }
        if (bays.isUnlocked(2) && augments.thirdState() && augments.thirdAugment().type() == type) {
            return (T)augments.thirdAugment();
        }
        if (bays.isUnlocked(3) && augments.fourthState() && augments.fourthAugment().type() == type) {
            return (T)augments.fourthAugment();
        }
        return null;
    }

    public static UnlockableSlots getUnlockableAugmentBays(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem item = (BackpackItem)class_17922;
            return item.getUnlockableAugmentBays(stack);
        }
        return UnlockableSlots.NONE;
    }

    public static <T extends Augment<T>> List<InventoryAugmentSnapshot.One<T>> getBackpackInventoriesWithAugment(class_1657 player, AugmentType<T> type) {
        BackpackedInventoryAccess access = (BackpackedInventoryAccess)player;
        return access.backpacked$streamNonNullBackpackInventories().map(inventory -> {
            Object augment = BackpackHelper.findAugment(inventory.getBackpackStack(), type);
            return new InventoryAugmentSnapshot.One((BackpackInventory)inventory, augment);
        }).filter(result -> Objects.nonNull(result.augment())).toList();
    }

    public static <T extends Augment<T>, R extends Augment<R>> List<InventoryAugmentSnapshot.Two<T, R>> getBackpackInventoriesWithAugment(class_1657 player, AugmentType<T> firstType, AugmentType<R> secondType) {
        BackpackedInventoryAccess access = (BackpackedInventoryAccess)player;
        return access.backpacked$streamNonNullBackpackInventories().map(inventory -> {
            class_1799 stack = inventory.getBackpackStack();
            Object firstAugment = BackpackHelper.findAugment(stack, firstType);
            Object secondAugment = BackpackHelper.findAugment(stack, secondType);
            if (firstAugment == null || secondAugment == null) {
                return null;
            }
            return new InventoryAugmentSnapshot.Two((BackpackInventory)inventory, firstAugment, secondAugment);
        }).filter(Objects::nonNull).toList();
    }

    public static boolean isCosmeticDisabled(class_2960 id) {
        return ((List)Config.BACKPACK.cosmetics.disabledCosmetics.get()).contains(id.toString());
    }
}

