/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.Registration;
import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.menu.IMenuData;
import com.mrcrayfish.framework.api.registry.BlockRegistryEntry;
import com.mrcrayfish.framework.api.registry.FrameworkRegistry;
import com.mrcrayfish.framework.api.registry.RegistryContainer;
import com.mrcrayfish.framework.platform.Services;
import com.mrcrayfish.framework.platform.services.IRegistrationHelper;
import com.mrcrayfish.framework.registry.VanillaRegistryProxy;
import com.mrcrayfish.framework.util.ReflectionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.commons.lang3.function.TriFunction;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;

public class FabricRegistrationHelper
implements IRegistrationHelper {
    private final Set<Class<?>> registryClasses = new HashSet();
    private boolean loadedRegistryClasses;

    @Override
    public void init() {
        Services.REGISTRATION.getRegistryObjects(FrameworkRegistry.class).forEach(registry -> {
            Constants.LOG.debug("Registering custom registry: {}", (Object)registry.getKey().method_29177());
            FabricRegistryBuilder builder = FabricRegistryBuilder.createSimple(registry.getKey());
            if (registry.shouldSync()) {
                builder.attribute(RegistryAttribute.SYNCED);
            }
            registry.setProxy(VanillaRegistryProxy.wrap(builder.buildAndRegister()));
        });
        Registration.getSortedRegistryEntries().forEach(entry -> entry.register((registryKey, name, valueSupplier) -> {
            class_2378 registry = (class_2378)class_7923.field_41167.method_63535(registryKey.method_29177());
            if (registry == null) {
                throw new NullPointerException("Registry not found: " + String.valueOf(registryKey));
            }
            class_2378.method_10230((class_2378)registry, (class_2960)name, valueSupplier.get());
        }));
        Registration.get(class_7924.field_41254).forEach(entry -> {
            if (entry instanceof BlockRegistryEntry) {
                BlockRegistryEntry blockEntry = (BlockRegistryEntry)entry;
                blockEntry.item().ifPresent(item -> class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.getId(), (Object)item));
            }
        });
    }

    @Override
    public <T> List<T> getRegistryObjects(Class<T> objectType) {
        if (!this.loadedRegistryClasses) {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(this.getScanPackages()).addScanners(new Scanner[]{Scanners.TypesAnnotated}));
            String annotationClassName = RegistryContainer.class.getName();
            String annotationDescriptor = RegistryContainer.class.descriptorString();
            Map store = (Map)reflections.getStore().get((Object)Scanners.TypesAnnotated.name());
            for (String registryClass : store.getOrDefault(annotationClassName, Collections.emptySet())) {
                Map<String, Object> data = this.readAnnotationData(registryClass, annotationDescriptor);
                boolean clientOnly = (Boolean)data.getOrDefault("clientOnly", false);
                if (clientOnly && !FrameworkAPI.getEnvironment().isClient()) continue;
                this.registryClasses.add(ReflectionUtils.getClass(registryClass));
            }
            this.loadedRegistryClasses = true;
        }
        return this.registryClasses.stream().flatMap(holderClass -> ReflectionUtils.findPublicStaticObjects(objectType, holderClass).stream()).collect(Collectors.toList());
    }

    private String[] getScanPackages() {
        return (String[])FabricLoader.getInstance().getAllMods().stream().map(this::getScanPackages).flatMap(Collection::stream).toArray(String[]::new);
    }

    private List<String> getScanPackages(ModContainer container) {
        CustomValue.CvObject frameworkObj;
        CustomValue containersValue;
        CustomValue value = container.getMetadata().getCustomValue("framework");
        if (value != null && value.getType() == CustomValue.CvType.OBJECT && (containersValue = (frameworkObj = value.getAsObject()).get("containers")) != null) {
            if (containersValue.getType() == CustomValue.CvType.ARRAY) {
                ArrayList<String> packages = new ArrayList<String>();
                CustomValue.CvArray packagesArray = containersValue.getAsArray();
                packagesArray.forEach(packageValue -> {
                    if (packageValue.getType() == CustomValue.CvType.STRING) {
                        packages.add(packageValue.getAsString());
                    }
                });
                return packages;
            }
            if (containersValue.getType() == CustomValue.CvType.STRING) {
                return Collections.singletonList(containersValue.getAsString());
            }
        }
        return Collections.emptyList();
    }

    private Map<String, Object> readAnnotationData(String className, String annotationDescriptor) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try (InputStream is = FabricRegistrationHelper.class.getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");){
            if (is != null) {
                ClassReader reader = new ClassReader(is);
                reader.accept((ClassVisitor)new AnnotationDataCollector(annotationDescriptor, data), 6);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    @Override
    public <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> function, Supplier<class_2248[]> validBlocksSupplier) {
        return FabricBlockEntityTypeBuilder.create(function::apply, (class_2248[])validBlocksSupplier.get()).build();
    }

    @Override
    public <T extends class_1703> class_3917<T> createMenuType(BiFunction<Integer, class_1661, T> function) {
        return new class_3917(function::apply, class_7701.field_40183);
    }

    @Override
    public <T extends class_1703, D extends IMenuData<D>> class_3917<T> createMenuTypeWithData(class_9139<class_9129, D> codec, TriFunction<Integer, class_1661, D, T> function) {
        return new ExtendedScreenHandlerType((arg_0, arg_1, arg_2) -> function.apply(arg_0, arg_1, arg_2), codec);
    }

    @Override
    public <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> I createArgumentTypeInfo(Class<A> argumentTypeClass, Supplier<I> supplier) {
        class_2314 instance = (class_2314)supplier.get();
        class_2316.field_10921.put(argumentTypeClass, instance);
        return (I)instance;
    }

    @Override
    public class_1761.class_7913 createCreativeModeTabBuilder() {
        return FabricItemGroup.builder();
    }

    private static class AnnotationDataCollector
    extends ClassVisitor {
        private final String targetDescriptor;
        private final Map<String, Object> data;

        private AnnotationDataCollector(String targetDescriptor, Map<String, Object> data) {
            super(589824);
            this.targetDescriptor = targetDescriptor;
            this.data = data;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals(this.targetDescriptor)) {
                return new AnnotationVisitor(this.api){

                    public void visit(String name, Object value) {
                        data.put(name, value);
                    }
                };
            }
            return null;
        }
    }
}

