/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.configuration;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.ConfigurationMessageContext;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import com.mrcrayfish.framework.network.message.ConfigurationMessage;
import java.util.concurrent.CountDownLatch;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public record S2CConfigData(class_2960 key, byte[] data) {
    public static final class_9139<class_2540, S2CConfigData> STREAM_CODEC = class_9139.method_56437((buf, data) -> {
        buf.method_10812(data.key);
        buf.method_52983(data.data);
    }, buf -> {
        class_2960 key = buf.method_10810();
        byte[] data = new byte[buf.readableBytes()];
        buf.method_52979(data);
        return new S2CConfigData(key, data);
    });

    public static void handle(S2CConfigData message, ConfigurationMessageContext context) {
        Constants.LOG.debug(ConfigurationMessage.MARKER, "Receiving config data from server: '{}'", (Object)message.key());
        boolean[] failed = new boolean[1];
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            try {
                if (!FrameworkConfigManager.getInstance().processConfigData(message)) {
                    failed[0] = true;
                }
            }
            catch (Exception e) {
                failed[0] = true;
                Constants.LOG.error(ConfigurationMessage.MARKER, "Fatal error when trying to process sync config", (Throwable)e);
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException ignored) {
            failed[0] = true;
        }
        if (failed[0]) {
            context.disconnect((class_2561)class_2561.method_43471((String)"framework.gui.sync_config_failed"));
        }
    }
}

